/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.util;

import io.wispforest.owo.Owo;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.parsing.UIModelLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class UIErrorToast
implements class_368 {
    private final List<class_5481> errorMessage;
    private final class_327 textRenderer;
    private final int width;
    private class_368.class_369 visibility = class_368.class_369.field_2209;

    public UIErrorToast(Throwable error) {
        this.textRenderer = class_310.method_1551().field_1772;
        List<class_2561> texts = this.initText(String.valueOf(error.getMessage()), consumer -> {
            StackTraceElement stackTop = error.getStackTrace()[0];
            String[] errorLocation = stackTop.getClassName().split("\\.");
            consumer.accept(class_2561.method_43470((String)"Type: ").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)error.getClass().getSimpleName()).method_27692(class_124.field_1080)));
            consumer.accept(class_2561.method_43470((String)"Thrown by: ").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)(errorLocation[errorLocation.length - 1] + ":" + stackTop.getLineNumber())).method_27692(class_124.field_1080)));
        });
        this.width = Math.min(240, TextOps.width(this.textRenderer, texts) + 8);
        this.errorMessage = this.wrap(texts);
    }

    public UIErrorToast(String message) {
        this.textRenderer = class_310.method_1551().field_1772;
        List<class_2561> texts = this.initText(message, consumer -> consumer.accept(class_2561.method_43470((String)"No context provided").method_27692(class_124.field_1080)));
        this.width = Math.min(240, TextOps.width(this.textRenderer, texts) + 8);
        this.errorMessage = this.wrap(texts);
    }

    public static void report(String message) {
        UIErrorToast.logErrorsDuringInitialLoad();
        class_310.method_1551().method_1566().method_1999((class_368)new UIErrorToast(message));
    }

    public static void report(Throwable error) {
        UIErrorToast.logErrorsDuringInitialLoad();
        class_310.method_1551().method_1566().method_1999((class_368)new UIErrorToast(error));
    }

    private static void logErrorsDuringInitialLoad() {
        if (UIModelLoader.hasCompletedInitialLoad()) {
            return;
        }
        Throwable throwable = new Throwable();
        Owo.LOGGER.error("An owo-ui error has occurred during the initial resource reload (on thread {}). This is likely a bug caused by *some* other mod initializing an owo-config screen significantly too early - please report it at https://github.com/wisp-forest/owo-lib/issues", (Object)Thread.currentThread().getName(), (Object)throwable);
    }

    public void method_61989(class_374 manager, long time) {
        this.visibility = time > 10000L ? class_368.class_369.field_2209 : class_368.class_369.field_2210;
    }

    public class_368.class_369 method_61988() {
        return this.visibility;
    }

    public void method_1986(class_332 context, class_327 textRenderer, long startTime) {
        OwoUIDrawContext owoContext = OwoUIDrawContext.of(context);
        owoContext.method_25294(0, 0, this.method_29049(), this.method_29050(), 0x77000000);
        owoContext.drawRectOutline(0, 0, this.method_29049(), this.method_29050(), -1476460544);
        int xOffset = this.method_29049() / 2 - this.textRenderer.method_30880(this.errorMessage.get(0)) / 2;
        owoContext.method_35720(this.textRenderer, this.errorMessage.get(0), 4 + xOffset, 4, -1);
        for (int i = 1; i < this.errorMessage.size(); ++i) {
            owoContext.method_51430(this.textRenderer, this.errorMessage.get(i), 4, 4 + i * 11, -1, false);
        }
    }

    public int method_29050() {
        return 6 + this.errorMessage.size() * 11;
    }

    public int method_29049() {
        return this.width;
    }

    private List<class_2561> initText(String errorMessage, Consumer<Consumer<class_2561>> contextAppender) {
        ArrayList<class_2561> texts = new ArrayList<class_2561>();
        texts.add((class_2561)class_2561.method_43470((String)"owo-ui error").method_27692(class_124.field_1061));
        texts.add((class_2561)class_2561.method_43470((String)" "));
        contextAppender.accept(texts::add);
        texts.add((class_2561)class_2561.method_43470((String)" "));
        texts.add((class_2561)class_2561.method_43470((String)errorMessage));
        texts.add((class_2561)class_2561.method_43470((String)" "));
        texts.add((class_2561)class_2561.method_43470((String)"Check your log for details").method_27692(class_124.field_1080));
        return texts;
    }

    private List<class_5481> wrap(List<class_2561> message) {
        ArrayList<class_5481> list = new ArrayList<class_5481>();
        for (class_2561 text : message) {
            list.addAll(this.textRenderer.method_1728((class_5348)text, this.method_29049() - 8));
        }
        return list;
    }

    public Object method_1987() {
        return Type.VERY_TYPE;
    }

    static enum Type {
        VERY_TYPE;

    }
}

