/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.component;

import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.AnimatableProperty;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.util.Observable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;
import org.w3c.dom.Element;

public class LabelComponent
extends BaseComponent {
    protected final class_327 textRenderer;
    protected class_2561 text;
    protected List<class_5481> wrappedText;
    protected VerticalAlignment verticalTextAlignment;
    protected HorizontalAlignment horizontalTextAlignment;
    protected final AnimatableProperty<Color> color;
    protected final Observable<Integer> lineHeight;
    protected final Observable<Integer> lineSpacing;
    protected boolean shadow;
    protected int maxWidth;
    protected Function<@Nullable class_2583, Boolean> textClickHandler;

    protected LabelComponent(class_2561 text) {
        this.textRenderer = class_310.method_1551().field_1772;
        this.verticalTextAlignment = VerticalAlignment.TOP;
        this.horizontalTextAlignment = HorizontalAlignment.LEFT;
        this.color = AnimatableProperty.of(Color.WHITE);
        Objects.requireNonNull(this.textRenderer);
        this.lineHeight = Observable.of(9);
        this.lineSpacing = Observable.of(2);
        this.textClickHandler = style -> {
            OwoUIDrawContext.utilityScreen().captureLinkSource();
            boolean success = style != null && OwoUIDrawContext.utilityScreen().method_25430((class_2583)style);
            OwoUIDrawContext.utilityScreen().getAndClearLinkSource();
            return success;
        };
        this.text = text;
        this.wrappedText = new ArrayList<class_5481>();
        this.shadow = false;
        this.maxWidth = Integer.MAX_VALUE;
        Observable.observeAll(() -> this.notifyParentIfMounted(), this.lineHeight, this.lineSpacing);
    }

    public LabelComponent text(class_2561 text) {
        this.text = text;
        this.notifyParentIfMounted();
        return this;
    }

    public class_2561 text() {
        return this.text;
    }

    public LabelComponent maxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        this.notifyParentIfMounted();
        return this;
    }

    public int maxWidth() {
        return this.maxWidth;
    }

    public LabelComponent shadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public boolean shadow() {
        return this.shadow;
    }

    public LabelComponent color(Color color) {
        this.color.set(color);
        return this;
    }

    public AnimatableProperty<Color> color() {
        return this.color;
    }

    public LabelComponent verticalTextAlignment(VerticalAlignment verticalAlignment) {
        this.verticalTextAlignment = verticalAlignment;
        return this;
    }

    public VerticalAlignment verticalTextAlignment() {
        return this.verticalTextAlignment;
    }

    public LabelComponent horizontalTextAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalTextAlignment = horizontalAlignment;
        return this;
    }

    public HorizontalAlignment horizontalTextAlignment() {
        return this.horizontalTextAlignment;
    }

    public LabelComponent lineHeight(int lineHeight) {
        this.lineHeight.set(lineHeight);
        return this;
    }

    public int lineHeight() {
        return this.lineHeight.get();
    }

    public LabelComponent lineSpacing(int lineSpacing) {
        this.lineSpacing.set(lineSpacing);
        return this;
    }

    public int lineSpacing() {
        return this.lineSpacing.get();
    }

    public LabelComponent textClickHandler(Function<@Nullable class_2583, Boolean> textClickHandler) {
        this.textClickHandler = textClickHandler;
        return this;
    }

    public Function<class_2583, Boolean> textClickHandler() {
        return this.textClickHandler;
    }

    @Override
    protected int determineHorizontalContentSize(Sizing sizing) {
        int widestText = 0;
        for (class_5481 line : this.wrappedText) {
            int width = this.textRenderer.method_30880(line);
            if (width <= widestText) continue;
            widestText = width;
        }
        if (widestText > this.maxWidth) {
            this.wrapLines();
            return this.determineHorizontalContentSize(sizing);
        }
        return widestText;
    }

    @Override
    protected int determineVerticalContentSize(Sizing sizing) {
        this.wrapLines();
        return this.textHeight();
    }

    @Override
    public void inflate(Size space) {
        this.wrapLines();
        super.inflate(space);
    }

    private void wrapLines() {
        this.wrappedText = this.textRenderer.method_1728((class_5348)this.text, ((Sizing)this.horizontalSizing.get()).isContent() ? this.maxWidth : this.width);
    }

    protected int textHeight() {
        return this.wrappedText.size() * (this.lineHeight() + this.lineSpacing()) - this.lineSpacing();
    }

    @Override
    public void update(float delta, int mouseX, int mouseY) {
        super.update(delta, mouseX, mouseY);
        this.color.update(delta);
    }

    @Override
    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        matrices.translate(0.0f, 1.0f / (float)class_310.method_1551().method_22683().method_4495());
        int x = this.x;
        int y = this.y;
        if (((Sizing)this.horizontalSizing.get()).isContent()) {
            x += ((Sizing)this.horizontalSizing.get()).value;
        }
        if (((Sizing)this.verticalSizing.get()).isContent()) {
            y += ((Sizing)this.verticalSizing.get()).value;
        }
        switch (this.verticalTextAlignment) {
            case CENTER: {
                y += (this.height - this.textHeight()) / 2;
                break;
            }
            case BOTTOM: {
                y += this.height - this.textHeight();
            }
        }
        int lambdaX = x;
        int lambdaY = y;
        for (int i = 0; i < this.wrappedText.size(); ++i) {
            class_5481 renderText = this.wrappedText.get(i);
            int renderX = lambdaX;
            switch (this.horizontalTextAlignment) {
                case CENTER: {
                    renderX += (this.width - this.textRenderer.method_30880(renderText)) / 2;
                    break;
                }
                case RIGHT: {
                    renderX += this.width - this.textRenderer.method_30880(renderText);
                }
            }
            int renderY = lambdaY + i * (this.lineHeight() + this.lineSpacing());
            int n = this.lineHeight();
            Objects.requireNonNull(this.textRenderer);
            context.method_51430(this.textRenderer, renderText, renderX, renderY += n - 9, ((Color)this.color.get()).argb(), this.shadow);
        }
        matrices.popMatrix();
    }

    @Override
    public void drawTooltip(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        super.drawTooltip(context, mouseX, mouseY, partialTicks, delta);
        context.method_51441(this.textRenderer, this.styleAt(mouseX - this.x, mouseY - this.y), mouseX, mouseY);
    }

    @Override
    public boolean shouldDrawTooltip(double mouseX, double mouseY) {
        class_2583 hoveredStyle = this.styleAt((int)(mouseX - (double)this.x), (int)(mouseY - (double)this.y));
        return super.shouldDrawTooltip(mouseX, mouseY) || hoveredStyle != null && hoveredStyle.method_10969() != null && this.isInBoundingBox(mouseX, mouseY);
    }

    @Override
    public boolean onMouseDown(class_11909 click, boolean doubled) {
        return this.textClickHandler.apply(this.styleAt((int)click.comp_4798(), (int)click.comp_4799())) | super.onMouseDown(click, doubled);
    }

    @Nullable
    protected class_2583 styleAt(int mouseX, int mouseY) {
        return this.textRenderer.method_27527().method_30876(this.wrappedText.get(Math.min(mouseY / (this.lineHeight() + this.lineSpacing()), this.wrappedText.size() - 1)), mouseX);
    }

    @Override
    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, "text", UIParsing::parseText, this::text);
        UIParsing.apply(children, "max-width", UIParsing::parseUnsignedInt, this::maxWidth);
        UIParsing.apply(children, "color", Color::parse, this::color);
        UIParsing.apply(children, "shadow", UIParsing::parseBool, this::shadow);
        UIParsing.apply(children, "line-height", UIParsing::parseUnsignedInt, this::lineHeight);
        UIParsing.apply(children, "line-spacing", UIParsing::parseUnsignedInt, this::lineSpacing);
        UIParsing.apply(children, "vertical-text-alignment", VerticalAlignment::parse, this::verticalTextAlignment);
        UIParsing.apply(children, "horizontal-text-alignment", HorizontalAlignment::parse, this::horizontalTextAlignment);
    }
}

