/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.component;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.wispforest.owo.Owo;
import io.wispforest.owo.mixin.ui.access.EntityRendererAccessor;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.renderstate.EntityElementRenderState;
import java.time.Duration;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_10017;
import net.minecraft.class_10185;
import net.minecraft.class_1068;
import net.minecraft.class_11256;
import net.minecraft.class_11352;
import net.minecraft.class_11653;
import net.minecraft.class_11909;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1664;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2535;
import net.minecraft.class_2598;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3730;
import net.minecraft.class_4597;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_7965;
import net.minecraft.class_7975;
import net.minecraft.class_8030;
import net.minecraft.class_8675;
import net.minecraft.class_8685;
import net.minecraft.class_8942;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_9064;
import net.minecraft.class_9782;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.w3c.dom.Element;

public class EntityComponent<E extends class_1297>
extends BaseComponent {
    protected final class_898 manager;
    protected final class_4597.class_4598 entityBuffers;
    protected final E entity;
    protected float mouseRotation = 0.0f;
    protected float scale = 1.0f;
    protected boolean lookAtCursor = false;
    protected boolean allowMouseRotation = false;
    protected boolean scaleToFit = false;
    protected boolean showNametag = false;
    protected Consumer<Matrix4f> transform;

    protected EntityComponent(Sizing sizing, E entity) {
        this.transform = matrixStack -> {};
        class_310 client = class_310.method_1551();
        this.manager = client.method_1561();
        this.entityBuffers = client.method_22940().method_23000();
        this.entity = entity;
        this.sizing(sizing);
    }

    protected EntityComponent(Sizing sizing, class_1299<E> type, @Nullable class_2487 nbt) {
        this.transform = matrixStack -> {};
        class_310 client = class_310.method_1551();
        this.manager = client.method_1561();
        this.entityBuffers = client.method_22940().method_23000();
        this.entity = type.method_5883((class_1937)client.field_1687, class_3730.field_16466);
        if (nbt != null) {
            this.entity.method_5651(class_11352.method_71417((class_8942)new class_8942.class_11340(Owo.LOGGER), (class_7225.class_7874)client.field_1687.method_30349(), (class_2487)nbt));
        }
        this.entity.method_30634(client.field_1724.method_23317(), client.field_1724.method_23318(), client.field_1724.method_23321());
        this.sizing(sizing);
    }

    @Override
    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        Matrix4f matrix = new Matrix4f();
        matrix.scale(75.0f * this.scale * (float)this.width / 64.0f, -75.0f * this.scale * (float)this.height / 64.0f, -75.0f * this.scale);
        matrix.translate(0.0f, this.entity.method_17682() / 2.0f, 0.0f);
        this.transform.accept(matrix);
        if (this.lookAtCursor) {
            float xRotation = (float)Math.toDegrees(Math.atan(((float)(mouseY - this.y) - (float)this.height / 2.0f) / 40.0f));
            float yRotation = (float)Math.toDegrees(Math.atan(((float)(mouseX - this.x) - (float)this.width / 2.0f) / 40.0f));
            E e = this.entity;
            if (e instanceof class_1309) {
                class_1309 living = (class_1309)e;
                living.field_6259 = -yRotation;
            }
            ((class_1297)this.entity).field_5982 = -yRotation;
            ((class_1297)this.entity).field_6004 = xRotation * 0.65f;
            if (xRotation == 0.0f) {
                xRotation = 0.1f;
            }
            matrix.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(xRotation * 0.15f));
            matrix.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(yRotation * 0.15f));
        } else {
            matrix.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(35.0f));
            matrix.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(-45.0f + this.mouseRotation));
        }
        class_10017 entityState = this.manager.method_72977(this.entity, partialTicks);
        class_897 renderer = this.manager.method_3953(this.entity);
        if (this.showNametag) {
            entityState.field_53337 = ((EntityRendererAccessor)renderer).owo$getDisplayName(this.entity);
            entityState.field_53338 = this.entity.method_56072().method_55675(class_9064.field_47745, 0, this.entity.method_61415(partialTicks));
        } else {
            entityState.field_53337 = null;
            entityState.field_53338 = null;
        }
        context.field_59826.method_70922((class_11256)new EntityElementRenderState(entityState, matrix, new class_8030(this.x, this.y, this.width, this.height), context.field_44659.method_70863()));
    }

    @Override
    public boolean onMouseDrag(class_11909 click, double deltaX, double deltaY) {
        if (this.allowMouseRotation && click.method_74245() == 0) {
            this.mouseRotation = (float)((double)this.mouseRotation + deltaX);
            super.onMouseDrag(click, deltaX, deltaY);
            return true;
        }
        return super.onMouseDrag(click, deltaX, deltaY);
    }

    public E entity() {
        return this.entity;
    }

    public EntityComponent<E> allowMouseRotation(boolean allowMouseRotation) {
        this.allowMouseRotation = allowMouseRotation;
        return this;
    }

    public boolean allowMouseRotation() {
        return this.allowMouseRotation;
    }

    public EntityComponent<E> lookAtCursor(boolean lookAtCursor) {
        this.lookAtCursor = lookAtCursor;
        return this;
    }

    public boolean lookAtCursor() {
        return this.lookAtCursor;
    }

    public EntityComponent<E> scale(float scale) {
        this.scale = scale;
        return this;
    }

    public float scale() {
        return this.scale;
    }

    public EntityComponent<E> scaleToFit(boolean scaleToFit) {
        this.scaleToFit = scaleToFit;
        if (scaleToFit) {
            float xScale = 0.5f / this.entity.method_17681();
            float yScale = 0.5f / this.entity.method_17682();
            this.scale(Math.min(xScale, yScale));
        }
        return this;
    }

    public boolean scaleToFit() {
        return this.scaleToFit;
    }

    public EntityComponent<E> transform(Consumer<Matrix4f> transform) {
        this.transform = transform;
        return this;
    }

    public Consumer<Matrix4f> transform() {
        return this.transform;
    }

    public EntityComponent<E> showNametag(boolean showNametag) {
        this.showNametag = showNametag;
        return this;
    }

    public boolean showNametag() {
        return this.showNametag;
    }

    @Override
    public boolean canFocus(Component.FocusSource source) {
        return source == Component.FocusSource.MOUSE_CLICK;
    }

    public static RenderablePlayerEntity createRenderablePlayer(GameProfile profile) {
        return new RenderablePlayerEntity(profile);
    }

    @Override
    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, "scale", UIParsing::parseFloat, this::scale);
        UIParsing.apply(children, "look-at-cursor", UIParsing::parseBool, this::lookAtCursor);
        UIParsing.apply(children, "mouse-rotation", UIParsing::parseBool, this::allowMouseRotation);
        UIParsing.apply(children, "scale-to-fit", UIParsing::parseBool, this::scaleToFit);
    }

    public static EntityComponent<?> parse(Element element) {
        UIParsing.expectAttributes(element, "type");
        class_2960 entityId = UIParsing.parseIdentifier(element.getAttributeNode("type"));
        class_1299 entityType = (class_1299)class_7923.field_41177.method_17966(entityId).orElseThrow(() -> new UIModelParsingException("Unknown entity type " + String.valueOf(entityId)));
        class_2487 nbt = null;
        if (element.hasAttribute("nbt")) {
            try {
                nbt = class_2522.method_67315((String)element.getAttribute("nbt"));
            }
            catch (CommandSyntaxException cse) {
                throw new UIModelParsingException("Invalid NBT compound", cse);
            }
        }
        return new EntityComponent(Sizing.content(), entityType, nbt);
    }

    public static class RenderablePlayerEntity
    extends class_746 {
        protected class_8685 skinTextures;

        protected RenderablePlayerEntity(GameProfile profile) {
            super(class_310.method_1551(), class_310.method_1551().field_1687, new class_634(class_310.method_1551(), new class_2535(class_2598.field_11942), new class_8675(new class_11653(0L), profile, new class_7975(class_7965.field_41434, false, Duration.ZERO, ""), class_310.method_1551().field_1687.method_30349().method_40316(), class_310.method_1551().field_1687.method_45162(), "Wisp Forest Enterprises", null, null, Map.of(), null, Map.of(), class_9782.field_51977, Map.of(), true)), null, null, class_10185.field_54098, false);
            this.skinTextures = class_1068.method_52854((GameProfile)profile);
            class_156.method_18349().execute(() -> {
                GameProfile completeProfile = class_310.method_1551().method_73361().comp_4624().method_73290(profile.id()).orElse(profile);
                this.skinTextures = class_1068.method_52854((GameProfile)completeProfile);
                this.field_3937.method_1582().method_52863(completeProfile).thenAccept(textures -> textures.ifPresent($ -> {
                    this.skinTextures = $;
                }));
            });
        }

        public class_8685 method_52814() {
            return this.skinTextures;
        }

        public boolean method_74091(class_1664 part) {
            return true;
        }

        @Nullable
        protected class_640 method_3123() {
            return null;
        }
    }
}

