/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.base;

import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.AnimatableProperty;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.util.FocusHandler;
import io.wispforest.owo.util.Observable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public abstract class BaseParentComponent
extends BaseComponent
implements ParentComponent {
    protected final Observable<VerticalAlignment> verticalAlignment = Observable.of(VerticalAlignment.TOP);
    protected final Observable<HorizontalAlignment> horizontalAlignment = Observable.of(HorizontalAlignment.LEFT);
    protected final AnimatableProperty<Insets> padding = AnimatableProperty.of(Insets.none());
    @Nullable
    protected FocusHandler focusHandler = null;
    @Nullable
    protected ArrayList<Runnable> taskQueue = null;
    protected Surface surface = Surface.BLANK;
    protected boolean allowOverflow = false;

    protected BaseParentComponent(Sizing horizontalSizing, Sizing verticalSizing) {
        this.horizontalSizing.set(horizontalSizing);
        this.verticalSizing.set(verticalSizing);
        Observable.observeAll(this::updateLayout, this.horizontalAlignment, this.verticalAlignment, this.padding);
    }

    @Override
    public final void update(float delta, int mouseX, int mouseY) {
        ParentComponent.super.update(delta, mouseX, mouseY);
        super.update(delta, mouseX, mouseY);
        this.parentUpdate(delta, mouseX, mouseY);
        if (this.taskQueue != null) {
            this.taskQueue.forEach(Runnable::run);
            this.taskQueue.clear();
        }
    }

    protected void parentUpdate(float delta, int mouseX, int mouseY) {
    }

    @Override
    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        this.surface.draw(context, this);
    }

    @Override
    public void queue(Runnable task) {
        if (this.taskQueue == null) {
            this.parent.queue(task);
        } else {
            this.taskQueue.add(task);
        }
    }

    @Override
    @Nullable
    public FocusHandler focusHandler() {
        if (this.focusHandler == null) {
            return super.focusHandler();
        }
        return this.focusHandler;
    }

    @Override
    public ParentComponent verticalAlignment(VerticalAlignment alignment) {
        this.verticalAlignment.set(alignment);
        return this;
    }

    @Override
    public VerticalAlignment verticalAlignment() {
        return this.verticalAlignment.get();
    }

    @Override
    public ParentComponent horizontalAlignment(HorizontalAlignment alignment) {
        this.horizontalAlignment.set(alignment);
        return this;
    }

    @Override
    public HorizontalAlignment horizontalAlignment() {
        return this.horizontalAlignment.get();
    }

    @Override
    public ParentComponent padding(Insets padding) {
        this.padding.set(padding);
        this.updateLayout();
        return this;
    }

    @Override
    public AnimatableProperty<Insets> padding() {
        return this.padding;
    }

    @Override
    public ParentComponent allowOverflow(boolean allowOverflow) {
        this.allowOverflow = allowOverflow;
        return this;
    }

    @Override
    public boolean allowOverflow() {
        return this.allowOverflow;
    }

    @Override
    public ParentComponent surface(Surface surface) {
        this.surface = surface;
        return this;
    }

    @Override
    public Surface surface() {
        return this.surface;
    }

    @Override
    public void mount(ParentComponent parent, int x, int y) {
        super.mount(parent, x, y);
        if (parent == null && this.focusHandler == null) {
            this.focusHandler = new FocusHandler(this);
            this.taskQueue = new ArrayList();
        }
    }

    @Override
    public void inflate(Size space) {
        if (this.space.equals(space) && !this.dirty) {
            return;
        }
        this.space = space;
        for (Component child : this.children()) {
            child.dismount(Component.DismountReason.LAYOUT_INFLATION);
        }
        super.inflate(space);
        this.layout(space);
        super.inflate(space);
    }

    protected void updateLayout() {
        if (!this.mounted) {
            return;
        }
        if (this.batchedEvents > 0) {
            ++this.batchedEvents;
            return;
        }
        Size previousSize = this.fullSize();
        this.dirty = true;
        this.inflate(this.space);
        if (!previousSize.equals(this.fullSize()) && this.parent != null) {
            this.parent.onChildMutated(this);
        }
    }

    @Override
    protected void runAndDeferEvents(Runnable action) {
        try {
            this.batchedEvents = 1;
            action.run();
        }
        finally {
            if (this.batchedEvents > 1) {
                this.batchedEvents = 0;
                this.updateLayout();
            } else {
                this.batchedEvents = 0;
            }
        }
    }

    @Override
    public void onChildMutated(Component child) {
        this.updateLayout();
    }

    @Override
    public boolean onMouseDown(class_11909 click, boolean doubled) {
        if (this.focusHandler != null) {
            this.focusHandler.updateClickFocus((double)this.x + click.comp_4798(), (double)this.y + click.comp_4799());
        }
        return ParentComponent.super.onMouseDown(click, doubled) || super.onMouseDown(click, doubled);
    }

    @Override
    public boolean onMouseUp(class_11909 click) {
        if (this.focusHandler != null && this.focusHandler.focused() != null) {
            Component focused = this.focusHandler.focused();
            return focused.onMouseUp(new class_11909((double)this.x + click.comp_4798() - (double)focused.x(), (double)this.y + click.comp_4799() - (double)focused.y(), click.comp_4800()));
        }
        return super.onMouseUp(click);
    }

    @Override
    public boolean onMouseScroll(double mouseX, double mouseY, double amount) {
        return ParentComponent.super.onMouseScroll(mouseX, mouseY, amount) || super.onMouseScroll(mouseX, mouseY, amount);
    }

    @Override
    public boolean onMouseDrag(class_11909 click, double deltaX, double deltaY) {
        if (this.focusHandler != null && this.focusHandler.focused() != null) {
            Component focused = this.focusHandler.focused();
            return focused.onMouseDrag(new class_11909((double)this.x + click.comp_4798() - (double)focused.x(), (double)this.y + click.comp_4799() - (double)focused.y(), click.comp_4800()), deltaX, deltaY);
        }
        return super.onMouseDrag(click, deltaX, deltaY);
    }

    @Override
    public boolean onKeyPress(class_11908 input) {
        if (this.focusHandler == null) {
            return false;
        }
        if (input.method_74236()) {
            this.focusHandler.cycle(!input.method_74239());
        } else if ((input.method_74234() || input.method_74235() || input.method_74232() || input.method_74233()) && input.method_74238()) {
            this.focusHandler.moveFocus(input.comp_4795());
        } else if (this.focusHandler.focused() != null) {
            return this.focusHandler.focused().onKeyPress(input);
        }
        return super.onKeyPress(input);
    }

    @Override
    public boolean onCharTyped(class_11905 input) {
        if (this.focusHandler == null) {
            return false;
        }
        if (this.focusHandler.focused() != null) {
            return this.focusHandler.focused().onCharTyped(input);
        }
        return super.onCharTyped(input);
    }

    @Override
    public void updateX(int x) {
        int offset = x - this.x;
        super.updateX(x);
        for (Component child : this.children()) {
            child.updateX(child.baseX() + offset);
        }
    }

    @Override
    public void updateY(int y) {
        int offset = y - this.y;
        super.updateY(y);
        for (Component child : this.children()) {
            child.updateY(child.baseY() + offset);
        }
    }

    protected Size childMountingOffset() {
        Insets padding = (Insets)this.padding.get();
        return Size.of(padding.left(), padding.top());
    }

    protected void mountChild(@Nullable Component child, Consumer<Component> layoutFunc) {
        if (child == null) {
            return;
        }
        Positioning positioning = (Positioning)child.positioning().get();
        Insets componentMargins = (Insets)child.margins().get();
        Insets padding = (Insets)this.padding.get();
        switch (positioning.type) {
            case LAYOUT: {
                layoutFunc.accept(child);
                break;
            }
            case ABSOLUTE: {
                child.mount(this, this.x + positioning.x + componentMargins.left() + padding.left(), this.y + positioning.y + componentMargins.top() + padding.top());
                break;
            }
            case RELATIVE: {
                child.mount(this, this.x + padding.left() + componentMargins.left() + Math.round((float)positioning.x / 100.0f * (float)(this.width() - child.fullSize().width() - padding.horizontal())), this.y + padding.top() + componentMargins.top() + Math.round((float)positioning.y / 100.0f * (float)(this.height() - child.fullSize().height() - padding.vertical())));
                break;
            }
            case ACROSS: {
                child.mount(this, this.x + padding.left() + componentMargins.left() + Math.round((float)positioning.x / 100.0f * (float)(this.width() - padding.horizontal())), this.y + padding.top() + componentMargins.top() + Math.round((float)positioning.y / 100.0f * (float)(this.height() - padding.vertical())));
            }
        }
    }

    protected void drawChildren(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta, List<? extends Component> children) {
        if (!this.allowOverflow) {
            Insets padding = (Insets)this.padding.get();
            context.method_44379(this.x + padding.left(), this.y + padding.top(), this.x + padding.left() + this.width - padding.horizontal(), this.y + padding.top() + this.height - padding.vertical());
        }
        FocusHandler focusHandler = this.focusHandler();
        for (int i = 0; i < children.size(); ++i) {
            Component child = children.get(i);
            if (!context.intersectsScissor(child)) continue;
            child.draw(context, mouseX, mouseY, partialTicks, delta);
            if (focusHandler.lastFocusSource() != Component.FocusSource.KEYBOARD_CYCLE || focusHandler.focused() != child) continue;
            child.drawFocusHighlight(context, mouseX, mouseY, partialTicks, delta);
        }
        if (!this.allowOverflow) {
            context.method_44380();
        }
    }

    protected Size calculateChildSpace(Size thisSpace) {
        Insets padding = (Insets)this.padding.get();
        return Size.of(class_3532.method_48781((float)((Sizing)this.horizontalSizing.get()).contentFactor(), (int)(this.width - padding.horizontal()), (int)(thisSpace.width() - padding.horizontal())), class_3532.method_48781((float)((Sizing)this.verticalSizing.get()).contentFactor(), (int)(this.height - padding.vertical()), (int)(thisSpace.height() - padding.vertical())));
    }

    @Override
    public BaseParentComponent positioning(Positioning positioning) {
        return (BaseParentComponent)super.positioning(positioning);
    }

    @Override
    public BaseParentComponent margins(Insets margins) {
        return (BaseParentComponent)super.margins(margins);
    }
}

