/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SelfDescribedDeserializer;
import io.wispforest.endec.SelfDescribedSerializer;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.format.bytebuf.ByteBufDeserializer;
import io.wispforest.endec.format.bytebuf.ByteBufSerializer;
import io.wispforest.endec.format.edm.EdmElement;
import io.wispforest.endec.format.edm.EdmEndec;
import io.wispforest.endec.format.edm.EdmMap;
import io.wispforest.endec.format.edm.EdmSerializer;
import io.wispforest.endec.format.edm.LenientEdmDeserializer;
import io.wispforest.endec.format.forwarding.ForwardingDeserializer;
import io.wispforest.endec.format.forwarding.ForwardingSerializer;
import io.wispforest.endec.format.gson.GsonDeserializer;
import io.wispforest.endec.format.gson.GsonEndec;
import io.wispforest.endec.format.gson.GsonSerializer;
import io.wispforest.owo.mixin.serialization.ForwardingDynamicOpsAccessor;
import io.wispforest.owo.mixin.serialization.RegistryOpsAccessor;
import io.wispforest.owo.serialization.RegistriesAttribute;
import io.wispforest.owo.serialization.endec.EitherEndec;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import io.wispforest.owo.serialization.endec.StructEitherEndec;
import io.wispforest.owo.serialization.format.ContextHolder;
import io.wispforest.owo.serialization.format.DynamicOpsWithContext;
import io.wispforest.owo.serialization.format.edm.EdmOps;
import io.wispforest.owo.serialization.format.nbt.NbtDeserializer;
import io.wispforest.owo.serialization.format.nbt.NbtEndec;
import io.wispforest.owo.serialization.format.nbt.NbtSerializer;
import io.wispforest.owo.util.Scary;
import io.wispforest.owo.util.StackTraceSupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_5379;
import net.minecraft.class_6903;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class CodecUtils {
    private static final Map<Class<? extends Serializer<?>>, CodecAdapter<?, ?, ?>> serializerToAdapter = new HashMap();
    private static final Map<Class<? extends Deserializer<?>>, CodecAdapter<?, ?, ?>> deserializerToAdapter = new HashMap();
    private static final Map<Class<? extends DynamicOps<?>>, CodecAdapter<?, ?, ?>> opsToAdapter = new HashMap();

    public static <T> Endec<T> toEndec(Codec<T> codec) {
        return Endec.of(CodecUtils.encoderOfCodec(codec), CodecUtils.decoderOfCodec(codec));
    }

    private static <T> Endec.Encoder<T> encoderOfCodec(Codec<T> codec) {
        return (ctx, serializer, value) -> CodecUtils.encodeWithCodecIntoSerializer(codec, value, serializer, ctx);
    }

    private static <T, S> void encodeWithCodecIntoSerializer(Codec<T> codec, T value, Serializer<S> serializer, SerializationContext ctx) {
        Serializer<S> unpackedSerializer = CodecUtils.unpackSerializer(serializer);
        Pair<DynamicOps<S>, CodecAdapter<S, S, ?>> pair = CodecUtils.getOpsAndAdapter(unpackedSerializer, ctx);
        if (pair == null || !(unpackedSerializer instanceof SelfDescribedSerializer)) {
            EdmEndec.INSTANCE.encode(ctx, serializer, (EdmElement)codec.encodeStart(CodecUtils.createEdmOps(ctx), value).getOrThrow());
        } else {
            SelfDescribedSerializer selfDescribedSerializer = (SelfDescribedSerializer)unpackedSerializer;
            DynamicOps ops = (DynamicOps)pair.getFirst();
            CodecAdapter adapter = (CodecAdapter)pair.getSecond();
            CodecUtils.encodeValue(adapter, selfDescribedSerializer, codec.encodeStart(ops, value).getOrThrow());
        }
    }

    private static <T> Endec.Decoder<T> decoderOfCodec(Codec<T> codec) {
        return (ctx, deserializer) -> CodecUtils.decodeWithCodecFromDeserializer(codec, deserializer, ctx);
    }

    private static <T, S> T decodeWithCodecFromDeserializer(Codec<T> codec, Deserializer<S> deserializer, SerializationContext ctx) {
        Object object;
        Deserializer<S> unpackedDeserializer = CodecUtils.unpackDeserializer(deserializer);
        Pair pair = CodecUtils.getOpsAndAdapter(unpackedDeserializer, ctx);
        if (pair == null || !(unpackedDeserializer instanceof SelfDescribedDeserializer)) {
            object = codec.parse(CodecUtils.createEdmOps(ctx), (Object)EdmEndec.INSTANCE.decode(ctx, deserializer)).getOrThrow();
        } else {
            SelfDescribedDeserializer selfDescribedDeserializer = (SelfDescribedDeserializer)unpackedDeserializer;
            object = codec.parse((DynamicOps)pair.getFirst(), CodecUtils.copyDecodedValue((CodecAdapter)pair.getSecond(), selfDescribedDeserializer)).getOrThrow();
        }
        return (T)object;
    }

    public static <T> Endec<T> toEndec(Codec<T> codec, class_9139<ByteBuf, T> packetCodec) {
        Endec.Encoder encoder = CodecUtils.encoderOfCodec(codec);
        Endec.Decoder decoder = CodecUtils.decoderOfCodec(codec);
        return Endec.of((ctx, serializer, value) -> {
            if (serializer instanceof ByteBufSerializer) {
                class_2540 buffer = new class_2540(Unpooled.buffer());
                packetCodec.encode((Object)buffer, value);
                MinecraftEndecs.PACKET_BYTE_BUF.encode(ctx, serializer, (Object)buffer);
            } else {
                encoder.encode(ctx, serializer, value);
            }
        }, (ctx, deserializer) -> {
            if (deserializer instanceof ByteBufDeserializer) {
                return packetCodec.decode((Object)((ByteBuf)MinecraftEndecs.PACKET_BYTE_BUF.decode(ctx, deserializer)));
            }
            return decoder.decode(ctx, deserializer);
        });
    }

    public static <T> Endec<T> toEndecWithRegistries(Codec<T> codec, class_9139<class_9129, T> packetCodec) {
        Endec.Encoder encoder = CodecUtils.encoderOfCodec(codec);
        Endec.Decoder decoder = CodecUtils.decoderOfCodec(codec);
        return Endec.of((ctx, serializer, value) -> {
            if (serializer instanceof ByteBufSerializer) {
                class_9129 buffer = new class_9129((ByteBuf)new class_2540(Unpooled.buffer()), ((RegistriesAttribute)ctx.requireAttributeValue(RegistriesAttribute.REGISTRIES)).registryManager());
                packetCodec.encode((Object)buffer, value);
                MinecraftEndecs.PACKET_BYTE_BUF.encode(ctx, serializer, (Object)buffer);
            } else {
                encoder.encode(ctx, serializer, value);
            }
        }, (ctx, deserializer) -> {
            if (deserializer instanceof ByteBufDeserializer) {
                return packetCodec.decode((Object)new class_9129((ByteBuf)MinecraftEndecs.PACKET_BYTE_BUF.decode(ctx, deserializer), ((RegistriesAttribute)ctx.requireAttributeValue(RegistriesAttribute.REGISTRIES)).registryManager()));
            }
            return decoder.decode(ctx, deserializer);
        });
    }

    public static <F, S> Endec<Either<F, S>> eitherEndec(Endec<F> first, Endec<S> second) {
        return new EitherEndec<F, S>(first, second, false);
    }

    public static <F, S> Endec<Either<F, S>> xorEndec(Endec<F> first, Endec<S> second) {
        return new EitherEndec<F, S>(first, second, true);
    }

    public static <F, S> StructEndec<Either<F, S>> eitherStructEndec(StructEndec<F> first, StructEndec<S> second) {
        return new StructEitherEndec<F, S>(first, second, false);
    }

    public static <F, S> StructEndec<Either<F, S>> xorStructEndec(StructEndec<F> first, StructEndec<S> second) {
        return new StructEitherEndec<F, S>(first, second, true);
    }

    public static <T> Codec<T> toCodec(final Endec<T> endec, final SerializationContext assumedContext) {
        return new Codec<T>(){

            public <D> DataResult<Pair<T, D>> decode(DynamicOps<D> ops, D input) {
                return CodecUtils.captureThrows(() -> {
                    Deserializer<Object> deserializer = CodecUtils.deserializerForValue(ops, input);
                    SerializationContext context = CodecUtils.createContext(ops, assumedContext);
                    Object decodedValue = deserializer != null ? endec.decode(deserializer.setupContext(context), deserializer) : endec.decode(context, (Deserializer)LenientEdmDeserializer.of((EdmElement)((EdmElement)ops.convertTo((DynamicOps)EdmOps.withoutContext(), input))));
                    return new Pair(decodedValue, input);
                });
            }

            public <D> DataResult<D> encode(T input, DynamicOps<D> ops, D prefix) {
                return CodecUtils.captureThrows(() -> {
                    Serializer serializer = CodecUtils.serializerForOps(ops);
                    SerializationContext context = CodecUtils.createContext(ops, assumedContext);
                    return serializer != null ? endec.encodeFully(context, () -> serializer, input) : EdmOps.withoutContext().convertTo(ops, (EdmElement)endec.encodeFully(context, EdmSerializer::of, input));
                });
            }
        };
    }

    public static <T> Codec<T> toCodec(Endec<T> endec) {
        return CodecUtils.toCodec(endec, SerializationContext.empty());
    }

    public static <T> MapCodec<T> toMapCodec(final StructEndec<T> structEndec, final SerializationContext assumedContext) {
        return new MapCodec<T>(){

            public <T1> Stream<T1> keys(DynamicOps<T1> ops) {
                throw new UnsupportedOperationException("MapCodec generated from StructEndec cannot report keys");
            }

            public <T1> DataResult<T> decode(DynamicOps<T1> ops, MapLike<T1> input) {
                return CodecUtils.captureThrows(() -> {
                    Deserializer deserializer = CodecUtils.deserializerForMapLike(ops, input);
                    SerializationContext context = CodecUtils.createContext(ops, assumedContext);
                    if (deserializer != null) {
                        return structEndec.decode(deserializer.setupContext(context), deserializer);
                    }
                    HashMap map = new HashMap();
                    input.entries().forEach(pair -> map.put((String)ops.getStringValue(pair.getFirst()).getOrThrow(s -> new IllegalStateException("Unable to parse key: " + s)), (EdmElement)ops.convertTo((DynamicOps)EdmOps.withoutContext(), pair.getSecond())));
                    return structEndec.decode(context, (Deserializer)LenientEdmDeserializer.of((EdmElement)EdmElement.consumeMap(map)));
                });
            }

            public <T1> RecordBuilder<T1> encode(T input, DynamicOps<T1> ops, RecordBuilder<T1> prefix) {
                try {
                    SerializationContext context = CodecUtils.createContext(ops, assumedContext);
                    Pair<Serializer<T1>, Function<T1, RecordBuilder<T1>>> pair = CodecUtils.serializerForRecordBuilder(ops, prefix);
                    if (pair != null) {
                        Serializer serializer = (Serializer)pair.getFirst();
                        return (RecordBuilder)((Function)pair.getSecond()).apply(structEndec.encodeFully(serializer.setupContext(context), () -> serializer, input));
                    }
                    Map element = (Map)((EdmElement)structEndec.encodeFully(context, EdmSerializer::of, input)).cast();
                    RecordBuilder result = prefix;
                    for (Map.Entry entry : element.entrySet()) {
                        result = result.add((String)entry.getKey(), EdmOps.withoutContext().convertTo(ops, (EdmElement)entry.getValue()));
                    }
                    return result;
                }
                catch (Exception e) {
                    return prefix.withErrorsFrom(DataResult.error(e::getMessage, input));
                }
            }
        };
    }

    public static <T> MapCodec<T> toMapCodec(StructEndec<T> structEndec) {
        return CodecUtils.toMapCodec(structEndec, SerializationContext.empty());
    }

    @Scary
    @ApiStatus.Experimental
    public static <T> StructEndec<T> toStructEndec(final MapCodec<T> mapCodec) {
        return new StructEndec<T>(){

            public void encodeStruct(SerializationContext ctx, Serializer<?> serializer, Serializer.Struct struct, T value) {
                this.doStructEncode(ctx, serializer, struct, value);
            }

            private <S> void doStructEncode(SerializationContext ctx, Serializer<S> serializer, Serializer.Struct struct, T value) {
                Serializer<S> unpackedSerializer = CodecUtils.unpackSerializer(serializer);
                Pair pair = CodecUtils.getOpsAndAdapter(unpackedSerializer, ctx);
                if (pair == null || !(unpackedSerializer instanceof SelfDescribedSerializer)) {
                    DynamicOps<EdmElement<?>> edmOps = CodecUtils.createEdmOps(ctx);
                    EdmMap edmMap = ((EdmElement)mapCodec.encode(value, edmOps, edmOps.mapBuilder()).build((Object)((EdmElement)edmOps.emptyMap())).getOrThrow()).asMap();
                    if (serializer instanceof SelfDescribedSerializer) {
                        ((Map)edmMap.value()).forEach((s, element) -> struct.field(s, ctx, (Endec)EdmEndec.INSTANCE, element));
                    } else {
                        struct.field("element", ctx, EdmEndec.MAP, (Object)edmMap);
                    }
                } else {
                    SelfDescribedSerializer selfDescribedSerializer = (SelfDescribedSerializer)unpackedSerializer;
                    CodecUtils.encodeStruct((CodecAdapter)pair.getSecond(), (DynamicOps)pair.getFirst(), selfDescribedSerializer, struct, mapCodec, value);
                }
            }

            public T decodeStruct(SerializationContext ctx, Deserializer<?> deserializer, Deserializer.Struct struct) {
                return this.doStructDecode(ctx, deserializer, struct);
            }

            private <S> T doStructDecode(SerializationContext ctx, Deserializer<S> deserializer, Deserializer.Struct struct) {
                Deserializer<S> unpackedDeserializer = CodecUtils.unpackDeserializer(deserializer);
                Pair pair = CodecUtils.getOpsAndAdapter(unpackedDeserializer, ctx);
                if (pair == null || !(unpackedDeserializer instanceof SelfDescribedDeserializer)) {
                    EdmMap edmMap = deserializer instanceof SelfDescribedDeserializer ? (EdmMap)EdmEndec.MAP.decode(ctx, deserializer) : (EdmMap)struct.field("element", ctx, EdmEndec.MAP);
                    DynamicOps<EdmElement<?>> ops = CodecUtils.createEdmOps(ctx);
                    return mapCodec.decode(ops, (MapLike)ops.getMap((Object)edmMap).getOrThrow()).getOrThrow();
                }
                SelfDescribedDeserializer selfDescribedDeserializer = (SelfDescribedDeserializer)unpackedDeserializer;
                return CodecUtils.decodeStruct((CodecAdapter)pair.getSecond(), (DynamicOps)pair.getFirst(), selfDescribedDeserializer, struct, mapCodec);
            }
        };
    }

    public static <B extends class_2540, T> class_9139<B, T> toPacketCodec(final Endec<T> endec) {
        return new class_9139<B, T>(){

            public T decode(B buf) {
                SerializationContext serializationContext;
                if (buf instanceof class_9129) {
                    class_9129 registryByteBuf = (class_9129)buf;
                    serializationContext = SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of(registryByteBuf.method_56349())});
                } else {
                    serializationContext = SerializationContext.empty();
                }
                SerializationContext ctx = serializationContext;
                return endec.decode(ctx, (Deserializer)ByteBufDeserializer.of(buf));
            }

            public void encode(B buf, T value) {
                SerializationContext serializationContext;
                if (buf instanceof class_9129) {
                    class_9129 registryByteBuf = (class_9129)buf;
                    serializationContext = SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of(registryByteBuf.method_56349())});
                } else {
                    serializationContext = SerializationContext.empty();
                }
                SerializationContext ctx = serializationContext;
                endec.encode(ctx, (Serializer)ByteBufSerializer.of(buf), value);
            }
        };
    }

    private static SerializationContext createContext(DynamicOps<?> ops, SerializationContext assumedContext) {
        SerializationContext context;
        ContextHolder holder;
        Object rootOps = ops;
        if (rootOps instanceof ContextHolder) {
            holder = (ContextHolder)rootOps;
            v0 = holder.capturedContext().and(assumedContext);
        } else {
            v0 = context = null;
        }
        while (rootOps instanceof class_5379) {
            rootOps = ((ForwardingDynamicOpsAccessor)rootOps).owo$delegate();
            if (context != null || !(rootOps instanceof ContextHolder)) continue;
            holder = (ContextHolder)rootOps;
            context = holder.capturedContext().and(assumedContext);
        }
        if (context == null) {
            context = assumedContext;
        }
        if (ops instanceof class_6903) {
            class_6903 registryOps = (class_6903)ops;
            context = context.withAttributes(new SerializationAttribute.Instance[]{RegistriesAttribute.tryFromCachedInfoGetter(((RegistryOpsAccessor)registryOps).owo$infoGetter())});
        }
        return context;
    }

    private static DynamicOps<EdmElement<?>> createEdmOps(SerializationContext ctx) {
        EdmOps ops = EdmOps.withContext(ctx);
        if (ctx.hasAttribute(RegistriesAttribute.REGISTRIES)) {
            ops = class_6903.method_40414((DynamicOps)ops, (class_6903.class_7863)((RegistriesAttribute)ctx.getAttributeValue(RegistriesAttribute.REGISTRIES)).infoGetter());
        }
        return ops;
    }

    private static <T> DataResult<T> captureThrows(Supplier<T> action) {
        try {
            return DataResult.success(action.get());
        }
        catch (Exception e) {
            return DataResult.error((Supplier)StackTraceSupplier.of(e));
        }
    }

    @ApiStatus.Experimental
    public static void registerCodecAdapter(CodecAdapter<?, ?, ?> adapter) {
        if (serializerToAdapter.containsKey(adapter.serializerClass())) {
            throw new IllegalStateException("Serializer class " + adapter.serializerClass().getSimpleName() + " is already managed by a different codec adapter");
        }
        if (deserializerToAdapter.containsKey(adapter.deserializerClass())) {
            throw new IllegalStateException("Deserializer class " + adapter.deserializerClass().getSimpleName() + " is already managed by a different codec adapter");
        }
        if (opsToAdapter.containsKey(adapter.opsClass())) {
            throw new IllegalStateException("DynamicOps class " + adapter.opsClass().getSimpleName() + " is already managed by a different codec adapter");
        }
        serializerToAdapter.put(adapter.serializerClass(), adapter);
        deserializerToAdapter.put(adapter.deserializerClass(), adapter);
        opsToAdapter.put(adapter.opsClass(), adapter);
    }

    private static <T> DynamicOps<T> unpackOps(DynamicOps<T> ops) {
        DynamicOps<T> rootOps = ops;
        while (rootOps instanceof class_5379) {
            rootOps = ((ForwardingDynamicOpsAccessor)rootOps).owo$delegate();
        }
        return rootOps;
    }

    private static <T> Serializer<T> unpackSerializer(Serializer<T> serializer) {
        Serializer rootSerializer = serializer;
        while (rootSerializer instanceof ForwardingSerializer) {
            ForwardingSerializer forwardingSerializer = (ForwardingSerializer)rootSerializer;
            rootSerializer = forwardingSerializer.delegate();
        }
        return rootSerializer;
    }

    private static <T> Deserializer<T> unpackDeserializer(Deserializer<T> deserializer) {
        Deserializer rootDeserializer = deserializer;
        while (rootDeserializer instanceof ForwardingDeserializer) {
            ForwardingDeserializer forwardingDeserializer = (ForwardingDeserializer)rootDeserializer;
            rootDeserializer = forwardingDeserializer.delegate();
        }
        return rootDeserializer;
    }

    @Nullable
    private static <T, S extends SelfDescribedSerializer<T>> Pair<DynamicOps<T>, CodecAdapter<T, S, ?>> getOpsAndAdapter(Serializer<T> serializer, SerializationContext ctx) {
        CodecAdapter<?, ?, ?> adapter = serializerToAdapter.get(serializer.getClass());
        if (adapter == null) {
            return null;
        }
        class_6903 ops = DynamicOpsWithContext.of(ctx, adapter.getOps());
        if (ctx.hasAttribute(RegistriesAttribute.REGISTRIES)) {
            ops = class_6903.method_40414(ops, (class_6903.class_7863)((RegistriesAttribute)ctx.getAttributeValue(RegistriesAttribute.REGISTRIES)).infoGetter());
        }
        return new Pair(ops, adapter);
    }

    @Nullable
    private static <T, D extends SelfDescribedDeserializer<T>> Pair<DynamicOps<T>, CodecAdapter<T, ?, D>> getOpsAndAdapter(Deserializer<T> deserializer, SerializationContext ctx) {
        CodecAdapter<?, ?, ?> adapter = deserializerToAdapter.get(deserializer.getClass());
        if (adapter == null) {
            return null;
        }
        class_6903 ops = DynamicOpsWithContext.of(ctx, adapter.getOps());
        if (ctx.hasAttribute(RegistriesAttribute.REGISTRIES)) {
            ops = class_6903.method_40414(ops, (class_6903.class_7863)((RegistriesAttribute)ctx.getAttributeValue(RegistriesAttribute.REGISTRIES)).infoGetter());
        }
        return new Pair(ops, adapter);
    }

    @Nullable
    private static <T> Serializer<T> serializerForOps(DynamicOps<T> dynamicOps) {
        CodecAdapter<?, ?, ?> adapter = opsToAdapter.get(CodecUtils.unpackOps(dynamicOps).getClass());
        return adapter != null ? (Serializer<T>)adapter.createSerializer() : null;
    }

    @Nullable
    private static <T> Deserializer<T> deserializerForValue(DynamicOps<T> dynamicOps, T value) {
        CodecAdapter<?, ?, ?> adapter = opsToAdapter.get(CodecUtils.unpackOps(dynamicOps).getClass());
        return adapter != null ? (Deserializer<T>)adapter.createDeserializer(value) : null;
    }

    @Nullable
    private static <T> Pair<Serializer<T>, Function<T, RecordBuilder<T>>> serializerForRecordBuilder(DynamicOps<T> dynamicOps, RecordBuilder<T> builder) {
        CodecAdapter<?, ?, ?> adapter = opsToAdapter.get(CodecUtils.unpackOps(dynamicOps).getClass());
        return adapter != null ? new Pair(adapter.createSerializer(), t -> adapter.addToBuilder(t, builder)) : null;
    }

    @Nullable
    private static <T> Deserializer<T> deserializerForMapLike(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
        CodecAdapter<?, ?, ?> adapter = opsToAdapter.get(CodecUtils.unpackOps(dynamicOps).getClass());
        return adapter != null ? (Deserializer<T>)adapter.createDeserializer(adapter.unpackMapLike(mapLike)) : null;
    }

    private static <T, S extends SelfDescribedSerializer<T>> void encodeValue(CodecAdapter<T, S, ?> adapter, S serializer, T value) {
        adapter.createDeserializer(value).readAny(SerializationContext.empty(), serializer);
    }

    private static <T, D extends SelfDescribedDeserializer<T>> T copyDecodedValue(CodecAdapter<T, ?, D> adapter, D deserializer) {
        Object serializer = adapter.createSerializer();
        deserializer.readAny(SerializationContext.empty(), serializer);
        return (T)serializer.result();
    }

    private static <T, V, S extends SelfDescribedSerializer<T>> void encodeStruct(CodecAdapter<T, S, ?> adapter, DynamicOps<T> ops, S serializer, Serializer.Struct struct, MapCodec<V> mapCodec, V value) {
        Object formatValue = mapCodec.encode(value, ops, ops.mapBuilder()).build(ops.emptyMap()).getOrThrow();
        adapter.encodeStruct(SerializationContext.empty(), serializer, struct, formatValue);
    }

    private static <T, V, D extends SelfDescribedDeserializer<T>> V decodeStruct(CodecAdapter<T, ?, D> adapter, DynamicOps<T> ops, D deserializer, Deserializer.Struct struct, MapCodec<V> mapCodec) {
        T formatValue = adapter.copyDecodedStruct(SerializationContext.empty(), deserializer, struct);
        return (V)mapCodec.decode(ops, (MapLike)ops.getMap(formatValue).getOrThrow()).getOrThrow();
    }

    static {
        CodecUtils.registerCodecAdapter(new CodecAdapter<class_2520, NbtSerializer, NbtDeserializer>(){

            @Override
            public Class<? extends Serializer<class_2520>> serializerClass() {
                return NbtSerializer.class;
            }

            @Override
            public Class<? extends Deserializer<class_2520>> deserializerClass() {
                return NbtDeserializer.class;
            }

            @Override
            public Class<? extends DynamicOps<class_2520>> opsClass() {
                return class_2509.class;
            }

            @Override
            public NbtSerializer createSerializer() {
                return NbtSerializer.of();
            }

            @Override
            public NbtDeserializer createDeserializer(class_2520 value) {
                return NbtDeserializer.of(value);
            }

            @Override
            public DynamicOps<class_2520> getOps() {
                return class_2509.field_11560;
            }

            @Override
            public class_2520 unpackMapLike(MapLike<class_2520> mapLike) {
                class_2487 compound = new class_2487();
                mapLike.entries().forEach(pairs -> {
                    class_2520 key = (class_2520)pairs.getFirst();
                    class_2520 value = (class_2520)pairs.getSecond();
                    if (!(key instanceof class_2519)) {
                        throw new IllegalStateException("Unable to parse key: " + String.valueOf(key));
                    }
                    class_2519 primitive = (class_2519)key;
                    compound.method_10566((String)primitive.method_68658().get(), value);
                });
                return compound;
            }

            @Override
            public RecordBuilder<class_2520> addToBuilder(class_2520 value, RecordBuilder<class_2520> builder) {
                if (!(value instanceof class_2487)) {
                    throw new IllegalStateException("Cannot add non-NbtCompound value into record builder: " + String.valueOf(value));
                }
                class_2487 compoundTag = (class_2487)value;
                RecordBuilder result = builder;
                for (String key : compoundTag.method_10541()) {
                    result = result.add(key, (Object)compoundTag.method_10580(key));
                }
                return result;
            }

            @Override
            public void encodeStruct(SerializationContext ctx, NbtSerializer serializer, Serializer.Struct struct, class_2520 value) {
                if (!(value instanceof class_2487)) {
                    throw new IllegalStateException("Cannot encode non-NbtCompound value as struct: " + String.valueOf(value));
                }
                class_2487 compoundTag = (class_2487)value;
                compoundTag.method_10541().forEach(key -> struct.field(key, ctx, NbtEndec.ELEMENT, (Object)compoundTag.method_10580(key)));
            }

            @Override
            public class_2520 copyDecodedStruct(SerializationContext ctx, NbtDeserializer deserializer, Deserializer.Struct struct) {
                return (class_2520)NbtEndec.COMPOUND.decode(ctx, (Deserializer)deserializer);
            }
        });
        CodecUtils.registerCodecAdapter(new CodecAdapter<JsonElement, GsonSerializer, GsonDeserializer>(){

            @Override
            public Class<? extends Serializer<JsonElement>> serializerClass() {
                return GsonSerializer.class;
            }

            @Override
            public Class<? extends Deserializer<JsonElement>> deserializerClass() {
                return GsonDeserializer.class;
            }

            @Override
            public Class<? extends DynamicOps<JsonElement>> opsClass() {
                return JsonOps.class;
            }

            @Override
            public GsonSerializer createSerializer() {
                return GsonSerializer.of();
            }

            @Override
            public GsonDeserializer createDeserializer(JsonElement value) {
                return GsonDeserializer.of((JsonElement)value);
            }

            @Override
            public DynamicOps<JsonElement> getOps() {
                return JsonOps.INSTANCE;
            }

            @Override
            public JsonElement unpackMapLike(MapLike<JsonElement> mapLike) {
                JsonObject jsonObject = new JsonObject();
                mapLike.entries().forEach(pairs -> {
                    JsonPrimitive primitive;
                    JsonElement key = (JsonElement)pairs.getFirst();
                    JsonElement value = (JsonElement)pairs.getSecond();
                    if (!(key instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)key).isString()) {
                        throw new IllegalStateException("Unable to parse key: " + String.valueOf(key));
                    }
                    jsonObject.add(primitive.getAsString(), value);
                });
                return jsonObject;
            }

            @Override
            public RecordBuilder<JsonElement> addToBuilder(JsonElement value, RecordBuilder<JsonElement> builder) {
                if (!(value instanceof JsonObject)) {
                    throw new IllegalStateException("Cannot add non-JsonObject value into record builder: " + String.valueOf(value));
                }
                JsonObject jsonObject = (JsonObject)value;
                RecordBuilder result = builder;
                for (Map.Entry entry : jsonObject.asMap().entrySet()) {
                    result = result.add((String)entry.getKey(), (Object)((JsonElement)entry.getValue()));
                }
                return result;
            }

            @Override
            public void encodeStruct(SerializationContext ctx, GsonSerializer serializer, Serializer.Struct struct, JsonElement value) {
                if (!(value instanceof JsonObject)) {
                    throw new IllegalStateException("Cannot encode non-JsonObject value as struct: " + String.valueOf(value));
                }
                JsonObject jsonObject = (JsonObject)value;
                jsonObject.asMap().forEach((key, element) -> struct.field(key, ctx, (Endec)GsonEndec.INSTANCE, element));
            }

            @Override
            public JsonElement copyDecodedStruct(SerializationContext ctx, GsonDeserializer serializer, Deserializer.Struct struct) {
                return GsonEndec.INSTANCE.decode(ctx, (Deserializer)serializer);
            }
        });
    }

    public static interface CodecAdapter<T, S extends SelfDescribedSerializer<T>, D extends SelfDescribedDeserializer<T>> {
        public Class<? extends Serializer<T>> serializerClass();

        public Class<? extends Deserializer<T>> deserializerClass();

        public Class<? extends DynamicOps<T>> opsClass();

        public S createSerializer();

        public D createDeserializer(T var1);

        public DynamicOps<T> getOps();

        public T unpackMapLike(MapLike<T> var1);

        public RecordBuilder<T> addToBuilder(T var1, RecordBuilder<T> var2);

        public void encodeStruct(SerializationContext var1, S var2, Serializer.Struct var3, T var4);

        public T copyDecodedStruct(SerializationContext var1, D var2, Deserializer.Struct var3);
    }
}

