/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec.format.bytebuf;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.util.VarInts;
import java.util.Optional;

public class ByteBufSerializer<B extends ByteBuf>
implements Serializer<B> {
    private final B buffer;

    protected ByteBufSerializer(B buffer) {
        this.buffer = buffer;
    }

    public static <B extends ByteBuf> ByteBufSerializer<B> of(B buffer) {
        return new ByteBufSerializer<B>(buffer);
    }

    public void writeByte(SerializationContext ctx, byte value) {
        this.buffer.writeByte((int)value);
    }

    public void writeShort(SerializationContext ctx, short value) {
        this.buffer.writeShort((int)value);
    }

    public void writeInt(SerializationContext ctx, int value) {
        this.buffer.writeInt(value);
    }

    public void writeLong(SerializationContext ctx, long value) {
        this.buffer.writeLong(value);
    }

    public void writeFloat(SerializationContext ctx, float value) {
        this.buffer.writeFloat(value);
    }

    public void writeDouble(SerializationContext ctx, double value) {
        this.buffer.writeDouble(value);
    }

    public void writeVarInt(SerializationContext ctx, int value) {
        VarInts.writeInt((int)value, b -> this.writeByte(ctx, b));
    }

    public void writeVarLong(SerializationContext ctx, long value) {
        VarInts.writeLong((long)value, b -> this.writeByte(ctx, b));
    }

    public void writeBoolean(SerializationContext ctx, boolean value) {
        this.buffer.writeBoolean(value);
    }

    public void writeString(SerializationContext ctx, String value) {
        this.writeVarInt(ctx, ByteBufUtil.utf8Bytes((CharSequence)value));
        ByteBufUtil.writeUtf8(this.buffer, (CharSequence)value);
    }

    public void writeBytes(SerializationContext ctx, byte[] bytes) {
        this.writeVarInt(ctx, bytes.length);
        this.buffer.writeBytes(bytes);
    }

    public <V> void writeOptional(SerializationContext ctx, Endec<V> endec, Optional<V> optional) {
        this.writeBoolean(ctx, optional.isPresent());
        optional.ifPresent(value -> endec.encode(ctx, (Serializer)this, value));
    }

    public <V> Serializer.Map<V> map(SerializationContext ctx, Endec<V> valueEndec, int size) {
        this.writeVarInt(ctx, size);
        return new Sequence<V>(ctx, valueEndec);
    }

    public <E> Serializer.Sequence<E> sequence(SerializationContext ctx, Endec<E> elementEndec, int size) {
        this.writeVarInt(ctx, size);
        return new Sequence<E>(ctx, elementEndec);
    }

    public Serializer.Struct struct() {
        return new Sequence(null, null);
    }

    public B result() {
        return this.buffer;
    }

    private class Sequence<V>
    implements Serializer.Sequence<V>,
    Serializer.Struct,
    Serializer.Map<V> {
        private final SerializationContext ctx;
        private final Endec<V> valueEndec;

        private Sequence(SerializationContext ctx, Endec<V> valueEndec) {
            this.ctx = ctx;
            this.valueEndec = valueEndec;
        }

        public void element(V element) {
            this.valueEndec.encode(this.ctx, (Serializer)ByteBufSerializer.this, element);
        }

        public void entry(String key, V value) {
            ByteBufSerializer.this.writeString(this.ctx, key);
            this.valueEndec.encode(this.ctx, (Serializer)ByteBufSerializer.this, value);
        }

        public <F> Serializer.Struct field(String name, SerializationContext ctx, Endec<F> endec, F value, boolean mayOmit) {
            endec.encode(ctx, (Serializer)ByteBufSerializer.this, value);
            return this;
        }

        public void end() {
        }
    }
}

