/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec.format.bytebuf;

import io.netty.buffer.ByteBuf;
import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.util.VarInts;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class ByteBufDeserializer
implements Deserializer<ByteBuf> {
    private final ByteBuf buffer;

    protected ByteBufDeserializer(ByteBuf buffer) {
        this.buffer = buffer;
    }

    public static ByteBufDeserializer of(ByteBuf buffer) {
        return new ByteBufDeserializer(buffer);
    }

    public byte readByte(SerializationContext ctx) {
        return this.buffer.readByte();
    }

    public short readShort(SerializationContext ctx) {
        return this.buffer.readShort();
    }

    public int readInt(SerializationContext ctx) {
        return this.buffer.readInt();
    }

    public long readLong(SerializationContext ctx) {
        return this.buffer.readLong();
    }

    public float readFloat(SerializationContext ctx) {
        return this.buffer.readFloat();
    }

    public double readDouble(SerializationContext ctx) {
        return this.buffer.readDouble();
    }

    public int readVarInt(SerializationContext ctx) {
        return VarInts.readInt(() -> this.readByte(ctx));
    }

    public long readVarLong(SerializationContext ctx) {
        return VarInts.readLong(() -> this.readByte(ctx));
    }

    public boolean readBoolean(SerializationContext ctx) {
        return this.buffer.readBoolean();
    }

    public String readString(SerializationContext ctx) {
        int sequenceLength = this.readVarInt(ctx);
        String string = this.buffer.toString(this.buffer.readerIndex(), sequenceLength, StandardCharsets.UTF_8);
        this.buffer.readerIndex(this.buffer.readerIndex() + sequenceLength);
        return string;
    }

    public byte[] readBytes(SerializationContext ctx) {
        byte[] array = new byte[this.readVarInt(ctx)];
        this.buffer.readBytes(array);
        return array;
    }

    public <V> Optional<V> readOptional(SerializationContext ctx, Endec<V> endec) {
        return this.readBoolean(ctx) ? Optional.of(endec.decode(ctx, (Deserializer)this)) : Optional.empty();
    }

    public <V> V tryRead(Function<Deserializer<ByteBuf>, V> reader) {
        int prevReaderIdx = this.buffer.readerIndex();
        try {
            return reader.apply(this);
        }
        catch (Exception e) {
            this.buffer.readerIndex(prevReaderIdx);
            throw e;
        }
    }

    public <E> Deserializer.Sequence<E> sequence(SerializationContext ctx, Endec<E> elementEndec) {
        return new Sequence<E>(ctx, elementEndec, this.readVarInt(ctx));
    }

    public <V> Deserializer.Map<V> map(SerializationContext ctx, Endec<V> valueEndec) {
        return new Map<V>(ctx, valueEndec, this.readVarInt(ctx));
    }

    public Deserializer.Struct struct() {
        return new Sequence(null, null, 0);
    }

    private class Sequence<V>
    implements Deserializer.Sequence<V>,
    Deserializer.Struct {
        private final SerializationContext ctx;
        private final Endec<V> valueEndec;
        private final int size;
        private int index = 0;

        private Sequence(SerializationContext ctx, Endec<V> valueEndec, int size) {
            this.ctx = ctx;
            this.valueEndec = valueEndec;
            this.size = size;
        }

        public int estimatedSize() {
            return this.size;
        }

        public boolean hasNext() {
            return this.index < this.size;
        }

        public V next() {
            ++this.index;
            return (V)this.valueEndec.decode(this.ctx, (Deserializer)ByteBufDeserializer.this);
        }

        @Nullable
        public <F> F field(String name, SerializationContext ctx, Endec<F> endec, @Nullable Supplier<F> defaultValueFactory) {
            return (F)endec.decode(ctx, (Deserializer)ByteBufDeserializer.this);
        }
    }

    private class Map<V>
    implements Deserializer.Map<V> {
        private final SerializationContext ctx;
        private final Endec<V> valueEndec;
        private final int size;
        private int index = 0;

        private Map(SerializationContext ctx, Endec<V> valueEndec, int size) {
            this.ctx = ctx;
            this.valueEndec = valueEndec;
            this.size = size;
        }

        public int estimatedSize() {
            return this.size;
        }

        public boolean hasNext() {
            return this.index < this.size;
        }

        public Map.Entry<String, V> next() {
            ++this.index;
            return java.util.Map.entry(ByteBufDeserializer.this.readString(this.ctx), this.valueEndec.decode(this.ctx, (Deserializer)ByteBufDeserializer.this));
        }
    }
}

