/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.mixins;

import com.leobeliik.extremesoundmuffler.CommonConfig;
import com.leobeliik.extremesoundmuffler.gui.MufflerScreen;
import com.leobeliik.extremesoundmuffler.gui.buttons.PlaySoundButton;
import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import com.leobeliik.extremesoundmuffler.utils.Anchor;
import java.util.Locale;
import net.minecraft.class_1113;
import net.minecraft.class_1140;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1140.class})
public abstract class SoundMixin
implements ISoundLists {
    @Unique
    @Nullable
    private class_1113 esmSound;

    @Inject(at={@At(value="HEAD")}, method={"calculateVolume(Lnet/minecraft/client/resources/sounds/SoundInstance;)F"})
    private void esm_captureSoundVolume(class_1113 sound, CallbackInfoReturnable<Float> cir) {
        this.esmSound = sound;
    }

    @Inject(at={@At(value="HEAD")}, method={"play"})
    private void esm_captureTickableSoundVolume(class_1113 sound, CallbackInfoReturnable cir) {
        this.esmSound = sound;
    }

    @ModifyArg(index=0, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(FFF)F"), method={"calculateVolume(FLnet/minecraft/sounds/SoundSource;)F"})
    private float esm_setVolume(float volume) {
        if (!MufflerScreen.isMuffling()) {
            return volume;
        }
        class_1113 tempSound = this.esmSound;
        if (tempSound != null && tempSound.method_4776() != null && !PlaySoundButton.isFromPSB()) {
            Anchor anchor;
            class_2960 soundResourceLocation = tempSound.method_4775();
            if (!SoundMixin.esm_isForbidden(tempSound)) {
                recentSoundsList.remove(soundResourceLocation);
                recentSoundsList.add(soundResourceLocation);
            }
            float tempVolume = tempSound.method_4781();
            String soundName = soundResourceLocation.method_12832();
            String modName = soundResourceLocation.method_12836();
            if (soundName.contains("entity.lightning_bolt.thunder") || soundName.contains("entity.ender_dragon.growl")) {
                tempVolume = 1.0f;
            }
            if (muffledSounds.containsKey(soundResourceLocation)) {
                return (float)((double)tempVolume * (Double)muffledSounds.get(soundResourceLocation));
            }
            if (!CommonConfig.get().disableAnchors().get().booleanValue() && (anchor = Anchor.getAnchor(tempSound)) != null) {
                return (float)((double)tempVolume * (Double)anchor.getMuffledSounds().get(soundResourceLocation));
            }
            for (String mod : modsMuffled) {
                if (!mod.contains(modName.toLowerCase(Locale.ROOT))) continue;
                return tempVolume * Float.parseFloat(mod.split(":")[1]);
            }
        }
        return volume;
    }

    @Inject(at={@At(value="RETURN")}, method={"calculateVolume(Lnet/minecraft/client/resources/sounds/SoundInstance;)F"})
    private void esm_clearTickableSound(class_1113 sound, CallbackInfoReturnable<Float> cir) {
        this.esmSound = null;
    }

    @Inject(at={@At(value="RETURN")}, method={"play"})
    private void esm_clearSound(class_1113 sound, CallbackInfoReturnable cir) {
        this.esmSound = null;
    }

    @Unique
    private static boolean esm_isForbidden(class_1113 sound) {
        return forbiddenSounds.stream().anyMatch(fs -> sound.method_4775().toString().contains((CharSequence)fs));
    }
}

