/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.data.hjson;

import de.siphalor.tweed5.data.hjson.HjsonCommentType;
import de.siphalor.tweed5.data.hjson.HjsonStringType;
import de.siphalor.tweed5.dataapi.api.TweedDataWriteException;
import de.siphalor.tweed5.dataapi.api.TweedDataWriter;
import de.siphalor.tweed5.dataapi.api.decoration.TweedDataCommentDecoration;
import de.siphalor.tweed5.dataapi.api.decoration.TweedDataDecoration;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.PrimitiveIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public class HjsonWriter
implements TweedDataWriter {
    private static final int PREFILL_INDENT = 10;
    private static final Pattern LINE_FEED_PATTERN = Pattern.compile("\\n|\\r\\n");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^-?\\d+(?:\\.\\d*)?(?:[eE][+-]?\\d+)?$");
    private final Writer writer;
    private final Options options;
    private final Deque<Context> contexts;
    private final StringBuilder indentBuffer;
    private int currentIndentLevel;
    private int currentIndentLength;

    public HjsonWriter(Writer writer, Options options) {
        this.writer = writer;
        this.options = options;
        this.contexts = new LinkedList<Context>(Collections.singleton(Context.ROOT));
        this.indentBuffer = new StringBuilder(options.indent.length() * 10);
        for (int i = 0; i < 10; ++i) {
            this.indentBuffer.append(options.indent);
        }
    }

    public void visitNull() {
        this.beforeValueWrite();
        this.write("null");
        this.afterValueWrite();
    }

    public void visitBoolean(boolean value) {
        this.beforeValueWrite();
        this.write(value ? "true" : "false");
        this.afterValueWrite();
    }

    public void visitByte(byte value) {
        this.beforeValueWrite();
        this.write(Byte.toString(value));
        this.afterValueWrite();
    }

    public void visitShort(short value) {
        this.beforeValueWrite();
        this.write(Short.toString(value));
        this.afterValueWrite();
    }

    public void visitInt(int value) {
        this.beforeValueWrite();
        this.write(Integer.toString(value));
        this.afterValueWrite();
    }

    public void visitLong(long value) {
        this.beforeValueWrite();
        this.write(Long.toString(value));
        this.afterValueWrite();
    }

    public void visitFloat(float value) {
        this.beforeValueWrite();
        this.write(Float.toString(value));
        this.afterValueWrite();
    }

    public void visitDouble(double value) {
        this.beforeValueWrite();
        this.write(Double.toString(value));
        this.afterValueWrite();
    }

    public void visitString(String value) {
        this.beforeValueWrite();
        this.writeStringValue(this.getValueStringStringType(value), value);
        this.afterValueWrite();
    }

    private HjsonStringType getValueStringStringType(String value) {
        if (value.isEmpty() || "true".equals(value) || "false".equals(value) || "null".equals(value)) {
            return HjsonStringType.INLINE_DOUBLE_QUOTE;
        }
        if (NUMBER_PATTERN.matcher(value).matches()) {
            return HjsonStringType.INLINE_DOUBLE_QUOTE;
        }
        int firstCodePoint = value.codePointAt(0);
        if (Character.isWhitespace(firstCodePoint)) {
            return HjsonStringType.INLINE_DOUBLE_QUOTE;
        }
        int lastCodePoint = value.codePointBefore(value.length());
        if (Character.isWhitespace(lastCodePoint)) {
            return HjsonStringType.INLINE_DOUBLE_QUOTE;
        }
        boolean singleQuoteFound = false;
        boolean doubleQuoteFound = false;
        int singleQuoteCount = 0;
        boolean tripleSingleQuoteFound = false;
        boolean punctuatorFound = false;
        boolean newLineFound = false;
        boolean escapeRequiredFound = false;
        boolean tabFound = false;
        PrimitiveIterator.OfInt codePointIterator = value.codePoints().iterator();
        while (codePointIterator.hasNext()) {
            int codePoint = codePointIterator.nextInt();
            if (codePoint == 39) {
                singleQuoteFound = true;
                if (++singleQuoteCount < 3) continue;
                tripleSingleQuoteFound = true;
                continue;
            }
            singleQuoteCount = 0;
            if (codePoint == 34) {
                doubleQuoteFound = true;
                continue;
            }
            if (codePoint == 10 || codePoint == 13) {
                newLineFound = true;
                continue;
            }
            if (!punctuatorFound && this.isPunctuatorCodePoint(codePoint)) {
                punctuatorFound = true;
                continue;
            }
            if (codePoint == 9) {
                tabFound = true;
                continue;
            }
            if (codePoint != 92 && codePoint >= 32) continue;
            escapeRequiredFound = true;
        }
        if (!(punctuatorFound || newLineFound || tabFound || escapeRequiredFound)) {
            return HjsonStringType.INLINE_QUOTELESS;
        }
        if (newLineFound && !tripleSingleQuoteFound) {
            return HjsonStringType.MULTILINE_SINGLE_QUOTE;
        }
        if (singleQuoteFound || !doubleQuoteFound) {
            return HjsonStringType.INLINE_DOUBLE_QUOTE;
        }
        return HjsonStringType.INLINE_SINGLE_QUOTE;
    }

    public void visitEmptyList() {
        this.beforeValueWrite();
        this.write("[]");
        this.afterValueWrite();
    }

    public void visitListStart() {
        this.beforeValueWrite();
        this.write("[");
        this.writeLineFeed();
        this.pushContext(Context.LIST);
    }

    public void visitListEnd() {
        this.requireContext(Context.LIST);
        this.popContext();
        this.writeCurrentIndent();
        this.write("]");
        this.afterValueWrite();
    }

    public void visitEmptyMap() {
        this.beforeValueWrite();
        this.write("{}");
        this.afterValueWrite();
    }

    public void visitMapStart() {
        this.beforeValueWrite();
        this.write("{");
        this.writeLineFeed();
        this.pushContext(Context.MAP);
    }

    public void visitMapEntryKey(String key) {
        this.requireContext(Context.MAP);
        this.writeCurrentIndent();
        this.writeStringValue(this.getMapEntryKeyStringType(key), key);
        this.write(": ");
        this.pushContext(Context.MAP_ENTRY);
    }

    private HjsonStringType getMapEntryKeyStringType(String key) {
        int firstCodePoint = key.codePointAt(0);
        if (firstCodePoint == 39) {
            return HjsonStringType.INLINE_DOUBLE_QUOTE;
        }
        if (firstCodePoint == 34) {
            return HjsonStringType.INLINE_SINGLE_QUOTE;
        }
        if (key.codePoints().allMatch(this::isValidMapEntryKeyCodePoint)) {
            return HjsonStringType.INLINE_QUOTELESS;
        }
        return HjsonStringType.INLINE_DOUBLE_QUOTE;
    }

    private boolean isValidMapEntryKeyCodePoint(int codePoint) {
        if (codePoint < 33) {
            return false;
        }
        return !this.isPunctuatorCodePoint(codePoint);
    }

    private boolean isPunctuatorCodePoint(int codePoint) {
        return codePoint == 44 || codePoint == 58 || codePoint == 91 || codePoint == 93 || codePoint == 123 || codePoint == 125;
    }

    public void visitMapEnd() {
        this.requireContext(Context.MAP);
        this.popContext();
        this.writeCurrentIndent();
        this.write("}");
        this.afterValueWrite();
    }

    public void visitDecoration(TweedDataDecoration decoration) {
        if (decoration instanceof TweedDataCommentDecoration) {
            this.visitComment(((TweedDataCommentDecoration)decoration).comment());
        }
    }

    private void visitComment(String comment) {
        Matcher lineFeedMatcher = LINE_FEED_PATTERN.matcher(comment);
        if (lineFeedMatcher.find()) {
            this.writeMultilineCommentStart(this.options.multilineCommentType);
            int begin = 0;
            do {
                this.writeCommentLine(this.options.multilineCommentType, comment, begin, lineFeedMatcher.start());
            } while (lineFeedMatcher.find(begin = lineFeedMatcher.end()));
            this.writeCommentLine(this.options.multilineCommentType, comment, begin, comment.length());
            this.writeMultilineCommentEnd(this.options.multilineCommentType);
        } else {
            this.writeMultilineCommentStart(this.options.inlineCommentType);
            this.writeCommentLine(this.options.inlineCommentType, comment, 0, comment.length());
            this.writeMultilineCommentEnd(this.options.inlineCommentType);
        }
    }

    private void writeMultilineCommentStart(HjsonCommentType commentType) {
        if (commentType == HjsonCommentType.BLOCK) {
            this.writeCurrentIndentIfApplicable();
            this.write("/*");
            this.writeLineFeed();
        }
    }

    private void writeMultilineCommentEnd(HjsonCommentType commentType) {
        if (commentType == HjsonCommentType.BLOCK) {
            this.writeCurrentIndent();
            this.write(" */");
            this.writeLineFeed();
            if (this.isInInlineContext()) {
                this.writeCurrentIndent();
            }
        }
    }

    private void writeCommentLine(HjsonCommentType commentType, CharSequence text, int begin, int end) {
        this.writeCurrentIndentIfApplicable();
        this.write(this.getCommentLineStart(commentType));
        if (end > begin) {
            this.write(" ");
            this.write(text, begin, end);
        }
        this.writeLineFeed();
    }

    private CharSequence getCommentLineStart(HjsonCommentType commentType) {
        switch (commentType) {
            case HASH: {
                return "#";
            }
            case SLASHES: {
                return "//";
            }
            case BLOCK: {
                return " *";
            }
        }
        throw new IllegalStateException("Unknown comment type: " + (Object)((Object)commentType));
    }

    private void beforeValueWrite() {
        this.requireValueContext();
        this.writeCurrentIndentIfApplicable();
    }

    private void afterValueWrite() {
        switch (this.currentContext().ordinal()) {
            case 0: 
            case 1: {
                this.writeLineFeed();
                break;
            }
            case 3: {
                this.popContext();
                this.writeLineFeed();
                break;
            }
        }
    }

    private void writeStringValue(HjsonStringType stringType, String text) {
        switch (stringType) {
            case INLINE_QUOTELESS: {
                this.write(text);
                break;
            }
            case INLINE_DOUBLE_QUOTE: {
                this.writeJsonString(text, 34);
                break;
            }
            case INLINE_SINGLE_QUOTE: {
                this.writeJsonString(text, 39);
                break;
            }
            case MULTILINE_SINGLE_QUOTE: {
                this.writeMultilineString(text);
            }
        }
    }

    private void writeJsonString(String text, int quoteCodepoint) {
        this.writeCodepoint(quoteCodepoint);
        text.codePoints().forEach(codepoint -> {
            if (codepoint == quoteCodepoint) {
                this.write("\\");
                this.writeCodepoint(codepoint);
            } else {
                this.writeJsonStringQuotePoint(codepoint);
            }
        });
        this.writeCodepoint(quoteCodepoint);
    }

    private void writeJsonStringQuotePoint(int codepoint) {
        switch (codepoint) {
            case 92: {
                this.write("\\\\");
                break;
            }
            case 8: {
                this.write("\\b");
                break;
            }
            case 12: {
                this.write("\\f");
                break;
            }
            case 10: {
                this.write("\\n");
                break;
            }
            case 13: {
                this.write("\\r");
                break;
            }
            case 9: {
                this.write("\\t");
                break;
            }
            default: {
                if (this.isValidJsonStringCodepoint(codepoint)) {
                    this.writeCodepoint(codepoint);
                    break;
                }
                this.write(this.codepointToHexEscape(codepoint));
            }
        }
    }

    private String codepointToHexEscape(int codepoint) {
        StringBuilder hexEscape = new StringBuilder("\\u0000");
        hexEscape.replace(5, 6, this.nibbleToHex(codepoint & 0xF));
        hexEscape.replace(4, 5, this.nibbleToHex((codepoint >>= 4) & 0xF));
        hexEscape.replace(3, 4, this.nibbleToHex((codepoint >>= 4) & 0xF));
        hexEscape.replace(2, 3, this.nibbleToHex((codepoint >>= 4) & 0xF));
        return hexEscape.toString();
    }

    private String nibbleToHex(int value) {
        switch (value) {
            case 0: {
                return "0";
            }
            case 1: {
                return "1";
            }
            case 2: {
                return "2";
            }
            case 3: {
                return "3";
            }
            case 4: {
                return "4";
            }
            case 5: {
                return "5";
            }
            case 6: {
                return "6";
            }
            case 7: {
                return "7";
            }
            case 8: {
                return "8";
            }
            case 9: {
                return "9";
            }
            case 10: {
                return "A";
            }
            case 11: {
                return "B";
            }
            case 12: {
                return "C";
            }
            case 13: {
                return "D";
            }
            case 14: {
                return "E";
            }
            case 15: {
                return "F";
            }
        }
        throw new IllegalArgumentException("Invalid nibble value");
    }

    private boolean isValidJsonStringCodepoint(int codepoint) {
        return codepoint >= 32 && codepoint <= 0x10FFFF && codepoint != 33 && codepoint != 92;
    }

    private void writeMultilineString(String text) {
        boolean inInlineContext = this.isInInlineContext();
        if (inInlineContext) {
            this.writeLineFeed();
            this.increaseIndent();
        }
        this.write("'''");
        this.writeLineFeed();
        Matcher matcher = LINE_FEED_PATTERN.matcher(text);
        int begin = 0;
        while (matcher.find(begin)) {
            this.writeCurrentIndent();
            this.write(text, begin, matcher.start());
            this.writeLineFeed();
            begin = matcher.end();
        }
        this.writeCurrentIndent();
        this.write(text, begin, text.length());
        this.writeLineFeed();
        this.writeCurrentIndent();
        this.write("'''");
        if (inInlineContext) {
            this.decreaseIndent();
        }
    }

    private boolean isInInlineContext() {
        return this.currentContext() == Context.MAP_ENTRY;
    }

    private void writeCurrentIndentIfApplicable() {
        if (this.shouldWriteIndentInContext(this.currentContext())) {
            this.writeCurrentIndent();
        }
    }

    private boolean shouldWriteIndentInContext(Context context) {
        return context == Context.ROOT || context == Context.LIST || context == Context.MAP;
    }

    private void requireValueContext() {
        this.requireContext(Context.ROOT, Context.LIST, Context.MAP_ENTRY);
    }

    private void requireContext(Context ... allowedContexts) {
        Context currentContext = this.currentContext();
        for (Context allowedContext : allowedContexts) {
            if (currentContext != allowedContext) continue;
            return;
        }
        throw new TweedDataWriteException("Writer is not in correct context, expected any of " + Arrays.toString((Object[])allowedContexts) + " but currently in " + (Object)((Object)currentContext));
    }

    private Context currentContext() {
        Context currentContext = this.contexts.peek();
        if (currentContext == null) {
            throw new IllegalStateException("Writing has terminated");
        }
        return currentContext;
    }

    private void pushContext(Context context) {
        switch (context.ordinal()) {
            case 0: {
                throw new IllegalArgumentException("Root context may not be pushed");
            }
            case 1: 
            case 2: {
                this.increaseIndent();
                break;
            }
        }
        this.contexts.push(context);
    }

    private void popContext() {
        switch (this.currentContext().ordinal()) {
            case 1: 
            case 2: {
                this.decreaseIndent();
                break;
            }
        }
        this.contexts.pop();
    }

    private void increaseIndent() {
        ++this.currentIndentLevel;
        this.currentIndentLength = this.currentIndentLevel * this.options.indent.length();
        this.ensureIndentBufferLength();
    }

    private void ensureIndentBufferLength() {
        while (this.currentIndentLength > this.indentBuffer.length()) {
            this.indentBuffer.append(this.options.indent);
        }
    }

    private void decreaseIndent() {
        if (this.currentIndentLevel == 0) {
            throw new IllegalStateException("Cannot decrease indent level, already at 0");
        }
        --this.currentIndentLevel;
        this.currentIndentLength = this.currentIndentLevel * this.options.indent.length();
    }

    private void writeCurrentIndent() {
        this.write(this.indentBuffer, 0, this.currentIndentLength);
    }

    private void writeLineFeed() {
        this.write(this.options.lineFeed);
    }

    private void write(CharSequence text, int begin, int end) {
        try {
            this.writer.append(text, begin, end);
        }
        catch (IOException e) {
            throw this.createExceptionForIOException(e);
        }
    }

    private void write(CharSequence text) {
        try {
            this.writer.append(text);
        }
        catch (IOException e) {
            throw this.createExceptionForIOException(e);
        }
    }

    private void writeCodepoint(int codepoint) {
        try {
            this.writer.write(codepoint);
        }
        catch (IOException e) {
            throw this.createExceptionForIOException(e);
        }
    }

    private TweedDataWriteException createExceptionForIOException(IOException e) {
        return new TweedDataWriteException("Writing Hjson failed", (Throwable)e);
    }

    public void close() throws Exception {
        this.writer.close();
    }

    public static class Options {
        private boolean doubleQuotedInlineStrings = true;
        private String indent = "\t";
        private String lineFeed = "\n";
        private HjsonCommentType inlineCommentType = HjsonCommentType.SLASHES;
        private HjsonCommentType multilineCommentType = HjsonCommentType.BLOCK;
        private HjsonStringType preferredInlineStringType = HjsonStringType.INLINE_QUOTELESS;

        public void inlineCommentType(HjsonCommentType commentType) {
            if (commentType.block()) {
                throw new IllegalArgumentException("Inline comment type must not be a block comment type: " + (Object)((Object)commentType));
            }
            this.inlineCommentType = commentType;
        }

        @Generated
        public Options() {
        }

        @Generated
        public boolean doubleQuotedInlineStrings() {
            return this.doubleQuotedInlineStrings;
        }

        @Generated
        public String indent() {
            return this.indent;
        }

        @Generated
        public String lineFeed() {
            return this.lineFeed;
        }

        @Generated
        public HjsonCommentType inlineCommentType() {
            return this.inlineCommentType;
        }

        @Generated
        public HjsonCommentType multilineCommentType() {
            return this.multilineCommentType;
        }

        @Generated
        public HjsonStringType preferredInlineStringType() {
            return this.preferredInlineStringType;
        }

        @Generated
        public Options doubleQuotedInlineStrings(boolean doubleQuotedInlineStrings) {
            this.doubleQuotedInlineStrings = doubleQuotedInlineStrings;
            return this;
        }

        @Generated
        public Options indent(String indent) {
            this.indent = indent;
            return this;
        }

        @Generated
        public Options lineFeed(String lineFeed) {
            this.lineFeed = lineFeed;
            return this;
        }

        @Generated
        public Options multilineCommentType(HjsonCommentType multilineCommentType) {
            this.multilineCommentType = multilineCommentType;
            return this;
        }

        @Generated
        public Options preferredInlineStringType(HjsonStringType preferredInlineStringType) {
            this.preferredInlineStringType = preferredInlineStringType;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Options)) {
                return false;
            }
            Options other = (Options)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.doubleQuotedInlineStrings() != other.doubleQuotedInlineStrings()) {
                return false;
            }
            String this$indent = this.indent();
            String other$indent = other.indent();
            if (this$indent == null ? other$indent != null : !this$indent.equals(other$indent)) {
                return false;
            }
            String this$lineFeed = this.lineFeed();
            String other$lineFeed = other.lineFeed();
            if (this$lineFeed == null ? other$lineFeed != null : !this$lineFeed.equals(other$lineFeed)) {
                return false;
            }
            HjsonCommentType this$inlineCommentType = this.inlineCommentType();
            HjsonCommentType other$inlineCommentType = other.inlineCommentType();
            if (this$inlineCommentType == null ? other$inlineCommentType != null : !((Object)((Object)this$inlineCommentType)).equals((Object)other$inlineCommentType)) {
                return false;
            }
            HjsonCommentType this$multilineCommentType = this.multilineCommentType();
            HjsonCommentType other$multilineCommentType = other.multilineCommentType();
            if (this$multilineCommentType == null ? other$multilineCommentType != null : !((Object)((Object)this$multilineCommentType)).equals((Object)other$multilineCommentType)) {
                return false;
            }
            HjsonStringType this$preferredInlineStringType = this.preferredInlineStringType();
            HjsonStringType other$preferredInlineStringType = other.preferredInlineStringType();
            return !(this$preferredInlineStringType == null ? other$preferredInlineStringType != null : !((Object)((Object)this$preferredInlineStringType)).equals((Object)other$preferredInlineStringType));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Options;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.doubleQuotedInlineStrings() ? 79 : 97);
            String $indent = this.indent();
            result = result * 59 + ($indent == null ? 43 : $indent.hashCode());
            String $lineFeed = this.lineFeed();
            result = result * 59 + ($lineFeed == null ? 43 : $lineFeed.hashCode());
            HjsonCommentType $inlineCommentType = this.inlineCommentType();
            result = result * 59 + ($inlineCommentType == null ? 43 : ((Object)((Object)$inlineCommentType)).hashCode());
            HjsonCommentType $multilineCommentType = this.multilineCommentType();
            result = result * 59 + ($multilineCommentType == null ? 43 : ((Object)((Object)$multilineCommentType)).hashCode());
            HjsonStringType $preferredInlineStringType = this.preferredInlineStringType();
            result = result * 59 + ($preferredInlineStringType == null ? 43 : ((Object)((Object)$preferredInlineStringType)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "HjsonWriter.Options(doubleQuotedInlineStrings=" + this.doubleQuotedInlineStrings() + ", indent=" + this.indent() + ", lineFeed=" + this.lineFeed() + ", inlineCommentType=" + (Object)((Object)this.inlineCommentType()) + ", multilineCommentType=" + (Object)((Object)this.multilineCommentType()) + ", preferredInlineStringType=" + (Object)((Object)this.preferredInlineStringType()) + ")";
        }
    }

    private static enum Context {
        ROOT,
        LIST,
        MAP,
        MAP_ENTRY;

    }
}

