/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.coat.screen;

import de.siphalor.coat.handler.Message;
import de.siphalor.coat.list.DynamicEntryListWidget;
import de.siphalor.coat.list.EntryContainer;
import de.siphalor.coat.list.category.ConfigTreeEntry;
import de.siphalor.coat.screen.ConfigContentWidget;
import de.siphalor.coat.screen.MessagesScreen;
import de.siphalor.coat.util.CoatColor;
import de.siphalor.coat.util.CoatUtil;
import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class ConfigScreen
extends class_437 {
    private static final String ABORT_TEXT_KEY = "coat.action.abort";
    private static final String ABORT_SCREEN_TITLE_TEXT_KEY = "coat.action.abort.screen.title";
    private static final String ABORT_SCREEN_DESC_TEXT_KEY = "coat.action.abort.screen.desc";
    private static final String SAVE_TEXT_KEY = "coat.action.save";
    private static final String SAVE_WARNINGS_TEXT_KEY = "coat.action.save.warnings";
    private static final String SAVE_ERRORS_TEXT_KEY = "coat.action.save.errors";
    private static final class_2561 ABORT_TEXT = class_2561.method_43471((String)"coat.action.abort");
    private static final class_2561 ABORT_SCREEN_TITLE_TEXT = class_2561.method_43471((String)"coat.action.abort.screen.title");
    private static final class_2561 ABORT_SCREEN_DESC_TEXT = class_2561.method_43471((String)"coat.action.abort.screen.desc");
    private static final class_2561 SAVE_TEXT = class_2561.method_43471((String)"coat.action.save");
    private static final class_2561 SAVE_WARNINGS_TEXT = class_2561.method_43471((String)"coat.action.save.warnings");
    private static final class_2561 SAVE_ERRORS_TEXT = class_2561.method_43471((String)"coat.action.save.errors");
    private static final CoatColor BACKGROUND_TEXTURE_TINT_COLOR = CoatColor.rgb(0x777777);
    private final class_437 parent;
    private final Collection<ConfigContentWidget> widgets;
    private ConfigTreeEntry openCategory;
    private Runnable onSave = () -> {};
    private class_2561 visualTitle;
    private int panelWidth;
    private DynamicEntryListWidget<ConfigTreeEntry> treeWidget;
    private class_4185 abortButton;
    private class_4185 saveButton;
    private ConfigContentWidget contentWidget;

    public ConfigScreen(class_437 parent, class_2561 title, Collection<ConfigContentWidget> widgets) {
        super(title);
        this.visualTitle = title.method_27661().method_27693(" - ").method_27693("missingno");
        this.parent = parent;
        this.widgets = widgets;
    }

    protected void method_25426() {
        this.panelWidth = 200;
        this.treeWidget = new DynamicEntryListWidget(this.field_22787, this.panelWidth, this.field_22790 - 60, 20, (int)((float)this.panelWidth * 0.8f));
        this.abortButton = class_4185.method_46430((class_2561)ABORT_TEXT, button -> this.method_25419()).method_46433(2, 0).method_46437(0, 20).method_46431();
        this.saveButton = class_4185.method_46430((class_2561)SAVE_TEXT, this::clickSave).method_46433(2, 0).method_46437(0, 20).method_46431();
        this.method_37063(this.treeWidget);
        this.method_37063((class_364)this.abortButton);
        this.method_37063((class_364)this.saveButton);
        for (ConfigContentWidget widget : this.widgets) {
            this.treeWidget.addEntry(widget.getTreeEntry());
        }
        super.method_25426();
        this.openCategory(this.treeWidget.getEntry(0));
    }

    public void method_25419() {
        class_310.method_1551().method_1507((class_437)new class_410(action -> {
            if (action) {
                class_310.method_1551().method_1507(this.parent);
            } else {
                class_310.method_1551().method_1507((class_437)this);
            }
        }, ABORT_SCREEN_TITLE_TEXT, ABORT_SCREEN_DESC_TEXT));
    }

    protected void onSave() {
        for (ConfigContentWidget widget : this.widgets) {
            widget.save();
        }
        this.onSave.run();
    }

    protected void clickSave(class_4185 button) {
        LinkedList warnings = new LinkedList();
        LinkedList<Message> errors = new LinkedList<Message>();
        int warningSev = Message.Level.WARNING.getSeverity();
        int errorSev = Message.Level.ERROR.getSeverity();
        this.treeWidget.entries().stream().flatMap(entry -> entry.getMessages().stream()).forEach(message -> {
            int sev = message.getLevel().getSeverity();
            if (sev >= errorSev) {
                errors.add((Message)message);
            } else if (sev >= warningSev) {
                warnings.add(message);
            }
        });
        Runnable saveRunnable = () -> {
            this.onSave();
            class_310.method_1551().method_1507(this.parent);
        };
        Runnable warningOpener = () -> class_310.method_1551().method_1507((class_437)new MessagesScreen(SAVE_WARNINGS_TEXT, this, saveRunnable, warnings));
        if (!errors.isEmpty()) {
            class_310.method_1551().method_1507((class_437)new MessagesScreen(SAVE_ERRORS_TEXT, this, warnings.isEmpty() ? saveRunnable : warningOpener, errors));
        } else if (!warnings.isEmpty()) {
            warningOpener.run();
        } else {
            saveRunnable.run();
        }
    }

    public void openCategory(ConfigTreeEntry category) {
        if (this.openCategory != null) {
            EntryContainer cur;
            this.openCategory.setOpen(false);
            LinkedList<EntryContainer> newHierarchy = new LinkedList<EntryContainer>();
            newHierarchy.add(category);
            while (((EntryContainer)newHierarchy.getFirst()).getParent() != this.treeWidget) {
                newHierarchy.push(((EntryContainer)newHierarchy.getFirst()).getParent());
            }
            ConfigTreeEntry last = null;
            for (cur = this.openCategory; cur != this.treeWidget && cur != category; cur = cur.getParent()) {
                if (newHierarchy.contains(cur)) {
                    if (last == null || !(last instanceof ConfigTreeEntry)) break;
                    last.removeTemporaryTrees();
                    break;
                }
                last = cur;
            }
            if (cur == this.treeWidget && ((ConfigTreeEntry)last).removeTemporaryTrees()) {
                this.treeWidget.entryHeightChanged(last);
            }
        }
        if (this.contentWidget != null) {
            this.method_37066(this.contentWidget);
        }
        this.openCategory = category;
        category.setOpen(true);
        EntryContainer parent = category;
        while ((parent = parent.getParent()) instanceof ConfigTreeEntry) {
            ((ConfigTreeEntry)parent).setExpanded(true);
        }
        this.contentWidget = category.getContentWidget();
        this.method_37063(this.contentWidget);
        this.contentWidget.setPosition(this.panelWidth, 20);
        this.contentWidget.setRowWidth(500);
        this.visualTitle = this.contentWidget.getName() == null || this.contentWidget.getName().getString().isEmpty() || this.contentWidget.getName().getString().equals(this.field_22785.getString()) ? this.field_22785 : this.field_22785.method_27661().method_27693(" - ").method_10852(this.contentWidget.getName());
        this.method_25410(this.field_22787, this.field_22789, this.field_22790);
    }

    public void openTemporary(ConfigTreeEntry temporaryTreeEntry) {
        this.openCategory.removeTemporaryTrees();
        this.openCategory.addTemporaryTree(temporaryTreeEntry);
        this.openCategory(temporaryTreeEntry);
    }

    public void method_25410(class_310 minecraft, int windowWidth, int windowHeight) {
        this.field_22789 = windowWidth;
        this.field_22790 = windowHeight;
        this.panelWidth = Math.max(100, (int)((double)windowWidth * 0.2));
        this.contentWidget.setPosition(this.panelWidth, 20);
        this.contentWidget.resize(windowWidth - this.panelWidth, windowHeight - 20);
        int saveButtonY = windowHeight - 20 - 2;
        int abortButtonY = saveButtonY - 20 - 2;
        CoatUtil.setButtonY(this.saveButton, saveButtonY);
        CoatUtil.setButtonY(this.abortButton, abortButtonY);
        this.saveButton.method_25358(this.panelWidth - 4);
        this.abortButton.method_25358(this.saveButton.method_25368());
        this.treeWidget.resize(this.panelWidth, abortButtonY - 20 - 2);
    }

    public void method_25393() {
        super.method_25393();
        this.treeWidget.tick();
        this.contentWidget.tick();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        graphics.method_44379(0, 20, this.field_22789, this.field_22790);
        super.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_44380();
        CoatUtil.drawHorizontalGradient(graphics, this.panelWidth, 20, this.panelWidth + 8, this.field_22790, CoatColor.BLACK.withAlpha(119), CoatColor.TRANSPARENT);
        CoatUtil.drawTintedTiledTexture(graphics, this.contentWidget.getBackground(), 0, 0, this.field_22789, 20, 32, 0, BACKGROUND_TEXTURE_TINT_COLOR);
        graphics.method_27534(this.field_22793, this.visualTitle, this.field_22789 / 2, 8, CoatColor.WHITE.getArgb());
        graphics.method_25296(0, this.abortButton.method_46427() - 2 - 8, this.panelWidth, this.abortButton.method_46427() - 2, CoatColor.TRANSPARENT.getArgb(), CoatColor.BLACK.withAlpha(119).getArgb());
    }

    @Generated
    public void setOnSave(Runnable onSave) {
        this.onSave = onSave;
    }

    @Generated
    public DynamicEntryListWidget<ConfigTreeEntry> getTreeWidget() {
        return this.treeWidget;
    }

    @Generated
    public ConfigContentWidget getContentWidget() {
        return this.contentWidget;
    }
}

