/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories.tag;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.util.MatrixUtils;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.plugin.client.categories.tag.TagNodeWidget;
import me.shedaniel.rei.plugin.common.displays.tag.TagNode;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_6880;
import org.joml.Matrix3x2f;

public class TagTreeWidget<S, T>
extends WidgetWithBounds {
    private final Rectangle bounds;
    private final TagNode<S> node;
    private final Rectangle overflowBounds;
    private final TagNodeWidget<S, T> rootWidget;
    private final List<TagTreeWidget<S, T>> childWidgets;
    private final List<WidgetWithBounds> children;

    public TagTreeWidget(TagNode<S> node, Function<class_6880<S>, EntryStack<T>> mapper, Rectangle overflowBounds) {
        this.node = node;
        this.overflowBounds = overflowBounds;
        this.rootWidget = TagNodeWidget.create(node, mapper, overflowBounds);
        this.childWidgets = new ArrayList<TagTreeWidget<S, T>>();
        for (TagNode<S> childNode : node.children()) {
            TagTreeWidget<S, T> childWidget = new TagTreeWidget<S, T>(childNode, mapper, overflowBounds);
            childWidget.getBounds().y = this.rootWidget.getBounds().getMaxY() + 16;
            this.childWidgets.add(childWidget);
        }
        int childrenTotalWidth = this.childWidgets.stream().map(WidgetWithBounds::getBounds).mapToInt(value -> value.width + 6).sum() - 6;
        int x = 0;
        for (TagTreeWidget<S, T> childWidget : this.childWidgets) {
            childWidget.getBounds().x = this.rootWidget.getBounds().getCenterX() - childrenTotalWidth / 2 + x;
            x += childWidget.getBounds().width + 6;
        }
        this.children = Stream.concat(Stream.of(this.rootWidget), this.childWidgets.stream()).toList();
        this.bounds = new Rectangle(this.children.stream().map(WidgetWithBounds::getBounds).reduce(Rectangle::union).orElse(new Rectangle()).getSize());
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.rootWidget.getBounds().setLocation(this.getBounds().getCenterX() - this.rootWidget.getBounds().getWidth() / 2, this.getBounds().y);
        this.rootWidget.method_25394(graphics, mouseX, mouseY, delta);
        if (this.childWidgets.isEmpty()) {
            return;
        }
        graphics.method_51742(this.rootWidget.getBounds().getCenterX(), this.rootWidget.getBounds().getMaxY(), this.rootWidget.getBounds().getMaxY() + 6, -1);
        int childrenTotalWidth = this.childWidgets.stream().map(WidgetWithBounds::getBounds).mapToInt(value -> value.width + 6).sum() - 6;
        graphics.method_51738(this.rootWidget.getBounds().getCenterX() - childrenTotalWidth / 2 + this.childWidgets.get((int)0).getBounds().width / 2, this.rootWidget.getBounds().getCenterX() + childrenTotalWidth / 2 - this.childWidgets.get((int)(this.childWidgets.size() - 1)).getBounds().width / 2, this.rootWidget.getBounds().getMaxY() + 6, -1);
        int x = 0;
        for (TagTreeWidget<S, T> childWidget : this.childWidgets) {
            graphics.method_51742(this.getBounds().getCenterX() - childrenTotalWidth / 2 + x + childWidget.getBounds().width / 2, this.rootWidget.getBounds().getMaxY() + 6, this.rootWidget.getBounds().getMaxY() + 16, -1);
            childWidget.getBounds().setLocation(this.getBounds().getCenterX() - childrenTotalWidth / 2 + x, this.rootWidget.getBounds().getMaxY() + 16);
            if (this.overflowBounds.intersects(MatrixUtils.transform((Matrix3x2f)graphics.method_51448(), childWidget.getBounds()))) {
                childWidget.method_25394(graphics, mouseX, mouseY, delta);
            }
            x += childWidget.getBounds().width + 6;
        }
    }

    public List<? extends class_364> method_25396() {
        return this.children;
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        return super.method_25402(event, doubleClick);
    }

    public boolean method_25406(class_11909 event) {
        for (class_364 element : this.method_25396()) {
            if (!element.method_25406(event)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25404(class_11908 event) {
        for (class_364 element : this.method_25396()) {
            if (!element.method_25404(event)) continue;
            return true;
        }
        return false;
    }
}

