/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.config;

import com.google.common.base.Preconditions;
import dev.architectury.utils.value.IntValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.Modifier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.config.ConfigAccess;
import me.shedaniel.rei.impl.client.gui.config.components.ConfigCategoriesListWidget;
import me.shedaniel.rei.impl.client.gui.config.components.ConfigEntriesListWidget;
import me.shedaniel.rei.impl.client.gui.config.components.ConfigSearchListWidget;
import me.shedaniel.rei.impl.client.gui.config.options.AllREIConfigCategories;
import me.shedaniel.rei.impl.client.gui.config.options.CompositeOption;
import me.shedaniel.rei.impl.client.gui.config.options.ConfigUtils;
import me.shedaniel.rei.impl.client.gui.config.options.OptionCategory;
import me.shedaniel.rei.impl.client.gui.config.options.OptionGroup;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.widget.HoleWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.TextFieldWidget;
import net.minecraft.class_1074;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class REIConfigScreen
extends class_437
implements ConfigAccess {
    private final class_437 parent;
    private final List<OptionCategory> categories;
    private final List<Widget> widgets = new ArrayList<Widget>();
    private final Map<String, ?> defaultOptions = new HashMap();
    private final Map<String, ?> options = new HashMap();
    private OptionCategory activeCategory;
    private boolean searching;
    @Nullable
    private Menu menu;
    @Nullable
    private Widget menuWidget;
    @Nullable
    private CompositeOption<ModifierKeyCode> focusedKeycodeOption = null;
    private ModifierKeyCode partialKeycode = null;

    public REIConfigScreen(class_437 parent) {
        this(parent, AllREIConfigCategories.CATEGORIES);
    }

    public REIConfigScreen(class_437 parent, List<OptionCategory> categories) {
        super((class_2561)class_2561.method_43471((String)"config.roughlyenoughitems.title"));
        this.parent = parent;
        this.categories = CollectionUtils.map(categories, OptionCategory::copy);
        this.cleanRequiresLevel();
        Preconditions.checkArgument((!this.categories.isEmpty() ? 1 : 0) != 0, (Object)"Categories cannot be empty!");
        this.activeCategory = this.categories.get(0);
        ConfigObjectImpl defaultConfig = new ConfigObjectImpl();
        ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
        for (OptionCategory category : this.categories) {
            for (OptionGroup group : category.getGroups()) {
                for (CompositeOption<?> option : group.getOptions()) {
                    this.defaultOptions.put(option.getId(), option.getBind().apply(defaultConfig));
                    this.options.put(option.getId(), option.getBind().apply(config));
                }
            }
        }
    }

    private void cleanRequiresLevel() {
        if (REIRuntime.getInstance().getPreviousContainerScreen() != null && class_310.method_1551().method_1562() != null) {
            return;
        }
        for (OptionCategory category : this.categories) {
            for (OptionGroup group : category.getGroups()) {
                group.getOptions().replaceAll(option -> {
                    if (option.isRequiresLevel()) {
                        return new CompositeOption<Integer>(option.getId(), option.getName(), option.getDescription(), i -> 0, (i, v) -> new Object()).entry(value -> ConfigUtils.translatable("config.rei.texts.requires_level").method_27692(class_124.field_1061)).defaultValue(() -> 1);
                    }
                    return option;
                });
            }
        }
    }

    public void method_25426() {
        super.method_25426();
        this.widgets.clear();
        this.widgets.add(Widgets.createLabel(new Point(this.field_22789 / 2, 12), this.field_22785));
        int sideWidth = (int)Math.round((double)this.field_22789 / 4.2);
        if (this.searching) {
            this.widgets.add(Widgets.createButton(new Rectangle(8, 32, sideWidth, 20), (class_2561)ConfigUtils.literal("\u21a9 ").method_10852((class_2561)ConfigUtils.translatable("gui.back"))).onClick(button -> this.setSearching(false)));
            this.widgets.add(HoleWidget.createMenuBackground(new Rectangle(8 + sideWidth + 4, 32, this.field_22789 - 16 - sideWidth - 4, 20)));
            TextFieldWidget textField = new TextFieldWidget(this, new Rectangle(8 + sideWidth + 4 + 6, 38, this.field_22789 - 16 - sideWidth - 4 - 10, 12)){

                @Override
                protected void renderSuggestion(class_332 graphics, int x, int y) {
                    int color = this.containsMouse(PointHelper.ofMouse()) || this.method_25370() ? -571806998 : -6250336;
                    graphics.method_25303(this.font, this.font.method_27523(this.getSuggestion(), this.getWidth()), x, y, color);
                }
            };
            textField.setHasBorder(false);
            textField.setMaxLength(9000);
            this.widgets.add(textField);
            this.widgets.add(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> {
                textField.setSuggestion(!textField.method_25370() && textField.getText().isEmpty() ? class_1074.method_4662((String)"config.rei.texts.search_options", (Object[])new Object[0]) : null);
                if (!textField.method_25370()) {
                    return;
                }
                Rectangle bounds = textField.getBounds();
                graphics.method_25294(bounds.x - 6, bounds.y - 6, bounds.getMaxX() + 4, bounds.y - 5, -2039584);
                graphics.method_25294(bounds.x - 6, bounds.getMaxY() + 1, bounds.getMaxX() + 4, bounds.getMaxY() + 2, -2039584);
                graphics.method_25294(bounds.x - 6, bounds.y - 6, bounds.x - 7, bounds.getMaxY() + 2, -2039584);
                graphics.method_25294(bounds.getMaxX() + 3, bounds.y - 6, bounds.getMaxX() + 4, bounds.getMaxY() + 2, -2039584);
            }));
            this.widgets.add(ConfigSearchListWidget.create(this, this.categories, textField, new Rectangle(8, 56, this.field_22789 - 16, this.field_22790 - 32 - 56)));
        } else {
            boolean singlePane = this.field_22789 - 20 - sideWidth <= 330;
            int singleSideWidth = 42;
            MutableObject list = new MutableObject((Object)this.createEntriesList(singlePane, singleSideWidth, sideWidth));
            IntValue selectedCategory = new IntValue(){
                final /* synthetic */ Mutable val$list;
                final /* synthetic */ boolean val$singlePane;
                final /* synthetic */ int val$singleSideWidth;
                final /* synthetic */ int val$sideWidth;
                {
                    this.val$list = mutable;
                    this.val$singlePane = bl;
                    this.val$singleSideWidth = n;
                    this.val$sideWidth = n2;
                }

                public void accept(int index) {
                    REIConfigScreen.this.activeCategory = REIConfigScreen.this.categories.get(index);
                    this.val$list.setValue((Object)REIConfigScreen.this.createEntriesList(this.val$singlePane, this.val$singleSideWidth, this.val$sideWidth));
                }

                public int getAsInt() {
                    return REIConfigScreen.this.categories.indexOf(REIConfigScreen.this.activeCategory);
                }
            };
            if (!singlePane) {
                this.widgets.add(ConfigCategoriesListWidget.create(new Rectangle(8, 32, sideWidth, this.field_22790 - 32 - 32), this.categories, selectedCategory));
            } else {
                this.widgets.add(ConfigCategoriesListWidget.createTiny(new Rectangle(8, 32, singleSideWidth - 4, this.field_22790 - 32 - 32), this.categories, selectedCategory));
            }
            this.widgets.add(Widgets.delegate(() -> ((Mutable)list).getValue()));
        }
        this.widgets.add(Widgets.createButton(new Rectangle(this.field_22789 / 2 - 150 - 10, this.field_22790 - 26, 150, 20), (class_2561)ConfigUtils.translatable("gui.cancel")).onClick(button -> class_310.method_1551().method_1507(this.parent)));
        this.widgets.add(Widgets.createButton(new Rectangle(this.field_22789 / 2 + 10, this.field_22790 - 26, 150, 20), (class_2561)ConfigUtils.translatable("gui.done")).onClick(button -> {
            for (OptionCategory optionCategory : this.categories) {
                for (OptionGroup group : optionCategory.getGroups()) {
                    for (CompositeOption<?> option : group.getOptions()) {
                        option.getSave().accept(ConfigManagerImpl.getInstance().getConfig(), this.get(option));
                    }
                }
            }
            ConfigManagerImpl.getInstance().saveConfig();
            EntryRegistry.getInstance().refilter();
            REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
            if (REIRuntimeImpl.getSearchField() != null) {
                ScreenOverlayImpl.getEntryListWidget().updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
            }
            class_310.method_1551().method_1507(this.parent);
        }));
    }

    private Widget createEntriesList(boolean singlePane, int singleSideWidth, int sideWidth) {
        return ConfigEntriesListWidget.create(this, new Rectangle(singlePane ? 8 + singleSideWidth : 12 + sideWidth, 32, singlePane ? this.field_22789 - 16 - singleSideWidth : this.field_22789 - 20 - sideWidth, this.field_22790 - 32 - 32), this.activeCategory.getGroups());
    }

    public Map<String, ?> getDefaultOptions() {
        return this.defaultOptions;
    }

    public Map<String, ?> getOptions() {
        return this.options;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        for (Widget widget : this.widgets) {
            widget.method_25394(graphics, mouseX, mouseY, delta);
        }
        ScreenOverlayImpl.getInstance().lateRender(graphics, mouseX, mouseY, delta);
    }

    public void method_25419() {
        if (this.searching) {
            this.setSearching(false);
        } else {
            this.field_22787.method_1507(this.parent);
        }
    }

    public List<? extends class_364> method_25396() {
        return this.widgets;
    }

    public boolean method_25400(class_11905 event) {
        if (this.menu != null && this.menu.method_25400(event)) {
            return true;
        }
        for (class_364 class_3642 : this.method_25396()) {
            if (!class_3642.method_25400(event)) continue;
            return true;
        }
        return super.method_25400(event);
    }

    public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
        if (this.menu != null && this.menu.method_25403(event, deltaX, deltaY)) {
            return true;
        }
        for (class_364 class_3642 : this.method_25396()) {
            if (!class_3642.method_25403(event, deltaX, deltaY)) continue;
            return true;
        }
        return super.method_25403(event, deltaX, deltaY);
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (this.menu != null) {
            if (!this.menu.method_25402(event, doubleClick)) {
                this.closeMenu();
            }
            return true;
        }
        if (this.focusedKeycodeOption != null && this.partialKeycode != null) {
            if (this.partialKeycode.isUnknown()) {
                this.partialKeycode.setKeyCode(class_3675.class_307.field_1672.method_1447(event.method_74245()));
            } else if (this.partialKeycode.getType() == class_3675.class_307.field_1668) {
                Modifier modifier = this.partialKeycode.getModifier();
                int code = this.partialKeycode.getKeyCode().method_1444();
                if (class_156.method_668() == class_156.class_158.field_1137 ? code == 343 || code == 347 : code == 341 || code == 345) {
                    this.partialKeycode.setModifier(Modifier.of((boolean)modifier.hasAlt(), (boolean)true, (boolean)modifier.hasShift()));
                    this.partialKeycode.setKeyCode(class_3675.class_307.field_1672.method_1447(event.method_74245()));
                    return true;
                }
                if (code == 344 || code == 340) {
                    this.partialKeycode.setModifier(Modifier.of((boolean)modifier.hasAlt(), (boolean)modifier.hasControl(), (boolean)true));
                    this.partialKeycode.setKeyCode(class_3675.class_307.field_1672.method_1447(event.method_74245()));
                    return true;
                }
                if (code == 342 || code == 346) {
                    this.partialKeycode.setModifier(Modifier.of((boolean)true, (boolean)modifier.hasControl(), (boolean)modifier.hasShift()));
                    this.partialKeycode.setKeyCode(class_3675.class_307.field_1672.method_1447(event.method_74245()));
                    return true;
                }
            }
            return true;
        }
        return super.method_25402(event, doubleClick);
    }

    public Optional<class_364> method_19355(double mouseX, double mouseY) {
        if (this.menu != null && this.menu.containsMouse(mouseX, mouseY)) {
            return Optional.of(this.menu);
        }
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.containsMouse(mouseX, mouseY)) continue;
            return Optional.of(widget);
        }
        return Optional.empty();
    }

    public boolean method_25406(class_11909 event) {
        if (this.menu != null && this.menu.method_25406(event)) {
            return true;
        }
        if (this.focusedKeycodeOption != null && this.partialKeycode != null && !this.partialKeycode.isUnknown()) {
            this.set(this.focusedKeycodeOption, this.partialKeycode);
            this.focusKeycode(null);
            return true;
        }
        for (class_364 class_3642 : this.method_25396()) {
            if (!class_3642.method_25406(event)) continue;
            return true;
        }
        return super.method_25406(event);
    }

    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.menu != null && this.menu.method_25401(mouseX, mouseY, amountX, amountY)) {
            return true;
        }
        for (class_364 class_3642 : this.method_25396()) {
            if (!class_3642.method_25401(mouseX, mouseY, amountX, amountY)) continue;
            return true;
        }
        return super.method_25401(mouseX, mouseY, amountX, amountY);
    }

    public boolean method_25404(class_11908 event) {
        if (this.focusedKeycodeOption != null) {
            if (event.comp_4795() != 256) {
                if (this.partialKeycode.isUnknown()) {
                    this.partialKeycode.setKeyCode(class_3675.method_15985((class_11908)event));
                } else {
                    Modifier modifier = this.partialKeycode.getModifier();
                    if (this.partialKeycode.getType() == class_3675.class_307.field_1668) {
                        int code = this.partialKeycode.getKeyCode().method_1444();
                        if (class_156.method_668() == class_156.class_158.field_1137 ? code == 343 || code == 347 : code == 341 || code == 345) {
                            this.partialKeycode.setModifier(Modifier.of((boolean)modifier.hasAlt(), (boolean)true, (boolean)modifier.hasShift()));
                            this.partialKeycode.setKeyCode(class_3675.method_15985((class_11908)event));
                            return true;
                        }
                        if (code == 344 || code == 340) {
                            this.partialKeycode.setModifier(Modifier.of((boolean)modifier.hasAlt(), (boolean)modifier.hasControl(), (boolean)true));
                            this.partialKeycode.setKeyCode(class_3675.method_15985((class_11908)event));
                            return true;
                        }
                        if (code == 342 || code == 346) {
                            this.partialKeycode.setModifier(Modifier.of((boolean)true, (boolean)modifier.hasControl(), (boolean)modifier.hasShift()));
                            this.partialKeycode.setKeyCode(class_3675.method_15985((class_11908)event));
                            return true;
                        }
                    }
                    if (event.method_74240()) {
                        this.partialKeycode.setModifier(Modifier.of((boolean)modifier.hasAlt(), (boolean)true, (boolean)modifier.hasShift()));
                        return true;
                    }
                    if (event.method_74239()) {
                        this.partialKeycode.setModifier(Modifier.of((boolean)modifier.hasAlt(), (boolean)modifier.hasControl(), (boolean)true));
                        return true;
                    }
                    if (event.method_74238()) {
                        this.partialKeycode.setModifier(Modifier.of((boolean)true, (boolean)modifier.hasControl(), (boolean)modifier.hasShift()));
                        return true;
                    }
                }
            } else {
                this.set(this.focusedKeycodeOption, ModifierKeyCode.unknown());
                this.focusKeycode(null);
            }
            return true;
        }
        return super.method_25404(event);
    }

    public boolean method_16803(class_11908 event) {
        if (this.focusedKeycodeOption != null && this.partialKeycode != null) {
            this.set(this.focusedKeycodeOption, this.partialKeycode);
            this.focusKeycode(null);
            return true;
        }
        return super.method_16803(event);
    }

    @Override
    public void openMenu(Menu menu) {
        if (this.menu != null) {
            this.widgets.remove(this.menuWidget);
        }
        this.menu = menu;
        this.menuWidget = menu;
        this.widgets.add(this.menuWidget);
    }

    @Override
    public void closeMenu() {
        this.widgets.remove(this.menuWidget);
        this.menu = null;
        this.menuWidget = null;
    }

    @Override
    public <T> T get(CompositeOption<T> option) {
        return (T)this.getOptions().get(option.getId());
    }

    @Override
    public <T> void set(CompositeOption<T> option, T value) {
        this.getOptions().put(option.getId(), value);
    }

    @Override
    public <T> T getDefault(CompositeOption<T> option) {
        return (T)this.getDefaultOptions().get(option.getId());
    }

    @Override
    public void focusKeycode(CompositeOption<ModifierKeyCode> option) {
        this.focusedKeycodeOption = option;
        if (this.focusedKeycodeOption != null) {
            this.partialKeycode = this.get(this.focusedKeycodeOption);
            this.partialKeycode.setKeyCodeAndModifier(class_3675.field_16237, Modifier.none());
        } else {
            this.partialKeycode = null;
        }
    }

    @Override
    @Nullable
    public CompositeOption<ModifierKeyCode> getFocusedKeycode() {
        return this.focusedKeycodeOption;
    }

    public void setSearching(boolean searching) {
        this.searching = searching;
        this.method_25423(this.field_22787, this.field_22789, this.field_22790);
    }

    public boolean isSearching() {
        return this.searching;
    }
}

