/*
 * Decompiled with CFR 0.152.
 */
package dev.caoimhe.oneclickjoin.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneClickJoinConfig {
    public static final OneClickJoinConfig INSTANCE = new OneClickJoinConfig();
    private static final Path CONFIG_PATH = class_310.method_1551().field_1697.toPath().resolve("config").resolve("one-click-join");
    private static final Logger LOGGER = LoggerFactory.getLogger(OneClickJoinConfig.class);
    @Nullable
    private String lastServerAddress = null;

    public void load() {
        try {
            this.lastServerAddress = Files.readString(CONFIG_PATH).trim();
        }
        catch (NoSuchFileException e) {
            LOGGER.warn("No configuration file found ({}), assuming this is okay, using default values", (Object)CONFIG_PATH.toAbsolutePath());
        }
        catch (IOException e) {
            LOGGER.warn("Failed to read config file, using default values", (Throwable)e);
        }
    }

    @Nullable
    public String lastServerAddress() {
        return this.lastServerAddress;
    }

    public void setLastServerAddress(@Nullable String lastServerAddress) {
        this.lastServerAddress = lastServerAddress;
        try {
            Files.writeString(CONFIG_PATH, (CharSequence)Objects.requireNonNullElse(this.lastServerAddress, ""), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to write last server address to config file", (Throwable)e);
        }
    }
}

