/*
 * Decompiled with CFR 0.152.
 */
package me.user3001.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import me.user3001.No_server_leak_on_stream;
import me.user3001.config.ModConfig;
import me.user3001.util.DebugLogger;

public class StreamingDetector {
    private static volatile boolean isStreamingDetected = false;
    private static long lastCheck = 0L;
    private static final long CACHE_DURATION = 5000L;
    private static volatile boolean isChecking = false;
    private static final Set<String> cachedProcessNames = ConcurrentHashMap.newKeySet();
    private static long lastProcessCacheUpdate = 0L;
    private static final long PROCESS_CACHE_DURATION = 3000L;
    private static Set<String> streamingSoftwareSet = null;
    private static long lastConfigCheck = 0L;
    private static final long CONFIG_CACHE_DURATION = 30000L;

    public static boolean isStreamingActive() {
        if (!ModConfig.getInstance().enableStreamingDetection) {
            return false;
        }
        return isStreamingDetected;
    }

    public static void checkStreamingStatus() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastCheck > 5000L && !isChecking) {
            lastCheck = currentTime;
            StreamingDetector.updateStreamingStatusAsync();
        }
    }

    public static boolean checkStreamingStatusSync() {
        if (!ModConfig.getInstance().enableStreamingDetection) {
            return false;
        }
        try {
            boolean detected;
            isStreamingDetected = detected = StreamingDetector.detectStreamingProcesses();
            lastCheck = System.currentTimeMillis();
            return detected;
        }
        catch (Exception e) {
            No_server_leak_on_stream.LOGGER.error("Error detecting streaming status", (Throwable)e);
            isStreamingDetected = false;
            return false;
        }
    }

    private static void updateStreamingStatusAsync() {
        if (isChecking) {
            return;
        }
        isChecking = true;
        CompletableFuture.runAsync(() -> {
            try {
                boolean detected;
                isStreamingDetected = detected = StreamingDetector.detectStreamingProcesses();
                if (detected) {
                    No_server_leak_on_stream.LOGGER.info("Streaming software detected - protection active");
                } else {
                    DebugLogger.debug("No streaming software detected");
                }
            }
            catch (Exception e) {
                No_server_leak_on_stream.LOGGER.error("Error detecting streaming status", (Throwable)e);
                isStreamingDetected = false;
            }
            finally {
                isChecking = false;
            }
        });
    }

    private static boolean detectStreamingProcesses() {
        try {
            Set<String> processNames;
            StreamingDetector.updateStreamingSoftwareCache();
            try {
                processNames = StreamingDetector.getProcessNamesUsingProcessHandle();
                if (!processNames.isEmpty()) {
                    DebugLogger.debug("Using ProcessHandle API, found %d processes", processNames.size());
                    return StreamingDetector.checkForStreamingSoftware(processNames);
                }
            }
            catch (Exception e) {
                DebugLogger.debug("ProcessHandle API failed: %s", e.getMessage());
            }
            try {
                processNames = StreamingDetector.getProcessNamesUsingSystemCommands();
                if (!processNames.isEmpty()) {
                    DebugLogger.debug("Using system commands, found %d processes", processNames.size());
                    return StreamingDetector.checkForStreamingSoftware(processNames);
                }
            }
            catch (Exception e) {
                DebugLogger.debug("System commands failed: %s", e.getMessage());
            }
            DebugLogger.debug("All process detection methods failed");
            return false;
        }
        catch (Exception e) {
            DebugLogger.debug("Process detection failed completely: %s", e.getMessage());
            return false;
        }
    }

    private static Set<String> getProcessNamesUsingProcessHandle() {
        HashSet<String> processNames = new HashSet<String>();
        ProcessHandle.allProcesses().forEach(process -> {
            try {
                process.info().command().ifPresent(command -> {
                    String processName = StreamingDetector.extractProcessName(command);
                    if (!processName.isEmpty()) {
                        processNames.add(processName);
                    }
                });
                process.info().arguments().ifPresent(args -> {
                    String processName;
                    if (((String[])args).length > 0 && !(processName = StreamingDetector.extractProcessName(args[0])).isEmpty()) {
                        processNames.add(processName);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        DebugLogger.debug("ProcessHandle found %d unique process names", processNames.size());
        return processNames;
    }

    private static Set<String> getProcessNamesUsingSystemCommands() {
        HashSet<String> processNames = new HashSet<String>();
        String os = System.getProperty("os.name").toLowerCase();
        try {
            ProcessBuilder processBuilder;
            if (os.contains("win")) {
                processBuilder = new ProcessBuilder("tasklist", "/fo", "csv", "/nh");
            } else if (os.contains("mac")) {
                processBuilder = new ProcessBuilder("ps", "-axco", "comm");
            } else {
                DebugLogger.debug("Unsupported operating system for streaming detection: %s", os);
                return processNames;
            }
            Process process = processBuilder.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String processName;
                    if (line.trim().isEmpty()) continue;
                    if (os.contains("win")) {
                        if (line.startsWith("\"")) {
                            int endQuote = line.indexOf("\"", 1);
                            if (endQuote <= 1) continue;
                            processName = line.substring(1, endQuote);
                        } else {
                            String[] parts = line.split(",");
                            if (parts.length <= 0) continue;
                            processName = parts[0].replace("\"", "");
                        }
                    } else {
                        processName = line.trim();
                    }
                    if ((processName = StreamingDetector.extractProcessName(processName)).isEmpty()) continue;
                    processNames.add(processName);
                }
            }
            DebugLogger.debug("System commands found %d unique process names", processNames.size());
            return processNames;
        }
        catch (Exception e) {
            DebugLogger.debug("System command execution failed: %s", e.getMessage());
            return processNames;
        }
    }

    private static String extractProcessName(String fullPath) {
        int spaceIndex;
        int lastSlash;
        if (fullPath == null || fullPath.trim().isEmpty()) {
            return "";
        }
        String cleaned = fullPath.trim();
        if (cleaned.startsWith("\"") && cleaned.endsWith("\"")) {
            cleaned = cleaned.substring(1, cleaned.length() - 1);
        }
        if ((lastSlash = Math.max(cleaned.lastIndexOf(47), cleaned.lastIndexOf(92))) >= 0 && lastSlash < cleaned.length() - 1) {
            cleaned = cleaned.substring(lastSlash + 1);
        }
        if ((spaceIndex = cleaned.indexOf(32)) > 0) {
            cleaned = cleaned.substring(0, spaceIndex);
        }
        return cleaned;
    }

    private static boolean checkForStreamingSoftware(Set<String> processNames) {
        if (processNames.isEmpty() || streamingSoftwareSet == null) {
            return false;
        }
        DebugLogger.debug("Checking %d processes against %d streaming software entries", processNames.size(), streamingSoftwareSet.size());
        for (String processName : processNames) {
            String lowerProcessName = processName.toLowerCase();
            if (!streamingSoftwareSet.contains(lowerProcessName)) continue;
            DebugLogger.debug("Exact match found: %s", processName);
            No_server_leak_on_stream.LOGGER.info("Streaming software detected: {}", (Object)processName);
            return true;
        }
        DebugLogger.debug("No streaming software matches found");
        return false;
    }

    private static void updateStreamingSoftwareCache() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastConfigCheck < 30000L && streamingSoftwareSet != null) {
            return;
        }
        lastConfigCheck = currentTime;
        ModConfig config = ModConfig.getInstance();
        String[] streamingSoftware = config.getStreamingSoftware();
        streamingSoftwareSet = Arrays.stream(streamingSoftware).filter(name -> name != null && !name.trim().isEmpty()).map(String::toLowerCase).collect(Collectors.toSet());
        DebugLogger.debug("Updated streaming software cache with %d entries", streamingSoftwareSet.size());
    }

    public static String getStatusString() {
        if (!ModConfig.getInstance().enableStreamingDetection) {
            return "Detection disabled";
        }
        if (isChecking) {
            return "Checking...";
        }
        return isStreamingDetected ? "Streaming detected" : "No streaming detected";
    }

    public static void refreshCache() {
        lastCheck = 0L;
        lastConfigCheck = 0L;
        streamingSoftwareSet = null;
        cachedProcessNames.clear();
    }
}

