/*
 * Decompiled with CFR 0.152.
 */
package me.user3001.mixin;

import me.user3001.config.ModConfig;
import me.user3001.gui.widget.StreamingProtectionButton;
import me.user3001.mixin.ScreenAccessor;
import me.user3001.util.DebugLogger;
import me.user3001.util.KeyHandler;
import me.user3001.util.StreamingDetector;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_500;
import net.minecraft.class_642;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_500.class})
public class MultiplayerScreenMixin {
    @Shadow
    private class_642 field_3051;
    @Unique
    private class_327 textRenderer;
    @Unique
    private class_4185 directConnectButton;
    @Unique
    private class_4185 editButton;
    @Unique
    private class_4185 addServerButton;
    @Unique
    private class_4185 streamingProtectionButton;
    @Unique
    private boolean shouldShowTooltip = false;
    @Unique
    private int tooltipX = 0;
    @Unique
    private int tooltipY = 0;
    @Unique
    private class_4185 hoveredButton = null;
    @Unique
    private boolean lastStreamingState = false;
    @Unique
    private boolean lastBypassState = false;
    @Unique
    private String cachedTooltipMessage = null;
    @Unique
    private long lastEditButtonCheck = 0L;
    @Unique
    private long lastDebugLog = 0L;
    private static final long DEBUG_LOG_INTERVAL = 1000L;
    @Unique
    private boolean showingIconTooltip = false;
    @Unique
    private String cachedIconTooltipMessage = null;
    @Unique
    private static final class_2960 STREAMING_ACTIVE_TEXTURE = class_2960.method_60655((String)"no_server_leak_on_stream", (String)"textures/gui/streaming_active.png");
    @Unique
    private static final class_2960 STREAMING_BYPASSED_TEXTURE = class_2960.method_60655((String)"no_server_leak_on_stream", (String)"textures/gui/streaming_bypassed.png");

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void onInit(CallbackInfo ci) {
        this.textRenderer = class_310.method_1551().field_1772;
        StreamingDetector.checkStreamingStatus();
        this.directConnectButton = null;
        this.addServerButton = null;
        this.editButton = null;
        this.streamingProtectionButton = null;
        this.lastEditButtonCheck = 0L;
        this.createStreamingProtectionButton();
        class_500 self = (class_500)this;
        if (self.method_25396() != null) {
            class_4185[] buttons = (class_4185[])self.method_25396().stream().filter(element -> element instanceof class_4185).map(element -> (class_4185)element).filter(button -> button.method_46427() > self.field_22790 / 2).sorted((a, b) -> Integer.compare(a.method_46426(), b.method_46426())).toArray(class_4185[]::new);
            DebugLogger.debug("MultiplayerScreen: Button layout:");
            for (int i = 0; i < buttons.length; ++i) {
                String text = buttons[i].method_25369().getString();
                DebugLogger.debug("  Position %d: '%s' at (%d, %d)", i, text, buttons[i].method_46426(), buttons[i].method_46427());
            }
            if (buttons.length >= 6) {
                this.editButton = buttons[1];
                this.directConnectButton = buttons[3];
                this.addServerButton = buttons[5];
                DebugLogger.debug("MultiplayerScreen: Identified buttons by position:");
                DebugLogger.debug("  Edit: '%s'", this.editButton.method_25369().getString());
                DebugLogger.debug("  Direct Connect: '%s'", this.directConnectButton.method_25369().getString());
                DebugLogger.debug("  Add Server: '%s'", this.addServerButton.method_25369().getString());
            } else {
                DebugLogger.debug("MultiplayerScreen: Not enough buttons found for position-based detection (need at least 6, found %d)", buttons.length);
            }
        }
        this.updateButtonStates();
    }

    @Unique
    private void createStreamingProtectionButton() {
        this.streamingProtectionButton = new StreamingProtectionButton(8, 8, 20, 20, (class_2561)class_2561.method_43473(), button -> DebugLogger.debug("Streaming protection button clicked"));
        ((ScreenAccessor)((Object)this)).invokeAddDrawableChild(this.streamingProtectionButton);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        long currentTime;
        boolean currentStreamingState = StreamingDetector.isStreamingActive();
        boolean currentBypassState = KeyHandler.isBypassKeyPressed();
        if (currentStreamingState != this.lastStreamingState || currentBypassState != this.lastBypassState) {
            this.updateButtonStates();
            this.lastStreamingState = currentStreamingState;
            this.lastBypassState = currentBypassState;
            this.cachedTooltipMessage = null;
        }
        if ((currentTime = System.currentTimeMillis()) - this.lastEditButtonCheck >= 250L) {
            this.lastEditButtonCheck = currentTime;
            this.enforceEditButtonState();
        }
    }

    @Unique
    private void updateStreamingProtectionButton() {
        if (this.streamingProtectionButton != null) {
            boolean streamingActive = StreamingDetector.isStreamingActive();
            boolean showWarnings = ModConfig.getInstance().showWarningMessage;
            boolean bl = this.streamingProtectionButton.field_22764 = streamingActive && showWarnings;
            if (streamingActive && showWarnings) {
                boolean bypassPressed = KeyHandler.isBypassKeyPressed();
                ((StreamingProtectionButton)this.streamingProtectionButton).setBypassed(bypassPressed);
            }
        }
    }

    @Unique
    private void renderInfoBox(class_332 context, int mouseX, int mouseY) {
        if (this.cachedTooltipMessage == null) {
            String messageKey = this.hoveredButton == this.directConnectButton ? "message.no_server_leak_on_stream.direct_connect_blocked" : (this.hoveredButton == this.editButton ? "message.no_server_leak_on_stream.edit_server_blocked" : (this.hoveredButton == this.addServerButton ? "message.no_server_leak_on_stream.add_server_blocked" : "message.no_server_leak_on_stream.direct_connect_blocked"));
            this.cachedTooltipMessage = class_2561.method_43469((String)messageKey, (Object[])new Object[]{ModConfig.getInstance().getLocalizedBypassKeyName()}).getString();
            DebugLogger.debug("Generated info box message: '%s'", this.cachedTooltipMessage);
        }
        int boxWidth = Math.max(200, this.textRenderer.method_1727(this.cachedTooltipMessage) + 20);
        int boxHeight = 60;
        class_500 self = (class_500)this;
        int boxX = Math.min(mouseX + 10, self.field_22789 - boxWidth - 10);
        int boxY = Math.max(10, mouseY - boxHeight - 10);
        context.method_25294(boxX - 2, boxY - 2, boxX + boxWidth + 2, boxY + boxHeight + 2, -12303292);
        context.method_25294(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -268435456);
        context.method_25294(boxX + 4, boxY + 4, boxX + 20, boxY + 20, -39424);
        String warningSymbol = class_2561.method_43471((String)"message.no_server_leak_on_stream.warning_symbol").getString();
        context.method_25300(this.textRenderer, warningSymbol, boxX + 12, boxY + 8, -1);
        String titleText = class_2561.method_43471((String)"message.no_server_leak_on_stream.streaming_protection").getString();
        context.method_25303(this.textRenderer, titleText, boxX + 25, boxY + 6, -39424);
        String[] lines = this.wrapText(this.cachedTooltipMessage, boxWidth - 30);
        for (int i = 0; i < lines.length && i < 2; ++i) {
            context.method_25303(this.textRenderer, lines[i], boxX + 25, boxY + 20 + i * 10, -1);
        }
        String bypassKey = ModConfig.getInstance().getLocalizedBypassKeyName();
        String bypassText = class_2561.method_43469((String)"message.no_server_leak_on_stream.hold_key_to_bypass", (Object[])new Object[]{bypassKey}).getString();
        context.method_25303(this.textRenderer, bypassText, boxX + 25, boxY + 45, -16711936);
    }

    @Unique
    private String[] wrapText(String text, int maxWidth) {
        String[] words = text.split(" ");
        StringBuilder line1 = new StringBuilder();
        StringBuilder line2 = new StringBuilder();
        boolean useSecondLine = false;
        for (String word : words) {
            Object testLine = (useSecondLine ? line2 : line1).toString();
            if (!((String)testLine).isEmpty()) {
                testLine = (String)testLine + " ";
            }
            if (this.textRenderer.method_1727((String)(testLine = (String)testLine + word)) <= maxWidth) {
                if (useSecondLine) {
                    if (line2.length() > 0) {
                        line2.append(" ");
                    }
                    line2.append(word);
                    continue;
                }
                if (line1.length() > 0) {
                    line1.append(" ");
                }
                line1.append(word);
                continue;
            }
            if (useSecondLine) break;
            useSecondLine = true;
            line2.append(word);
        }
        return new String[]{line1.toString(), line2.toString()};
    }

    @Unique
    private void updateHoverState(int mouseX, int mouseY) {
        boolean shouldDebugLog;
        boolean wasShowingTooltip = this.shouldShowTooltip;
        this.shouldShowTooltip = false;
        this.hoveredButton = null;
        long currentTime = System.currentTimeMillis();
        boolean bl = shouldDebugLog = currentTime - this.lastDebugLog > 1000L;
        if (StreamingDetector.isStreamingActive()) {
            boolean bypassPressed = KeyHandler.isBypassKeyPressed();
            if (shouldDebugLog) {
                DebugLogger.debug("Tooltip check: streaming active, bypass=%s, mousePos=(%d,%d)", bypassPressed, mouseX, mouseY);
                this.lastDebugLog = currentTime;
            }
            if (this.directConnectButton != null && !this.directConnectButton.field_22763 && this.directConnectButton.method_25405((double)mouseX, (double)mouseY)) {
                if (shouldDebugLog) {
                    DebugLogger.debug("Direct Connect button hovered, bypassed=%s", bypassPressed);
                }
                if (!bypassPressed) {
                    this.shouldShowTooltip = true;
                    this.hoveredButton = this.directConnectButton;
                    this.tooltipX = mouseX;
                    this.tooltipY = mouseY;
                    if (shouldDebugLog) {
                        DebugLogger.debug("Showing tooltip for Direct Connect button");
                    }
                }
            } else if (this.editButton != null && !this.editButton.field_22763 && this.editButton.method_25405((double)mouseX, (double)mouseY)) {
                boolean serverSelected = this.isServerSelected();
                if (shouldDebugLog) {
                    DebugLogger.debug("Edit button hovered, serverSelected=%s, bypassed=%s", serverSelected, bypassPressed);
                }
                if (serverSelected && !bypassPressed) {
                    this.shouldShowTooltip = true;
                    this.hoveredButton = this.editButton;
                    this.tooltipX = mouseX;
                    this.tooltipY = mouseY;
                    if (shouldDebugLog) {
                        DebugLogger.debug("Showing tooltip for Edit button");
                    }
                }
            } else if (this.addServerButton != null && !this.addServerButton.field_22763 && this.addServerButton.method_25405((double)mouseX, (double)mouseY)) {
                if (shouldDebugLog) {
                    DebugLogger.debug("Add Server button hovered, bypassed=%s", bypassPressed);
                }
                if (!bypassPressed) {
                    this.shouldShowTooltip = true;
                    this.hoveredButton = this.addServerButton;
                    this.tooltipX = mouseX;
                    this.tooltipY = mouseY;
                    if (shouldDebugLog) {
                        DebugLogger.debug("Showing tooltip for Add Server button");
                    }
                }
            }
        } else if (shouldDebugLog) {
            DebugLogger.debug("No tooltip check: streaming not active");
        }
        if (this.shouldShowTooltip != wasShowingTooltip && this.shouldShowTooltip) {
            DebugLogger.debug("Tooltip state changed: SHOW for button %s", this.hoveredButton != null ? this.hoveredButton.method_25369().getString() : "null");
        }
    }

    @Unique
    private boolean isServerSelected() {
        if (this.field_3051 != null) {
            return true;
        }
        boolean streamingActive = StreamingDetector.isStreamingActive();
        if (!streamingActive && this.editButton != null) {
            return this.editButton.field_22763;
        }
        return false;
    }

    @Unique
    private void enforceEditButtonState() {
        boolean streamingActive = StreamingDetector.isStreamingActive();
        boolean bypassPressed = KeyHandler.isBypassKeyPressed();
        if (this.editButton != null && streamingActive) {
            if (this.editButton.field_22763 && !bypassPressed) {
                this.editButton.field_22763 = false;
                DebugLogger.debug("Timer: Disabled edit button (streaming active, no bypass)");
            } else if (!this.editButton.field_22763 && bypassPressed) {
                this.editButton.field_22763 = true;
                DebugLogger.debug("Timer: Enabled edit button (bypass key pressed)");
            }
        }
    }

    @Unique
    private void updateButtonStates() {
        boolean shouldEnable;
        boolean streamingActive = StreamingDetector.isStreamingActive();
        boolean bypassPressed = KeyHandler.isBypassKeyPressed();
        DebugLogger.debugState("updateButtonStates", "streaming", streamingActive, "bypass", bypassPressed);
        if (this.directConnectButton != null) {
            this.directConnectButton.field_22763 = shouldEnable = !streamingActive || bypassPressed;
            DebugLogger.debug("Direct Connect button: %s", shouldEnable);
        }
        if (this.addServerButton != null) {
            this.addServerButton.field_22763 = shouldEnable = !streamingActive || bypassPressed;
            DebugLogger.debug("Add Server button: %s", shouldEnable);
        }
        if (this.editButton != null) {
            if (!streamingActive) {
                DebugLogger.debug("Edit button (not streaming): letting Minecraft handle naturally");
            } else {
                this.editButton.field_22763 = shouldEnable = bypassPressed;
                DebugLogger.debug("Edit button (streaming): initial state=%s", shouldEnable);
            }
        }
    }

    @Unique
    private void renderStreamingProtectionIcon(class_332 context, int mouseX, int mouseY) {
        boolean streamingActive = StreamingDetector.isStreamingActive();
        boolean bypassPressed = KeyHandler.isBypassKeyPressed();
        if (!streamingActive) {
            this.showingIconTooltip = false;
            return;
        }
        int iconX = 8;
        int iconY = 8;
        int iconSize = 24;
        int innerSize = iconSize - 4;
        long time = System.currentTimeMillis();
        float pulse = (float)Math.sin((double)time * 0.005) * 0.2f + 0.8f;
        int baseColor = bypassPressed ? -16733696 : -48060;
        int pulseColor = (int)(255.0f * pulse) << 24 | baseColor & 0xFFFFFF;
        context.method_25294(iconX - 1, iconY - 1, iconX + iconSize + 1, iconY + iconSize + 1, Integer.MIN_VALUE);
        context.method_25294(iconX, iconY, iconX + iconSize, iconY + iconSize, pulseColor);
        context.method_25294(iconX + 2, iconY + 2, iconX + iconSize - 2, iconY + iconSize - 2, -16777216);
        context.method_25294(iconX + 3, iconY + 3, iconX + iconSize - 3, iconY + iconSize - 3, -1);
        int dotSize = 8;
        int dotX = iconX + (iconSize - dotSize) / 2;
        int dotY = iconY + (iconSize - dotSize) / 2;
        context.method_25294(dotX, dotY, dotX + dotSize, dotY + dotSize, bypassPressed ? -16711936 : -65536);
        String recText = bypassPressed ? "BYP" : "REC";
        int textX = iconX + iconSize / 2 - this.textRenderer.method_1727(recText) / 2;
        int textY = iconY + iconSize / 2 + 3;
        context.method_51433(this.textRenderer, recText, textX, textY, -16777216, false);
        if (!bypassPressed) {
            float borderPulse = (float)Math.sin((double)time * 0.008) * 0.5f + 0.5f;
            int borderColor = (int)(255.0f * borderPulse) << 24 | 0xFFFF00;
            context.method_25294(iconX, iconY, iconX + iconSize, iconY + 1, borderColor);
            context.method_25294(iconX, iconY + iconSize - 1, iconX + iconSize, iconY + iconSize, borderColor);
            context.method_25294(iconX, iconY, iconX + 1, iconY + iconSize, borderColor);
            context.method_25294(iconX + iconSize - 1, iconY, iconX + iconSize, iconY + iconSize, borderColor);
        }
    }
}

