/*
 * Decompiled with CFR 0.152.
 */
package me.user3001.gui.widget;

import java.util.Objects;
import me.user3001.config.ModConfig;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_6381;
import net.minecraft.class_6382;

public class StreamingProtectionButton
extends class_4185 {
    private boolean bypassed = false;
    private boolean showTooltip = false;
    private boolean showIcon = true;
    private static final class_2960 STREAMING_ACTIVE_TEXTURE = class_2960.method_60655((String)"no_server_leak_on_stream", (String)"textures/gui/streaming_active.png");
    private static final class_2960 STREAMING_BYPASSED_TEXTURE = class_2960.method_60655((String)"no_server_leak_on_stream", (String)"textures/gui/streaming_bypassed.png");

    public StreamingProtectionButton(int x, int y, int width, int height, class_2561 message, class_4185.class_4241 onPress) {
        super(x, y, width, height, message, onPress, field_40754);
    }

    public void setBypassed(boolean bypassed) {
        this.bypassed = bypassed;
    }

    public void setShowIcon(boolean showIcon) {
        this.showIcon = showIcon;
    }

    public boolean isShowingTooltip() {
        return this.showTooltip;
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        if (!(ModConfig.getInstance().showWarningMessage && this.field_22764 && this.showIcon)) {
            return;
        }
        this.showTooltip = this.method_25405(mouseX, mouseY);
        super.method_48579(context, mouseX, mouseY, delta);
        this.drawInformationIcon(context);
        if (!this.bypassed && this.field_22764) {
            this.drawPulsingBorder(context);
        }
    }

    private void drawInformationIcon(class_332 context) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        int centerX = this.method_46426() + this.method_25368() / 2;
        int centerY = this.method_46427() + this.method_25364() / 2;
        String infoChar = "i";
        int textWidth = textRenderer.method_1727(infoChar);
        Objects.requireNonNull(textRenderer);
        int textHeight = 9;
        int textX = centerX - textWidth / 2;
        int textY = centerY - textHeight / 2;
        int textColor = this.bypassed ? -65536 : -11890462;
        context.method_51433(textRenderer, infoChar, textX, textY, textColor, true);
    }

    private void drawPulsingBorder(class_332 context) {
        long time = System.currentTimeMillis();
        float pulse = (float)Math.sin((double)time * 0.006) * 0.3f + 0.4f;
        int alpha = (int)(255.0f * pulse);
        int pulseColor = alpha << 24 | 0x4A90E2;
        int x = this.method_46426();
        int y = this.method_46427();
        int width = this.method_25368();
        int height = this.method_25364();
        context.method_25294(x - 1, y - 1, x + width + 1, y, pulseColor);
        context.method_25294(x - 1, y + height, x + width + 1, y + height + 1, pulseColor);
        context.method_25294(x - 1, y - 1, x, y + height + 1, pulseColor);
        context.method_25294(x + width, y - 1, x + width + 1, y + height + 1, pulseColor);
    }

    public void renderTooltip(class_332 context, int mouseX, int mouseY) {
        int screenHeight;
        int screenWidth;
        String tooltipText;
        if (!(ModConfig.getInstance().showWarningMessage && this.showTooltip && this.field_22764 && this.showIcon)) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_327 textRenderer = client.field_1772;
        if (this.bypassed) {
            tooltipText = class_2561.method_43471((String)"message.no_server_leak_on_stream.streaming_protection_bypassed").getString();
        } else {
            String bypassKey = ModConfig.getInstance().getLocalizedBypassKeyName();
            tooltipText = class_2561.method_43469((String)"message.no_server_leak_on_stream.streaming_protection_active", (Object[])new Object[]{bypassKey}).getString();
        }
        int tooltipWidth = textRenderer.method_1727(tooltipText) + 16;
        Objects.requireNonNull(textRenderer);
        int tooltipHeight = 9 + 12;
        if (client.field_1755 != null) {
            screenWidth = client.field_1755.field_22789;
            screenHeight = client.field_1755.field_22790;
        } else {
            screenWidth = client.method_22683().method_4486();
            screenHeight = client.method_22683().method_4502();
        }
        int tooltipX = mouseX + 12;
        int tooltipY = mouseY - tooltipHeight - 8;
        if (tooltipX + tooltipWidth > screenWidth) {
            tooltipX = mouseX - tooltipWidth - 12;
        }
        if (tooltipX < 0) {
            tooltipX = 4;
        }
        if (tooltipY < 0) {
            tooltipY = mouseY + 12;
        }
        if (tooltipY + tooltipHeight > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        context.method_25294(tooltipX - 3, tooltipY - 4, tooltipX + tooltipWidth + 3, tooltipY + tooltipHeight + 3, -267386864);
        context.method_25294(tooltipX - 2, tooltipY - 3, tooltipX + tooltipWidth + 2, tooltipY + tooltipHeight + 2, -267386864);
        context.method_25294(tooltipX, tooltipY, tooltipX + tooltipWidth, tooltipY + tooltipHeight, -267386864);
        context.method_25303(textRenderer, tooltipText, tooltipX + 8, tooltipY + 6, -1);
    }

    public void method_47399(class_6382 builder) {
        if (this.bypassed) {
            builder.method_37033(class_6381.field_33790, "Streaming Protection - Bypassed");
        } else {
            builder.method_37033(class_6381.field_33790, "Streaming Protection - Active");
        }
    }
}

