/*
 * Decompiled with CFR 0.152.
 */
package me.user3001.gui.widget;

import java.util.function.Consumer;
import me.user3001.config.ModConfig;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;

public class KeyBindingButton
extends class_4185 {
    private boolean listening = false;
    private final Consumer<Integer> onKeySet;
    private int currentKey;
    private final class_2561 normalPrefix;

    public KeyBindingButton(int x, int y, int width, int height, class_2561 normalPrefix, int initialKey, Consumer<Integer> onKeySet) {
        super(x, y, width, height, (class_2561)class_2561.method_43473(), button -> {}, class_4185.field_40754);
        this.normalPrefix = normalPrefix;
        this.currentKey = initialKey;
        this.onKeySet = onKeySet;
        this.updateMessage();
    }

    public void onPress() {
        if (!this.listening) {
            this.startListening();
        }
    }

    public void startListening() {
        this.listening = true;
        this.updateMessage();
    }

    public void stopListening() {
        this.listening = false;
        this.updateMessage();
    }

    public boolean isListening() {
        return this.listening;
    }

    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.listening) {
            return false;
        }
        if (keyCode == 256) {
            this.stopListening();
            return true;
        }
        if (keyCode == -1) {
            return true;
        }
        this.currentKey = keyCode;
        this.onKeySet.accept(keyCode);
        this.stopListening();
        return true;
    }

    private void updateMessage() {
        if (this.listening) {
            this.method_25355((class_2561)class_2561.method_43470((String)"> Press any key... <"));
        } else {
            String keyName = this.getKeyName(this.currentKey);
            this.method_25355((class_2561)this.normalPrefix.method_27661().method_27693(": " + keyName));
        }
    }

    private String getKeyName(int keyCode) {
        return ModConfig.getLocalizedKeyName(keyCode);
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_48579(context, mouseX, mouseY, delta);
        if (this.listening && this.field_22764) {
            long time = System.currentTimeMillis();
            float pulse = (float)Math.sin((double)time * 0.01) * 0.3f + 0.7f;
            int color = (int)(255.0f * pulse) << 24 | 0xFFFF;
            context.method_25294(this.method_46426() - 1, this.method_46427() - 1, this.method_46426() + this.method_25368() + 1, this.method_46427(), color);
            context.method_25294(this.method_46426() - 1, this.method_46427() + this.method_25364(), this.method_46426() + this.method_25368() + 1, this.method_46427() + this.method_25364() + 1, color);
            context.method_25294(this.method_46426() - 1, this.method_46427(), this.method_46426(), this.method_46427() + this.method_25364(), color);
            context.method_25294(this.method_46426() + this.method_25368(), this.method_46427(), this.method_46426() + this.method_25368() + 1, this.method_46427() + this.method_25364(), color);
        }
    }

    public void setCurrentKey(int keyCode) {
        this.currentKey = keyCode;
        this.updateMessage();
    }
}

