/*
 * Decompiled with CFR 0.152.
 */
package me.user3001.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import me.user3001.No_server_leak_on_stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import org.lwjgl.glfw.GLFW;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("no_server_leak_on_stream.json");
    private static ModConfig instance;
    public boolean enableStreamingDetection = true;
    public int bypassKey = 341;
    public boolean showWarningMessage = true;
    public boolean debugMode = false;
    private static final String[] WINDOWS_STREAMING_SOFTWARE;
    private static final String[] MACOS_STREAMING_SOFTWARE;
    public String[] customStreamingSoftware = new String[10];
    public boolean useCustomStreamingSoftware = false;
    private static final Map<Integer, String> KEY_NAMES;
    private static final Map<Integer, String> KEY_TRANSLATION_KEYS;

    public static final Map<Integer, String> getKeyTranslationKeys() {
        return KEY_TRANSLATION_KEYS;
    }

    public static ModConfig getInstance() {
        if (instance == null) {
            instance = ModConfig.load();
        }
        return instance;
    }

    private static ModConfig load() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                String json = Files.readString(CONFIG_PATH);
                return (ModConfig)GSON.fromJson(json, ModConfig.class);
            }
        }
        catch (IOException e) {
            No_server_leak_on_stream.LOGGER.error("Failed to load config: {}", (Object)e.getMessage());
        }
        ModConfig config = new ModConfig();
        config.save();
        return config;
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)this), new OpenOption[0]);
        }
        catch (IOException e) {
            No_server_leak_on_stream.LOGGER.error("Failed to save config: {}", (Object)e.getMessage());
        }
    }

    public String getBypassKeyName() {
        return KEY_NAMES.getOrDefault(this.bypassKey, "Unknown Key");
    }

    public String getLocalizedBypassKeyName() {
        return ModConfig.getLocalizedKeyName(this.bypassKey);
    }

    public static String getLocalizedKeyName(int keyCode) {
        String englishName;
        String translationKey = KEY_TRANSLATION_KEYS.get(keyCode);
        if (translationKey != null) {
            try {
                String localized = class_2561.method_43471((String)translationKey).getString();
                if (localized != null && !localized.equals(translationKey)) {
                    return localized;
                }
            }
            catch (Exception localized) {
                // empty catch block
            }
        }
        if ((englishName = KEY_NAMES.get(keyCode)) != null) {
            return englishName;
        }
        String glfwName = GLFW.glfwGetKeyName((int)keyCode, (int)0);
        if (glfwName != null) {
            return glfwName.toUpperCase();
        }
        return "Key " + keyCode;
    }

    public static Map<Integer, String> getAllAvailableKeys() {
        return new HashMap<Integer, String>(KEY_NAMES);
    }

    public static int[] getAvailableKeyIds() {
        return KEY_NAMES.keySet().stream().mapToInt(Integer::intValue).toArray();
    }

    public String[] getStreamingSoftware() {
        String[] platformSpecificSoftware;
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            platformSpecificSoftware = WINDOWS_STREAMING_SOFTWARE;
        } else if (os.contains("mac")) {
            platformSpecificSoftware = MACOS_STREAMING_SOFTWARE;
        } else {
            return new String[0];
        }
        if (this.useCustomStreamingSoftware) {
            return (String[])Stream.concat(Arrays.stream(platformSpecificSoftware), Arrays.stream(this.customStreamingSoftware).filter(s -> s != null && !s.trim().isEmpty())).toArray(String[]::new);
        }
        return platformSpecificSoftware;
    }

    public String[] getDefaultStreamingSoftware() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return (String[])WINDOWS_STREAMING_SOFTWARE.clone();
        }
        if (os.contains("mac")) {
            return (String[])MACOS_STREAMING_SOFTWARE.clone();
        }
        return new String[0];
    }

    public void setCustomStreamingSoftware(int index, String software) {
        if (index >= 0 && index < this.customStreamingSoftware.length) {
            this.customStreamingSoftware[index] = software;
        }
    }

    public String getCustomStreamingSoftware(int index) {
        if (index >= 0 && index < this.customStreamingSoftware.length) {
            return this.customStreamingSoftware[index] != null ? this.customStreamingSoftware[index] : "";
        }
        return "";
    }

    public int getMaxCustomEntries() {
        return this.customStreamingSoftware.length;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean enabled) {
        this.debugMode = enabled;
        this.save();
    }

    static {
        WINDOWS_STREAMING_SOFTWARE = new String[]{"obs64.exe", "obs32.exe", "obs.exe", "XSplit.Core.exe", "XSplit.Broadcaster.exe", "streamlabs obs.exe", "streamlabs.exe", "bandicam.exe", "bdcam.exe", "action.exe", "mirillis.exe", "wirecast.exe", "xsplit gamecaster.exe", "elgato game capture.exe", "4KCaptureUtility.exe", "Game Capture HD.exe", "manycam.exe", "PRISMLiveStudio.exe"};
        MACOS_STREAMING_SOFTWARE = new String[]{"obs", "OBS Studio", "Streamlabs OBS", "Streamlabs Desktop", "Wirecast", "CamTwist", "ScreenFlow", "Camtasia", "QuickTime Player", "Elgato Game Capture", "ManyCam", "CamTwist Studio"};
        KEY_NAMES = new HashMap<Integer, String>();
        KEY_TRANSLATION_KEYS = new HashMap<Integer, String>();
        KEY_NAMES.put(341, "Left Ctrl");
        KEY_TRANSLATION_KEYS.put(341, "key.no_server_leak_on_stream.left_ctrl");
        KEY_NAMES.put(345, "Right Ctrl");
        KEY_TRANSLATION_KEYS.put(345, "key.no_server_leak_on_stream.right_ctrl");
        KEY_NAMES.put(342, "Left Alt");
        KEY_TRANSLATION_KEYS.put(342, "key.no_server_leak_on_stream.left_alt");
        KEY_NAMES.put(346, "Right Alt");
        KEY_TRANSLATION_KEYS.put(346, "key.no_server_leak_on_stream.right_alt");
        KEY_NAMES.put(340, "Left Shift");
        KEY_TRANSLATION_KEYS.put(340, "key.no_server_leak_on_stream.left_shift");
        KEY_NAMES.put(344, "Right Shift");
        KEY_TRANSLATION_KEYS.put(344, "key.no_server_leak_on_stream.right_shift");
        KEY_NAMES.put(290, "F1");
        KEY_TRANSLATION_KEYS.put(290, "key.keyboard.f1");
        KEY_NAMES.put(291, "F2");
        KEY_TRANSLATION_KEYS.put(291, "key.keyboard.f2");
        KEY_NAMES.put(292, "F3");
        KEY_TRANSLATION_KEYS.put(292, "key.keyboard.f3");
        KEY_NAMES.put(293, "F4");
        KEY_TRANSLATION_KEYS.put(293, "key.keyboard.f4");
        KEY_NAMES.put(294, "F5");
        KEY_TRANSLATION_KEYS.put(294, "key.keyboard.f5");
        KEY_NAMES.put(295, "F6");
        KEY_TRANSLATION_KEYS.put(295, "key.keyboard.f6");
        KEY_NAMES.put(296, "F7");
        KEY_TRANSLATION_KEYS.put(296, "key.keyboard.f7");
        KEY_NAMES.put(297, "F8");
        KEY_TRANSLATION_KEYS.put(297, "key.keyboard.f8");
        KEY_NAMES.put(298, "F9");
        KEY_TRANSLATION_KEYS.put(298, "key.keyboard.f9");
        KEY_NAMES.put(299, "F10");
        KEY_TRANSLATION_KEYS.put(299, "key.keyboard.f10");
        KEY_NAMES.put(300, "F11");
        KEY_TRANSLATION_KEYS.put(300, "key.keyboard.f11");
        KEY_NAMES.put(301, "F12");
        KEY_TRANSLATION_KEYS.put(301, "key.keyboard.f12");
        KEY_NAMES.put(49, "1");
        KEY_TRANSLATION_KEYS.put(49, "key.keyboard.1");
        KEY_NAMES.put(50, "2");
        KEY_TRANSLATION_KEYS.put(50, "key.keyboard.2");
        KEY_NAMES.put(51, "3");
        KEY_TRANSLATION_KEYS.put(51, "key.keyboard.3");
        KEY_NAMES.put(52, "4");
        KEY_TRANSLATION_KEYS.put(52, "key.keyboard.4");
        KEY_NAMES.put(53, "5");
        KEY_TRANSLATION_KEYS.put(53, "key.keyboard.5");
        KEY_NAMES.put(54, "6");
        KEY_TRANSLATION_KEYS.put(54, "key.keyboard.6");
        KEY_NAMES.put(55, "7");
        KEY_TRANSLATION_KEYS.put(55, "key.keyboard.7");
        KEY_NAMES.put(56, "8");
        KEY_TRANSLATION_KEYS.put(56, "key.keyboard.8");
        KEY_NAMES.put(57, "9");
        KEY_TRANSLATION_KEYS.put(57, "key.keyboard.9");
        KEY_NAMES.put(48, "0");
        KEY_TRANSLATION_KEYS.put(48, "key.keyboard.0");
        KEY_NAMES.put(65, "A");
        KEY_TRANSLATION_KEYS.put(65, "key.keyboard.a");
        KEY_NAMES.put(66, "B");
        KEY_TRANSLATION_KEYS.put(66, "key.keyboard.b");
        KEY_NAMES.put(67, "C");
        KEY_TRANSLATION_KEYS.put(67, "key.keyboard.c");
        KEY_NAMES.put(68, "D");
        KEY_TRANSLATION_KEYS.put(68, "key.keyboard.d");
        KEY_NAMES.put(69, "E");
        KEY_TRANSLATION_KEYS.put(69, "key.keyboard.e");
        KEY_NAMES.put(70, "F");
        KEY_TRANSLATION_KEYS.put(70, "key.keyboard.f");
        KEY_NAMES.put(71, "G");
        KEY_TRANSLATION_KEYS.put(71, "key.keyboard.g");
        KEY_NAMES.put(72, "H");
        KEY_TRANSLATION_KEYS.put(72, "key.keyboard.h");
        KEY_NAMES.put(73, "I");
        KEY_TRANSLATION_KEYS.put(73, "key.keyboard.i");
        KEY_NAMES.put(74, "J");
        KEY_TRANSLATION_KEYS.put(74, "key.keyboard.j");
        KEY_NAMES.put(75, "K");
        KEY_TRANSLATION_KEYS.put(75, "key.keyboard.k");
        KEY_NAMES.put(76, "L");
        KEY_TRANSLATION_KEYS.put(76, "key.keyboard.l");
        KEY_NAMES.put(77, "M");
        KEY_TRANSLATION_KEYS.put(77, "key.keyboard.m");
        KEY_NAMES.put(78, "N");
        KEY_TRANSLATION_KEYS.put(78, "key.keyboard.n");
        KEY_NAMES.put(79, "O");
        KEY_TRANSLATION_KEYS.put(79, "key.keyboard.o");
        KEY_NAMES.put(80, "P");
        KEY_TRANSLATION_KEYS.put(80, "key.keyboard.p");
        KEY_NAMES.put(81, "Q");
        KEY_TRANSLATION_KEYS.put(81, "key.keyboard.q");
        KEY_NAMES.put(82, "R");
        KEY_TRANSLATION_KEYS.put(82, "key.keyboard.r");
        KEY_NAMES.put(83, "S");
        KEY_TRANSLATION_KEYS.put(83, "key.keyboard.s");
        KEY_NAMES.put(84, "T");
        KEY_TRANSLATION_KEYS.put(84, "key.keyboard.t");
        KEY_NAMES.put(85, "U");
        KEY_TRANSLATION_KEYS.put(85, "key.keyboard.u");
        KEY_NAMES.put(86, "V");
        KEY_TRANSLATION_KEYS.put(86, "key.keyboard.v");
        KEY_NAMES.put(87, "W");
        KEY_TRANSLATION_KEYS.put(87, "key.keyboard.w");
        KEY_NAMES.put(88, "X");
        KEY_TRANSLATION_KEYS.put(88, "key.keyboard.x");
        KEY_NAMES.put(89, "Y");
        KEY_TRANSLATION_KEYS.put(89, "key.keyboard.y");
        KEY_NAMES.put(90, "Z");
        KEY_TRANSLATION_KEYS.put(90, "key.keyboard.z");
        KEY_NAMES.put(32, "Space");
        KEY_TRANSLATION_KEYS.put(32, "key.no_server_leak_on_stream.space");
        KEY_NAMES.put(257, "Enter");
        KEY_TRANSLATION_KEYS.put(257, "key.no_server_leak_on_stream.enter");
        KEY_NAMES.put(258, "Tab");
        KEY_TRANSLATION_KEYS.put(258, "key.no_server_leak_on_stream.tab");
        KEY_NAMES.put(259, "Backspace");
        KEY_TRANSLATION_KEYS.put(259, "key.no_server_leak_on_stream.backspace");
        KEY_NAMES.put(260, "Insert");
        KEY_TRANSLATION_KEYS.put(260, "key.no_server_leak_on_stream.insert");
        KEY_NAMES.put(261, "Delete");
        KEY_TRANSLATION_KEYS.put(261, "key.no_server_leak_on_stream.delete");
        KEY_NAMES.put(262, "Right Arrow");
        KEY_TRANSLATION_KEYS.put(262, "key.no_server_leak_on_stream.right_arrow");
        KEY_NAMES.put(263, "Left Arrow");
        KEY_TRANSLATION_KEYS.put(263, "key.no_server_leak_on_stream.left_arrow");
        KEY_NAMES.put(264, "Down Arrow");
        KEY_TRANSLATION_KEYS.put(264, "key.no_server_leak_on_stream.down_arrow");
        KEY_NAMES.put(265, "Up Arrow");
        KEY_TRANSLATION_KEYS.put(265, "key.no_server_leak_on_stream.up_arrow");
        KEY_NAMES.put(266, "Page Up");
        KEY_TRANSLATION_KEYS.put(266, "key.no_server_leak_on_stream.page_up");
        KEY_NAMES.put(267, "Page Down");
        KEY_TRANSLATION_KEYS.put(267, "key.no_server_leak_on_stream.page_down");
        KEY_NAMES.put(268, "Home");
        KEY_TRANSLATION_KEYS.put(268, "key.no_server_leak_on_stream.home");
        KEY_NAMES.put(269, "End");
        KEY_TRANSLATION_KEYS.put(269, "key.no_server_leak_on_stream.end");
        KEY_NAMES.put(280, "Caps Lock");
        KEY_TRANSLATION_KEYS.put(280, "key.no_server_leak_on_stream.caps_lock");
        KEY_NAMES.put(281, "Scroll Lock");
        KEY_TRANSLATION_KEYS.put(281, "key.no_server_leak_on_stream.scroll_lock");
        KEY_NAMES.put(282, "Num Lock");
        KEY_TRANSLATION_KEYS.put(282, "key.no_server_leak_on_stream.num_lock");
        KEY_NAMES.put(283, "Print Screen");
        KEY_TRANSLATION_KEYS.put(283, "key.no_server_leak_on_stream.print_screen");
        KEY_NAMES.put(284, "Pause");
        KEY_TRANSLATION_KEYS.put(284, "key.no_server_leak_on_stream.pause");
        KEY_NAMES.put(320, "Numpad 0");
        KEY_TRANSLATION_KEYS.put(320, "key.keyboard.keypad.0");
        KEY_NAMES.put(321, "Numpad 1");
        KEY_TRANSLATION_KEYS.put(321, "key.keyboard.keypad.1");
        KEY_NAMES.put(322, "Numpad 2");
        KEY_TRANSLATION_KEYS.put(322, "key.keyboard.keypad.2");
        KEY_NAMES.put(323, "Numpad 3");
        KEY_TRANSLATION_KEYS.put(323, "key.keyboard.keypad.3");
        KEY_NAMES.put(324, "Numpad 4");
        KEY_TRANSLATION_KEYS.put(324, "key.keyboard.keypad.4");
        KEY_NAMES.put(325, "Numpad 5");
        KEY_TRANSLATION_KEYS.put(325, "key.keyboard.keypad.5");
        KEY_NAMES.put(326, "Numpad 6");
        KEY_TRANSLATION_KEYS.put(326, "key.keyboard.keypad.6");
        KEY_NAMES.put(327, "Numpad 7");
        KEY_TRANSLATION_KEYS.put(327, "key.keyboard.keypad.7");
        KEY_NAMES.put(328, "Numpad 8");
        KEY_TRANSLATION_KEYS.put(328, "key.keyboard.keypad.8");
        KEY_NAMES.put(329, "Numpad 9");
        KEY_TRANSLATION_KEYS.put(329, "key.keyboard.keypad.9");
    }
}

