/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.router.exception;

import io.javalin.http.HttpStatus;
import io.javalin.util.JavalinLogger;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"isClientAbortException", "", "t", "", "isJettyTimeoutException", "isSomewhatExpectedException", "logDebugAndSetError", "", "res", "Ljakarta/servlet/http/HttpServletResponse;", "javalin"})
public final class ExceptionMapperKt {
    private static final boolean isClientAbortException(Throwable t) {
        return Intrinsics.areEqual((Object)t.getClass().getName(), (Object)"org.eclipse.jetty.io.EofException");
    }

    private static final boolean isJettyTimeoutException(Throwable t) {
        return t instanceof IOException && t.getCause() instanceof TimeoutException;
    }

    private static final boolean isSomewhatExpectedException(Throwable t) {
        Throwable unwrapped;
        Throwable throwable = t instanceof CompletionException ? (CompletionException)t : null;
        if (throwable == null || (throwable = throwable.getCause()) == null) {
            throwable = t;
        }
        return ExceptionMapperKt.isClientAbortException(unwrapped = throwable) || ExceptionMapperKt.isJettyTimeoutException(unwrapped);
    }

    private static final void logDebugAndSetError(Throwable t, HttpServletResponse res) {
        JavalinLogger.debug("Client aborted or timed out", t);
        res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.getCode());
    }

    public static final /* synthetic */ boolean access$isSomewhatExpectedException(Throwable t) {
        return ExceptionMapperKt.isSomewhatExpectedException(t);
    }

    public static final /* synthetic */ void access$logDebugAndSetError(Throwable t, HttpServletResponse res) {
        ExceptionMapperKt.logDebugAndSetError(t, res);
    }
}

