/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.jetty;

import io.javalin.http.staticfiles.Location;
import io.javalin.http.staticfiles.StaticFileConfig;
import io.javalin.jetty.ConfigurableHandler;
import io.javalin.util.ConcurrencyUtilKt;
import io.javalin.util.JavalinException;
import io.javalin.util.JavalinLogger;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.EmptyResource;
import org.eclipse.jetty.util.resource.Resource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e\u00b2\u0006\u0012\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\n0\nX\u008a\u0084\u0002"}, d2={"Lio/javalin/jetty/ConfigurableHandler;", "Lorg/eclipse/jetty/server/handler/ResourceHandler;", "config", "Lio/javalin/http/staticfiles/StaticFileConfig;", "jettyServer", "Lorg/eclipse/jetty/server/Server;", "(Lio/javalin/http/staticfiles/StaticFileConfig;Lorg/eclipse/jetty/server/Server;)V", "getConfig", "()Lio/javalin/http/staticfiles/StaticFileConfig;", "getResource", "Lorg/eclipse/jetty/util/resource/Resource;", "path", "", "getResourceBase", "javalin", "aliasResource", "kotlin.jvm.PlatformType"})
@SourceDebugExtension(value={"SMAP\nJettyResourceHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JettyResourceHandler.kt\nio/javalin/jetty/ConfigurableHandler\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,143:1\n215#2,2:144\n*S KotlinDebug\n*F\n+ 1 JettyResourceHandler.kt\nio/javalin/jetty/ConfigurableHandler\n*L\n99#1:144,2\n*E\n"})
public class ConfigurableHandler
extends ResourceHandler {
    @NotNull
    private final StaticFileConfig config;

    public ConfigurableHandler(@NotNull StaticFileConfig config, @NotNull Server jettyServer) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)jettyServer, (String)"jettyServer");
        this.config = config;
        JavalinLogger.info$default("Static file handler added: " + this.config.refinedToString$javalin() + ". File system location: '" + this.getResourceBase(this.config) + "'", null, 2, null);
        this.setResourceBase(this.getResourceBase(this.config));
        this.setDirAllowed(false);
        this.setEtags(true);
        this.setServer(jettyServer);
        this.setMimeTypes(new MimeTypes());
        Map<String, String> $this$forEach$iv = this.config.mimeTypes.getMapping();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String ext = entry.getKey();
            String mimeType = entry.getValue();
            this.getMimeTypes().addMimeMapping(ext, mimeType);
        }
        this.start();
    }

    @NotNull
    public final StaticFileConfig getConfig() {
        return this.config;
    }

    @NotNull
    public Resource getResource(@NotNull String path) {
        Resource resource;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Lazy aliasResource$delegate = ConcurrencyUtilKt.javalinLazy$default(null, (Function0)new Function0<Resource>(this, path){
            final /* synthetic */ ConfigurableHandler this$0;
            final /* synthetic */ String $path;
            {
                this.this$0 = $receiver;
                this.$path = $path;
                super(0);
            }

            public final Resource invoke() {
                Resource resource = this.this$0.getBaseResource();
                Intrinsics.checkNotNull((Object)resource);
                return resource.addPath(URIUtil.canonicalPath((String)this.$path));
            }
        }, 1, null);
        if (Intrinsics.areEqual((Object)this.config.directory, (Object)"META-INF/resources/webjars")) {
            Resource resource2 = Resource.newClassPathResource((String)("META-INF/resources" + path));
            if (resource2 == null) {
                resource2 = EmptyResource.INSTANCE;
            }
            Resource resource3 = resource2;
            Intrinsics.checkNotNull((Object)resource3);
            resource = resource3;
        } else if (this.config.aliasCheck != null && ConfigurableHandler.getResource$lambda$1((Lazy<? extends Resource>)aliasResource$delegate).isAlias()) {
            ContextHandler.AliasCheck aliasCheck = this.config.aliasCheck;
            if (!(aliasCheck != null ? aliasCheck.check(path, ConfigurableHandler.getResource$lambda$1((Lazy<? extends Resource>)aliasResource$delegate)) : false)) {
                throw new AccessDeniedException("Failed alias check");
            }
            Resource resource4 = ConfigurableHandler.getResource$lambda$1((Lazy<? extends Resource>)aliasResource$delegate);
            Intrinsics.checkNotNull((Object)resource4);
            resource = resource4;
        } else if (Intrinsics.areEqual((Object)this.config.hostedPath, (Object)"/")) {
            Resource resource5 = super.getResource(path);
            resource = resource5;
            Intrinsics.checkNotNullExpressionValue((Object)resource5, (String)"getResource(...)");
        } else if (Intrinsics.areEqual((Object)path, (Object)this.config.hostedPath)) {
            Resource resource6 = super.getResource("/");
            resource = resource6;
            Intrinsics.checkNotNullExpressionValue((Object)resource6, (String)"getResource(...)");
        } else if (StringsKt.startsWith$default((String)path, (String)(this.config.hostedPath + "/"), (boolean)false, (int)2, null)) {
            Resource resource7 = super.getResource(StringsKt.removePrefix((String)path, (CharSequence)this.config.hostedPath));
            resource = resource7;
            Intrinsics.checkNotNullExpressionValue((Object)resource7, (String)"getResource(...)");
        } else {
            Resource resource8 = EmptyResource.INSTANCE;
            resource = resource8;
            Intrinsics.checkNotNullExpressionValue((Object)resource8, (String)"INSTANCE");
        }
        return resource;
    }

    private final String getResourceBase(StaticFileConfig config) {
        Function1 noSuchDirMessageBuilder2 = getResourceBase.noSuchDirMessageBuilder.1.INSTANCE;
        String classpathHint = "Depending on your setup, empty folders might not get copied to classpath.";
        if (config.location == Location.CLASSPATH) {
            Object object = Resource.newClassPathResource((String)config.directory);
            if (object == null || (object = object.toString()) == null) {
                throw new JavalinException(noSuchDirMessageBuilder2.invoke((Object)config.directory) + " " + classpathHint);
            }
            return object;
        }
        Path path = Paths.get(config.directory, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path path2 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        Path absoluteDirectoryPath = path2.normalize();
        if (!Files.exists(absoluteDirectoryPath, new LinkOption[0])) {
            throw new JavalinException((String)noSuchDirMessageBuilder2.invoke((Object)((Object)absoluteDirectoryPath).toString()));
        }
        return config.directory;
    }

    private static final Resource getResource$lambda$1(Lazy<? extends Resource> $aliasResource$delegate) {
        Lazy<? extends Resource> lazy = $aliasResource$delegate;
        return (Resource)lazy.getValue();
    }
}

