/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.defaultextensions.validation.api.validators;

import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.defaultextensions.validation.api.ConfigEntryValidator;
import de.siphalor.tweed5.defaultextensions.validation.api.result.ValidationIssue;
import de.siphalor.tweed5.defaultextensions.validation.api.result.ValidationIssueLevel;
import de.siphalor.tweed5.defaultextensions.validation.api.result.ValidationResult;
import java.util.Collections;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public final class NumberRangeValidator<N extends Number>
implements ConfigEntryValidator {
    private final Class<N> numberClass;
    private final @Nullable N minimum;
    private final boolean minimumExclusive;
    private final @Nullable N maximum;
    private final boolean maximumExclusive;
    private final String description;

    public static <N extends Number> Builder<N> builder(Class<N> numberClass) {
        return new Builder(numberClass);
    }

    @Override
    public <T> ValidationResult<T> validate(ConfigEntry<T> configEntry, T value) {
        if (!(value instanceof Number)) {
            return ValidationResult.withIssues(value, Collections.singleton(new ValidationIssue("Value must be numeric, got" + NumberRangeValidator.getClassName(value), ValidationIssueLevel.ERROR)));
        }
        if (value.getClass() != this.numberClass) {
            return ValidationResult.withIssues(value, Collections.singleton(new ValidationIssue("Value is of wrong type, expected " + this.numberClass.getName() + ", got " + NumberRangeValidator.getClassName(value), ValidationIssueLevel.ERROR)));
        }
        Number numberValue = (Number)value;
        if (this.minimum != null) {
            int minCmp = this.compare(numberValue, (Number)this.minimum);
            if (this.minimumExclusive ? minCmp <= 0 : minCmp < 0) {
                return ValidationResult.withIssues(this.minimum, Collections.singleton(new ValidationIssue(this.description + ", got: " + value, ValidationIssueLevel.WARN)));
            }
        }
        if (this.maximum != null) {
            int maxCmp = this.compare(numberValue, (Number)this.maximum);
            if (this.maximumExclusive ? maxCmp >= 0 : maxCmp > 0) {
                return ValidationResult.withIssues(this.maximum, Collections.singleton(new ValidationIssue(this.description + " Got: " + value, ValidationIssueLevel.WARN)));
            }
        }
        return ValidationResult.ok(value);
    }

    private static String getClassName(@Nullable Object value) {
        if (value == null) {
            return "<null>";
        }
        return value.getClass().getName();
    }

    private int compare(Number a, Number b) {
        if (this.numberClass == Byte.class) {
            return Byte.compare(a.byteValue(), b.byteValue());
        }
        if (this.numberClass == Short.class) {
            return Short.compare(a.shortValue(), b.shortValue());
        }
        if (this.numberClass == Integer.class) {
            return Integer.compare(a.intValue(), b.intValue());
        }
        if (this.numberClass == Long.class) {
            return Long.compare(a.longValue(), b.longValue());
        }
        if (this.numberClass == Float.class) {
            return Float.compare(a.floatValue(), b.floatValue());
        }
        return Double.compare(a.doubleValue(), b.doubleValue());
    }

    @Override
    public <T> String description(ConfigEntry<T> configEntry) {
        return this.description;
    }

    @Generated
    public Class<N> numberClass() {
        return this.numberClass;
    }

    @Generated
    public @Nullable N minimum() {
        return this.minimum;
    }

    @Generated
    public boolean minimumExclusive() {
        return this.minimumExclusive;
    }

    @Generated
    public @Nullable N maximum() {
        return this.maximum;
    }

    @Generated
    public boolean maximumExclusive() {
        return this.maximumExclusive;
    }

    @Generated
    public String description() {
        return this.description;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NumberRangeValidator)) {
            return false;
        }
        NumberRangeValidator other = (NumberRangeValidator)o;
        if (this.minimumExclusive() != other.minimumExclusive()) {
            return false;
        }
        if (this.maximumExclusive() != other.maximumExclusive()) {
            return false;
        }
        Class<N> this$numberClass = this.numberClass();
        Class<N> other$numberClass = other.numberClass();
        if (this$numberClass == null ? other$numberClass != null : !this$numberClass.equals(other$numberClass)) {
            return false;
        }
        N this$minimum = this.minimum();
        N other$minimum = other.minimum();
        if (this$minimum == null ? other$minimum != null : !this$minimum.equals(other$minimum)) {
            return false;
        }
        N this$maximum = this.maximum();
        N other$maximum = other.maximum();
        if (this$maximum == null ? other$maximum != null : !this$maximum.equals(other$maximum)) {
            return false;
        }
        String this$description = this.description();
        String other$description = other.description();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.minimumExclusive() ? 79 : 97);
        result = result * 59 + (this.maximumExclusive() ? 79 : 97);
        Class<N> $numberClass = this.numberClass();
        result = result * 59 + ($numberClass == null ? 43 : $numberClass.hashCode());
        N $minimum = this.minimum();
        result = result * 59 + ($minimum == null ? 43 : $minimum.hashCode());
        N $maximum = this.maximum();
        result = result * 59 + ($maximum == null ? 43 : $maximum.hashCode());
        String $description = this.description();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NumberRangeValidator(numberClass=" + this.numberClass() + ", minimum=" + this.minimum() + ", minimumExclusive=" + this.minimumExclusive() + ", maximum=" + this.maximum() + ", maximumExclusive=" + this.maximumExclusive() + ", description=" + this.description() + ")";
    }

    @Generated
    private NumberRangeValidator(Class<N> numberClass, @Nullable N minimum, boolean minimumExclusive, @Nullable N maximum, boolean maximumExclusive, String description) {
        this.numberClass = numberClass;
        this.minimum = minimum;
        this.minimumExclusive = minimumExclusive;
        this.maximum = maximum;
        this.maximumExclusive = maximumExclusive;
        this.description = description;
    }

    /* synthetic */ NumberRangeValidator(Class x0, Number x1, boolean x2, Number x3, boolean x4, String x5, 1 x6) {
        this(x0, x1, x2, x3, x4, x5);
    }

    public static class Builder<N extends Number> {
        private final Class<N> numberClass;
        private @Nullable N minimum;
        private boolean minimumExclusive;
        private @Nullable N maximum;
        private boolean maximumExclusive;

        public Builder<N> greaterThan(N minimum) {
            this.minimumExclusive = true;
            this.minimum = minimum;
            return this;
        }

        public Builder<N> greaterThanOrEqualTo(N minimum) {
            this.minimumExclusive = false;
            this.minimum = minimum;
            return this;
        }

        public Builder<N> lessThan(N maximum) {
            this.maximumExclusive = true;
            this.maximum = maximum;
            return this;
        }

        public Builder<N> lessThanOrEqualTo(N maximum) {
            this.maximumExclusive = false;
            this.maximum = maximum;
            return this;
        }

        public NumberRangeValidator<N> build() {
            return new NumberRangeValidator(this.numberClass, (Number)this.minimum, this.minimumExclusive, (Number)this.maximum, this.maximumExclusive, this.createDescription(), null);
        }

        private String createDescription() {
            if (this.minimum != null) {
                if (this.maximum != null) {
                    if (this.minimumExclusive == this.maximumExclusive) {
                        if (this.minimumExclusive) {
                            return "Must be exclusively between " + this.minimum + " and " + this.maximum + ".";
                        }
                        return "Must be inclusively between " + this.minimum + " and " + this.maximum + ".";
                    }
                    StringBuilder description = new StringBuilder(40);
                    description.append("Must be greater than ");
                    if (!this.minimumExclusive) {
                        description.append("or equal to ");
                    }
                    description.append(this.minimum).append(" and less than ");
                    if (!this.maximumExclusive) {
                        description.append("or equal to ");
                    }
                    description.append(this.maximum).append('.');
                    return description.toString();
                }
                if (this.minimumExclusive) {
                    return "Must be greater than " + this.minimum + ".";
                }
                return "Must be greater than or equal to " + this.minimum + ".";
            }
            if (this.maximum != null) {
                if (this.maximumExclusive) {
                    return "Must be less than " + this.maximum + ".";
                }
                return "Must be less than or equal to " + this.maximum + ".";
            }
            return "";
        }

        @Generated
        private Builder(Class<N> numberClass) {
            this.numberClass = numberClass;
        }
    }
}

