/*
 * Decompiled with CFR 0.152.
 */
package journeymap_webmap.routes;

import io.javalin.http.ContentType;
import io.javalin.http.Context;
import jakarta.servlet.ServletOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.file.Files;
import journeymap.client.JourneymapClient;
import journeymap.client.data.WorldData;
import journeymap.client.io.FileHandler;
import journeymap.client.io.RegionImageHandler;
import journeymap.client.model.map.MapType;
import journeymap.common.helper.DimensionHelper;
import journeymap_webmap.WebMap;
import net.minecraft.class_1011;
import net.minecraft.class_1923;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.eclipse.jetty.io.EofException;

public class Tiles {
    public static void tilesGet(Context ctx) {
        MapType.Name mapTypeName;
        int x = ctx.queryParam("x") != null ? Integer.parseInt(ctx.queryParam("x")) : 0;
        Integer y = ctx.queryParam("y") != null ? Integer.parseInt(ctx.queryParam("y")) : 0;
        int z = ctx.queryParam("z") != null ? Integer.parseInt(ctx.queryParam("z")) : 0;
        String dimension = ctx.queryParam("dimension") != null ? ctx.queryParam("dimension") : "minecraft:overworld";
        String mapTypeString = ctx.queryParam("mapTypeString") != null ? ctx.queryParam("mapTypeString") : MapType.Name.day.name();
        int zoom = ctx.queryParam("zoom") != null ? Integer.parseInt(ctx.queryParam("zoom")) : 0;
        class_310 minecraft = class_310.method_1551();
        class_638 level = minecraft.field_1687;
        if (level == null) {
            WebMap.logger.warn("Tiles requested before world loaded");
            ctx.status(400);
            ctx.result("World not loaded");
            return;
        }
        if (!JourneymapClient.getInstance().isMapping().booleanValue()) {
            WebMap.logger.warn("Tiles requested before JourneyMap started");
            ctx.status(400);
            ctx.result("JourneyMap is still starting");
            return;
        }
        File worldDir = FileHandler.getJMWorldDir((class_310)minecraft);
        try {
            if (!worldDir.exists() || !worldDir.isDirectory()) {
                WebMap.logger.warn("JM world directory not found");
                ctx.status(404);
                ctx.result("World not found");
                return;
            }
        }
        catch (NullPointerException e) {
            WebMap.logger.warn("NPE occurred while locating JM world directory");
            ctx.status(404);
            ctx.result("World not found");
            return;
        }
        try {
            mapTypeName = MapType.Name.valueOf((String)mapTypeString);
        }
        catch (IllegalArgumentException e) {
            WebMap.logger.warn("Invalid map type supplied during tiles request: " + mapTypeString);
            ctx.status(400);
            ctx.result("Invalid map type: " + mapTypeString);
            return;
        }
        if (mapTypeName != MapType.Name.underground) {
            y = null;
        }
        if (mapTypeName == MapType.Name.underground && WorldData.isHardcoreAndMultiplayer()) {
            WebMap.logger.debug("Blank tile returned for underground view on a hardcore server");
            ServletOutputStream output = ctx.outputStream();
            ctx.contentType(ContentType.IMAGE_PNG);
            try {
                output.write(Files.readAllBytes(RegionImageHandler.getBlank512x512ImageFile().toPath()));
                output.flush();
            }
            catch (IOException e) {
                WebMap.logger.error("Error reading blank file from bytes: ", (Throwable)e);
            }
        }
        int scale = (int)Math.pow(2.0, zoom);
        int distance = 32 / scale;
        int minChunkX = x * distance;
        int minChunkY = z * distance;
        int maxChunkX = minChunkX + distance - 1;
        int maxChunkY = minChunkY + distance - 1;
        class_1923 startCoord = new class_1923(minChunkX, minChunkY);
        class_1923 endCoord = new class_1923(maxChunkX, maxChunkY);
        boolean showGrid = JourneymapClient.getInstance().getFullMapProperties().showGrid.get();
        MapType mapType = new MapType(mapTypeName, y, DimensionHelper.getWorldKeyForName((String)dimension));
        class_1011 img = RegionImageHandler.getMergedChunks((File)worldDir, (class_1923)startCoord, (class_1923)endCoord, (MapType)mapType, (Boolean)true, null, (Integer)512, (Integer)512, (boolean)false, (boolean)showGrid);
        ServletOutputStream output = ctx.outputStream();
        try {
            ctx.contentType(ContentType.IMAGE_PNG);
            img.method_24032(Channels.newChannel((OutputStream)output));
            output.flush();
        }
        catch (EofException e) {
            WebMap.logger.info("Connection closed while writing image response. WebMap probably reloaded.");
            ctx.status(404);
        }
        catch (IOException e) {
            WebMap.logger.info("Connection closed while writing image response. WebMap probably reloaded.");
            ctx.status(404);
        }
        img.close();
    }
}

