/*
 * Decompiled with CFR 0.152.
 */
package journeymap_webmap.routes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.javalin.http.ContentType;
import io.javalin.http.Context;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import journeymap.api.client.impl.ClientAPI;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.api.v2.client.model.MapPolygon;
import journeymap.api.v2.client.util.UIState;
import journeymap.client.cartography.color.RGB;
import journeymap.client.render.draw.DrawPolygonStep;
import journeymap.client.render.draw.OverlayDrawStep;
import net.minecraft.class_2338;

public class Polygons {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void polygonsGet(Context ctx) {
        Type dataType = new TypeToken<List<Map<String, String>>>(){}.getType();
        final Type pointsType = new TypeToken<List<Map<String, Integer>>>(){}.getType();
        final Type holesType = new TypeToken<List<List<Map<String, Integer>>>>(){}.getType();
        ArrayList<6> data = new ArrayList<6>();
        ArrayList steps = new ArrayList();
        UIState fullscreenState = ClientAPI.INSTANCE.getUIState(Context.UI.Fullscreen);
        UIState minimapState = ClientAPI.INSTANCE.getUIState(Context.UI.Minimap);
        UIState uiState = fullscreenState != null && !fullscreenState.active && minimapState != null && minimapState.active ? minimapState : fullscreenState;
        ClientAPI.INSTANCE.getDrawSteps(steps, uiState);
        for (OverlayDrawStep overlayDrawStep : steps) {
            if (!(overlayDrawStep instanceof DrawPolygonStep)) continue;
            final DrawPolygonStep step = (DrawPolygonStep)overlayDrawStep;
            final PolygonOverlay polygon = (PolygonOverlay)step.getOverlay();
            final ArrayList<4> points = new ArrayList<4>();
            final String label = polygon.getLabel();
            final int fontColor = polygon.getTextProperties() != null ? polygon.getTextProperties().getColor() : 0;
            for (final class_2338 point : polygon.getOuterArea().getPoints()) {
                points.add(new HashMap<String, Integer>(){
                    {
                        this.put("x", point.method_10263());
                        this.put("y", point.method_10264());
                        this.put("z", point.method_10260());
                    }
                });
            }
            final ArrayList holes = new ArrayList();
            if (polygon.getHoles() != null) {
                for (MapPolygon hole : polygon.getHoles()) {
                    ArrayList<5> holePoints = new ArrayList<5>();
                    for (final class_2338 holePoint : hole.getPoints()) {
                        holePoints.add(new HashMap<String, Integer>(){
                            {
                                this.put("x", holePoint.method_10263());
                                this.put("y", holePoint.method_10264());
                                this.put("z", holePoint.method_10260());
                            }
                        });
                    }
                    holes.add(holePoints);
                }
            }
            data.add(new HashMap<String, Object>(){
                {
                    this.put("fillColor", RGB.toHexString((Integer)polygon.getShapeProperties().getFillColor()));
                    this.put("fillOpacity", Float.valueOf(polygon.getShapeProperties().getFillOpacity()));
                    this.put("strokeColor", RGB.toHexString((Integer)polygon.getShapeProperties().getStrokeColor()));
                    this.put("strokeOpacity", Float.valueOf(polygon.getShapeProperties().getStrokeOpacity()));
                    this.put("strokeWidth", Float.valueOf(polygon.getShapeProperties().getStrokeWidth()));
                    this.put("imageLocation", step.getTextureResource() != null ? step.getTextureResource().toString() : "");
                    this.put("texturePositionX", polygon.getShapeProperties().getTexturePositionX());
                    this.put("texturePositionY", polygon.getShapeProperties().getTexturePositionY());
                    this.put("textureScaleX", polygon.getShapeProperties().getTextureScaleX());
                    this.put("textureScaleY", polygon.getShapeProperties().getTextureScaleY());
                    this.put("fontColor", RGB.toHexString((Integer)fontColor));
                    this.put("label", label);
                    this.put("holes", GSON.toJsonTree((Object)holes, holesType).getAsJsonArray());
                    this.put("points", GSON.toJsonTree((Object)points, pointsType).getAsJsonArray());
                }
            });
        }
        ctx.contentType(ContentType.APPLICATION_JSON);
        ctx.result(GSON.toJsonTree(data, dataType).getAsJsonArray().toString());
    }
}

