/*
 * Decompiled with CFR 0.152.
 */
package journeymap_webmap.routes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.javalin.http.ContentType;
import io.javalin.http.Context;
import java.io.File;
import java.util.HashMap;
import journeymap.client.JourneymapClient;
import journeymap.client.io.FileHandler;
import journeymap.client.io.MapSaver;
import journeymap.client.model.map.MapType;
import journeymap.client.task.multi.MapRegionTask;
import journeymap.client.task.multi.SaveMapTask;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import org.apache.logging.log4j.Logger;

public class Action {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger logger = Journeymap.getLogger((String)"webmap/routes/action");

    public void actionGet(Context ctx) {
        String type;
        class_310 minecraft = class_310.method_1551();
        class_638 level = minecraft.field_1687;
        if (level == null) {
            logger.warn("Action requested before world loaded");
            ctx.status(400);
            ctx.result("World not loaded");
            return;
        }
        if (!JourneymapClient.getInstance().isMapping().booleanValue()) {
            logger.warn("Action requested before Journeymap started");
            ctx.status(400);
            ctx.result("JourneyMap is still starting");
            return;
        }
        switch (type = ctx.pathParam("type")) {
            case "automap": {
                this.autoMap(ctx, minecraft, (class_1937)level);
                break;
            }
            case "savemap": {
                this.saveMap(ctx, minecraft, (class_1937)level);
                break;
            }
            default: {
                logger.warn("Unknown action type '" + type + "'");
                ctx.status(400);
                ctx.result("Unknown action type '" + type + "'");
                return;
            }
        }
    }

    public void saveMap(Context ctx, class_310 minecraft, class_1937 level) {
        MapType.Name mapTypeName;
        File worldDir = FileHandler.getJMWorldDir((class_310)minecraft);
        if (!worldDir.exists() || !worldDir.isDirectory()) {
            logger.warn("JM world directory not found");
            ctx.status(500);
            ctx.result("Unable to find JourneyMap world directory");
            return;
        }
        String dimension = ctx.queryParam("dim") == null ? "minecraft:overworld" : ctx.queryParam("dim");
        String mapTypeString = ctx.queryParam("mapType") == null ? MapType.Name.day.name() : ctx.queryParam("mapType");
        Integer vSlice = (Integer)ctx.queryParamAsClass("depth", Integer.class).getOrDefault((Object)0);
        try {
            mapTypeName = MapType.Name.valueOf((String)mapTypeString);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Invalid map type '{}'", (Object)mapTypeString);
            ctx.status(400);
            ctx.result("Invalid map type '" + mapTypeString + "'");
            return;
        }
        if (mapTypeName != MapType.Name.underground) {
            vSlice = null;
        }
        boolean hardcore = level.method_8401().method_152();
        MapType mapType = MapType.from((MapType.Name)mapTypeName, (Integer)vSlice, (class_5321)DimensionHelper.getWorldKeyForName((String)dimension));
        if (mapType.isUnderground() && hardcore) {
            logger.warn("Cave mapping is not allowed on hardcore servers");
            ctx.status(400);
            ctx.result("Cave mapping is not allowed on hardcore servers");
            return;
        }
        MapSaver mapSaver = new MapSaver(worldDir, mapType);
        if (!mapSaver.isValid()) {
            logger.info("No image files to save");
            ctx.status(400);
            ctx.result("No image files to save");
            return;
        }
        JourneymapClient.getInstance().toggleTask(SaveMapTask.Manager.class, true, (Object)mapSaver);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("filename", mapSaver.getSaveFileName());
        ctx.contentType(ContentType.APPLICATION_JSON);
        ctx.result(GSON.toJson(data));
    }

    public void autoMap(Context ctx, class_310 minecraft, class_1937 level) {
        String scope;
        HashMap<String, String> data = new HashMap<String, String>();
        boolean enabled = JourneymapClient.getInstance().isTaskManagerEnabled(MapRegionTask.Manager.class);
        String string = scope = ctx.queryParam("scope") != null ? ctx.queryParam("scope") : "stop";
        if (scope.equals("stop") && enabled) {
            JourneymapClient.getInstance().toggleTask(MapRegionTask.Manager.class, false, (Object)false);
            data.put("message", "automap_complete");
        } else if (!enabled) {
            boolean doAll = scope.equals("all");
            JourneymapClient.getInstance().toggleTask(MapRegionTask.Manager.class, true, (Object)doAll);
            data.put("message", "automap_started");
        } else {
            data.put("message", "automap_already_started");
        }
        ctx.contentType(ContentType.APPLICATION_JSON);
        ctx.result(GSON.toJson(data));
    }
}

