/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.errornotifier.launch.render;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import me.shedaniel.errornotifier.launch.EarlyShader;
import me.shedaniel.errornotifier.launch.render.EarlyDrawType;
import me.shedaniel.errornotifier.launch.render.EarlyRenderFormat;
import me.shedaniel.errornotifier.launch.render.EarlyRenderingStates;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.MemoryUtil;

public class EarlyBufferBuilder {
    private final String shader;
    private final EarlyRenderFormat format;
    private final ByteBuffer buffer;

    public EarlyBufferBuilder(String shader, EarlyRenderFormat format) {
        this.shader = shader;
        this.format = format;
        this.buffer = MemoryUtil.memAlloc((int)(64 * format.stride));
    }

    public EarlyBufferBuilder put(byte v) {
        this.buffer.put(v);
        return this;
    }

    public EarlyBufferBuilder put(int v) {
        this.buffer.putInt(v);
        return this;
    }

    public EarlyBufferBuilder put(long v) {
        this.buffer.putLong(v);
        return this;
    }

    public EarlyBufferBuilder put(float v) {
        this.buffer.putFloat(v);
        return this;
    }

    public EarlyBufferBuilder put(double v) {
        this.buffer.putDouble(v);
        return this;
    }

    public EarlyBufferBuilder pos(float x, float y, float z) {
        this.put(x);
        this.put(y);
        this.put(z);
        return this;
    }

    public EarlyBufferBuilder color(float r, float g, float b, float a) {
        this.put(r);
        this.put(g);
        this.put(b);
        this.put(a);
        return this;
    }

    public EarlyBufferBuilder tex(float u, float v) {
        this.put(u);
        this.put(v);
        return this;
    }

    public EarlyBufferBuilder endVertex() {
        int position = this.buffer.position();
        if (position % this.format.stride != 0) {
            throw new IllegalStateException("Buffer position is not a multiple of stride");
        }
        return this;
    }

    public void end(EarlyDrawType drawType) {
        EarlyShader.useShader(this.shader);
        FloatBuffer floatBuffer = MemoryUtil.memAllocFloat((int)16);
        EarlyRenderingStates.modelViewMatrix.store(floatBuffer);
        GL30.glUniformMatrix4fv((int)EarlyShader.getUniform(this.shader, "ModelView"), (boolean)false, (FloatBuffer)floatBuffer);
        MemoryUtil.memFree((Buffer)floatBuffer);
        floatBuffer = MemoryUtil.memAllocFloat((int)16);
        EarlyRenderingStates.projectionMatrix.store(floatBuffer);
        GL30.glUniformMatrix4fv((int)EarlyShader.getUniform(this.shader, "ProjectionView"), (boolean)false, (FloatBuffer)floatBuffer);
        MemoryUtil.memFree((Buffer)floatBuffer);
        int VAO = GL30.glGenVertexArrays();
        int VBO = GL15.glGenBuffers();
        int EBO = GL15.glGenBuffers();
        int position = this.buffer.position();
        byte count = (byte)(position / this.format.stride);
        GL30.glBindVertexArray((int)VAO);
        this.buffer.position(0);
        this.buffer.limit(position);
        GL15.glBindBuffer((int)34962, (int)VBO);
        GL15.glBufferData((int)34962, (ByteBuffer)this.buffer, (int)35048);
        GL15.glBindBuffer((int)34963, (int)EBO);
        GL15.glBufferData((int)34963, (ByteBuffer)drawType.getIndices(), (int)35048);
        this.format.setupAttrs();
        GL30.glDrawElements((int)drawType.getGlMode(), (int)(count / drawType.getVertexes() * drawType.getLength()), (int)5121, (long)0L);
        this.format.cleanAttrs();
        GL15.glBindBuffer((int)34962, (int)0);
        GL15.glBindBuffer((int)34963, (int)0);
        GL30.glBindVertexArray((int)0);
        GL30.glDeleteVertexArrays((int)VAO);
        GL15.glDeleteBuffers((int)VBO);
        GL15.glDeleteBuffers((int)EBO);
        MemoryUtil.memFree((Buffer)this.buffer);
    }
}

