/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.errornotifier;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;

public class SwingOpener {
    public static void main(String[] args) throws IOException {
        Object message;
        DataInputStream stream = new DataInputStream(System.in);
        String title = stream.readUTF();
        int size = stream.readInt();
        ArrayList<Map.Entry<String, String>> errors = new ArrayList<Map.Entry<String, String>>();
        for (int i = 0; i < size; ++i) {
            message = stream.readUTF();
            String url = stream.readUTF();
            errors.add(Map.entry(message, url.isEmpty() ? null : url));
        }
        System.setProperty("apple.awt.application.appearance", "system");
        System.setProperty("apple.awt.application.name", title);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        JFrame frame = new JFrame(title);
        frame.setDefaultCloseOperation(3);
        frame.setMinimumSize(new Dimension(600, 400));
        frame.setSize(800, 600);
        frame.setLocationByPlatform(true);
        message = "";
        for (Map.Entry entry : errors) {
            message = (String)message + (String)entry.getKey() + "<br>";
            if (entry.getValue() == null) continue;
            message = (String)message + "<a href=\"" + (String)entry.getValue() + "\">" + (String)entry.getValue() + "</a><br>";
        }
        JLabel label = new JLabel();
        Font font = label.getFont();
        Color bgColor = label.getBackground();
        String editorPaneStyle = String.format(Locale.ENGLISH, "font-family:%s;font-weight:%s;font-size:%dpt;background-color: rgb(%d,%d,%d);", font.getFamily(), "normal", font.getSize() * 3 / 2, bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue());
        JEditorPane area = new JEditorPane("text/html", "<html><body style=\"" + editorPaneStyle + "\">" + (String)message + "</body></html>");
        area.setEditable(false);
        area.setBackground(bgColor);
        area.addHyperlinkListener(e -> {
            block3: {
                try {
                    if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) break block3;
                    if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                        break block3;
                    }
                    throw new UnsupportedOperationException("Failed to open " + e.getURL().toString());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(area);
        JLabel errorsLabel = new JLabel("Startup Errors!");
        errorsLabel.setFont(errorsLabel.getFont().deriveFont((float)errorsLabel.getFont().getSize() * 2.0f).deriveFont(0));
        errorsLabel.setHorizontalAlignment(0);
        errorsLabel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JPanel anotherPanel = new JPanel(new BorderLayout());
        anotherPanel.add((Component)scrollPane, "Center");
        anotherPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        frame.add((Component)errorsLabel, "North");
        frame.add((Component)anotherPanel, "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JButton close = new JButton("Close");
        close.addActionListener(e -> {
            frame.dispose();
            System.exit(0);
        });
        bottomPanel.add((Component)close, "East");
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        frame.add((Component)bottomPanel, "South");
        frame.setVisible(true);
    }
}

