/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie.client.inventory;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import de.siphalor.mousewheelie.MWConfig;
import de.siphalor.mousewheelie.MouseWheelie;
import de.siphalor.mousewheelie.client.MWClient;
import de.siphalor.mousewheelie.client.inventory.CreativeInventoryContainerScreenHelper;
import de.siphalor.mousewheelie.client.inventory.ItemKind;
import de.siphalor.mousewheelie.client.inventory.PlayerInventoryFocusedContainerScreenHelper;
import de.siphalor.mousewheelie.client.inventory.SlotInteractionState;
import de.siphalor.mousewheelie.client.network.ClickEventFactory;
import de.siphalor.mousewheelie.client.network.InteractionManager;
import de.siphalor.mousewheelie.client.util.ItemStackUtils;
import de.siphalor.mousewheelie.client.util.ReverseIterator;
import de.siphalor.mousewheelie.client.util.inject.ISlot;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_490;

@Environment(value=EnvType.CLIENT)
public class ContainerScreenHelper<T extends class_465<?>> {
    protected final T screen;
    protected final boolean hasOtherInventory;
    protected final ClickEventFactory clickEventFactory;
    protected final ReadWriteLock slotStatesLock = new ReentrantReadWriteLock();
    protected final Int2ObjectMap<SlotInteractionState> slotStates;
    public static final int INVALID_SCOPE = Integer.MAX_VALUE;

    protected ContainerScreenHelper(T screen, ClickEventFactory clickEventFactory) {
        this.screen = screen;
        this.hasOtherInventory = this.determineHasOtherInventory();
        this.clickEventFactory = clickEventFactory;
        this.slotStates = new Int2ObjectArrayMap(10);
    }

    public static <T extends class_465<?>> ContainerScreenHelper<T> of(T screen, ClickEventFactory clickEventFactory) {
        if (screen instanceof class_481) {
            return new CreativeInventoryContainerScreenHelper<class_481>((class_481)screen, clickEventFactory);
        }
        if (screen instanceof class_490) {
            return new PlayerInventoryFocusedContainerScreenHelper<T>(screen, clickEventFactory);
        }
        return new ContainerScreenHelper<T>(screen, clickEventFactory);
    }

    private boolean determineHasOtherInventory() {
        for (class_1735 slot : this.screen.method_17577().field_7761) {
            if (slot.field_7871 instanceof class_1661) continue;
            return true;
        }
        return false;
    }

    public InteractionManager.InteractionEvent createClickEvent(class_1735 slot, int action, class_1713 actionType) {
        if (this.getSlotState(slot).areInteractionsLocked()) {
            return null;
        }
        return this.clickEventFactory.create(slot, action, actionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlotInteractionState getSlotState(class_1735 slot) {
        Lock readLock = this.slotStatesLock.readLock();
        readLock.lock();
        try {
            SlotInteractionState state = (SlotInteractionState)((Object)this.slotStates.get(((ISlot)slot).mouseWheelie_getIdInContainer()));
            if (state == null) {
                SlotInteractionState slotInteractionState = SlotInteractionState.NORMAL;
                return slotInteractionState;
            }
            SlotInteractionState slotInteractionState = state;
            return slotInteractionState;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSlotState(class_1735 slot, SlotInteractionState state) {
        Lock writeLock = this.slotStatesLock.writeLock();
        writeLock.lock();
        try {
            int slotId = ((ISlot)slot).mouseWheelie_getIdInContainer();
            if (state == SlotInteractionState.NORMAL) {
                this.slotStates.remove(slotId);
            } else {
                this.slotStates.put(slotId, (Object)state);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public void unlockSlot(class_1735 slot) {
        this.setSlotState(slot, SlotInteractionState.NORMAL);
    }

    private InteractionManager.InteractionEvent lockBefore(InteractionManager.InteractionEvent event, class_1735 slot, SlotInteractionState slotState) {
        if (event == null) {
            return null;
        }
        return new InteractionManager.CallbackEvent(() -> {
            this.setSlotState(slot, slotState);
            return event.send();
        }, event.shouldRunOnMainThread());
    }

    private InteractionManager.InteractionEvent unlockAfter(InteractionManager.InteractionEvent event, class_1735 slot) {
        if (event == null) {
            return null;
        }
        return new InteractionManager.CallbackEvent(() -> {
            InteractionManager.Waiter waiter = event.send();
            this.unlockSlot(slot);
            return waiter;
        }, event.shouldRunOnMainThread());
    }

    public void scroll(class_1735 referenceSlot, boolean scrollUp) {
        boolean shallSend;
        if (MouseWheelie.config.scrolling.directionalScrolling) {
            shallSend = this.shallSendFromSlot(referenceSlot, scrollUp);
        } else {
            shallSend = !scrollUp;
            scrollUp = false;
        }
        if (shallSend) {
            this.scrollSend(referenceSlot);
        } else {
            this.scrollReceive(referenceSlot, scrollUp);
        }
    }

    public boolean shallSendFromSlot(class_1735 slot, boolean scrollUp) {
        return this.isInLowerRegion(this.getScope(slot)) == scrollUp;
    }

    private void scrollSend(class_1735 referenceSlot) {
        if (MWClient.DEPOSIT_MODIFIER.method_1434()) {
            this.depositAllFrom(referenceSlot);
            return;
        }
        if (MWClient.RESTOCK_MODIFIER.method_1434()) {
            this.restockAll(this.getComplementaryScope(this.getScope(referenceSlot)));
            return;
        }
        if (!referenceSlot.method_7680(class_1799.field_8037)) {
            this.sendStack(referenceSlot);
        }
        if (MWClient.ALL_OF_KIND_MODIFIER.method_1434()) {
            this.sendAllOfAKind(referenceSlot);
        } else if (MWClient.WHOLE_STACK_MODIFIER.method_1434()) {
            this.sendStack(referenceSlot);
        } else {
            this.sendSingleItem(referenceSlot);
        }
    }

    private void scrollReceive(class_1735 referenceSlot, boolean scrollUp) {
        if (MWClient.RESTOCK_MODIFIER.method_1434()) {
            if (MWClient.WHOLE_STACK_MODIFIER.method_1434()) {
                this.restockAll(referenceSlot);
            } else {
                this.restockAllOfAKind(referenceSlot);
            }
            return;
        }
        if (MWClient.DEPOSIT_MODIFIER.method_1434()) {
            this.depositAllFrom(this.getComplementaryScope(this.getScope(referenceSlot)));
            return;
        }
        class_1799 referenceStack = referenceSlot.method_7677().method_7972();
        int referenceScope = this.getScope(referenceSlot);
        boolean wholeStackModifier = MWClient.WHOLE_STACK_MODIFIER.method_1434();
        boolean allOfKindModifier = MWClient.ALL_OF_KIND_MODIFIER.method_1434();
        if (wholeStackModifier || allOfKindModifier) {
            for (class_1735 slot : this.screen.method_17577().field_7761) {
                if (this.getScope(slot) == referenceScope || !ItemStackUtils.areItemsOfSameKind(slot.method_7677(), referenceStack)) continue;
                this.sendStack(slot);
                if (allOfKindModifier) continue;
                break;
            }
        } else {
            class_1735 moveSlot = null;
            int stackSize = Integer.MAX_VALUE;
            for (class_1735 slot : this.screen.method_17577().field_7761) {
                int slotScope = this.getScope(slot);
                if (slotScope == referenceScope || this.isInLowerRegion(slotScope) != scrollUp || !ItemStackUtils.areItemsOfSameKind(slot.method_7677(), referenceStack) || slot.method_7677().method_7947() >= stackSize) continue;
                stackSize = slot.method_7677().method_7947();
                moveSlot = slot;
                if (stackSize != 1) continue;
                break;
            }
            if (moveSlot != null) {
                this.sendSingleItem(moveSlot);
            }
        }
    }

    private boolean isInLowerRegion(int scope) {
        return scope <= 0;
    }

    public boolean isHotbarSlot(class_1735 slot) {
        return ((ISlot)slot).mouseWheelie_getIndexInInv() < 9;
    }

    public int getScope(class_1735 slot) {
        return this.getScope(slot, false);
    }

    public int getScope(class_1735 slot, boolean preferSmallerScopes) {
        if (slot.field_7871 == null || ((ISlot)slot).mouseWheelie_getIndexInInv() >= slot.field_7871.method_5439() || !slot.method_7680(class_1799.field_8037)) {
            return Integer.MAX_VALUE;
        }
        if (slot.field_7871 instanceof class_1661) {
            if (this.isHotbarSlot(slot) && (MouseWheelie.config.general.hotbarScoping == MWConfig.General.HotbarScoping.HARD || MouseWheelie.config.general.hotbarScoping == MWConfig.General.HotbarScoping.SOFT && preferSmallerScopes)) {
                return -1;
            }
            return 0;
        }
        return 1;
    }

    public void runInScope(int scope, Consumer<class_1735> slotConsumer) {
        this.runInScope(scope, false, slotConsumer);
    }

    public void runInScope(int scope, boolean preferSmallerScopes, Consumer<class_1735> slotConsumer) {
        for (class_1735 slot : this.screen.method_17577().field_7761) {
            if (this.getScope(slot, preferSmallerScopes) != scope) continue;
            slotConsumer.accept(slot);
        }
    }

    public int getComplementaryScope(int scope) {
        if (scope <= 0) {
            return 1;
        }
        return 0;
    }

    public void sendSingleItem(class_1735 slot) {
        SlotInteractionState slotState = this.getSlotState(slot);
        if (slotState.areInteractionsLocked()) {
            return;
        }
        if (slotState.isAmountStable() && slot.method_7677().method_7947() == 1) {
            InteractionManager.push(this.clickEventFactory.create(slot, 0, class_1713.field_7794));
            return;
        }
        InteractionManager.push(this.lockBefore(this.clickEventFactory.create(slot, 0, class_1713.field_7790), slot, SlotInteractionState.UNSTABLE_AMOUNT));
        InteractionManager.push(this.clickEventFactory.create(slot, 1, class_1713.field_7790));
        InteractionManager.push(this.clickEventFactory.create(slot, 0, class_1713.field_7794));
        InteractionManager.push(this.unlockAfter(this.clickEventFactory.create(slot, 0, class_1713.field_7790), slot));
    }

    public void sendStack(class_1735 slot) {
        InteractionManager.push(this.createClickEvent(slot, 0, class_1713.field_7794));
    }

    public void sendStackLocked(class_1735 slot) {
        if (this.getSlotState(slot).areInteractionsLocked()) {
            return;
        }
        this.setSlotState(slot, SlotInteractionState.TEMP_LOCKED);
        InteractionManager.push(this.unlockAfter(this.clickEventFactory.create(slot, 0, class_1713.field_7794), slot));
    }

    public void sendAllOfAKind(class_1735 referenceSlot) {
        class_1799 stack = referenceSlot.method_7677();
        if (stack.method_7960()) {
            return;
        }
        class_1799 referenceStack = stack.method_7972();
        this.runInScope(this.getScope(referenceSlot), slot -> {
            if (ItemStackUtils.areItemsOfSameKind(slot.method_7677(), referenceStack)) {
                this.sendStack((class_1735)slot);
            }
        });
    }

    public void sendAllFrom(class_1735 referenceSlot) {
        this.runInScope(this.getScope(referenceSlot, true), true, this::sendStack);
    }

    public void depositAllFrom(class_1735 referenceSlot) {
        this.depositAllFrom(this.getScope(referenceSlot, false));
    }

    public void depositAllFrom(int scope) {
        int complementaryScope = this.getComplementaryScope(scope);
        HashSet itemKinds = new HashSet();
        this.runInScope(complementaryScope, slot -> {
            if (slot.method_7681()) {
                itemKinds.add(ItemKind.of(slot.method_7677()));
            }
        });
        this.runInScope(scope, slot -> {
            if (slot.method_7681() && itemKinds.contains(ItemKind.of(slot.method_7677()))) {
                this.sendStackLocked((class_1735)slot);
            }
        });
    }

    public void restockAllOfAKind(class_1735 referenceSlot) {
        class_1799 referenceStack = referenceSlot.method_7677();
        if (referenceStack.method_7960()) {
            return;
        }
        int scope = this.getScope(referenceSlot, true);
        int complementaryScope = this.getComplementaryScope(scope);
        this.restockAllOfAKind(this.screen.method_17577().field_7761.stream().filter(slot -> this.getScope((class_1735)slot, true) == scope && ItemStackUtils.areItemsOfSameKind(slot.method_7677(), referenceStack)).iterator(), complementaryScope);
    }

    private void restockAllOfAKind(Iterator<class_1735> targetSlots, int complementaryScope) {
        ReverseIterator takeSlots = ReverseIterator.of(this.screen.method_17577().field_7761);
        class_1735 currentTakeSlot = null;
        int currentTakeCount = 0;
        while (targetSlots.hasNext()) {
            class_1735 targetSlot = targetSlots.next();
            class_1799 targetStack = targetSlot.method_7677();
            int space = targetStack.method_7914() - targetStack.method_7947();
            while (space > 0) {
                if (currentTakeCount == 0) {
                    class_1799 currentTakeStack;
                    do {
                        if (takeSlots.hasNext()) continue;
                        return;
                    } while (this.getScope(currentTakeSlot = (class_1735)takeSlots.next(), false) != complementaryScope || (currentTakeCount = (currentTakeStack = currentTakeSlot.method_7677()).method_7947()) <= 0 || !ItemStackUtils.areItemsOfSameKind(currentTakeStack, targetStack));
                    InteractionManager.push(this.clickEventFactory.create(currentTakeSlot, 0, class_1713.field_7790));
                }
                InteractionManager.push(this.clickEventFactory.create(targetSlot, 0, class_1713.field_7790));
                if ((space -= currentTakeCount) <= 0) {
                    currentTakeCount = -space;
                    continue;
                }
                currentTakeCount = 0;
            }
        }
        if (currentTakeCount > 0) {
            InteractionManager.push(this.clickEventFactory.create(currentTakeSlot, 0, class_1713.field_7790));
        }
    }

    public void restockAll(class_1735 referenceSlot) {
        this.restockAll(this.getScope(referenceSlot, false));
    }

    public void restockAll(int scope) {
        ArrayListMultimap slotsByItemKind = ArrayListMultimap.create();
        this.runInScope(scope, arg_0 -> ContainerScreenHelper.lambda$restockAll$0((ListMultimap)slotsByItemKind, arg_0));
        int complementaryScope = this.getComplementaryScope(scope);
        slotsByItemKind.asMap().forEach((itemKind, slots) -> this.restockAllOfAKind(slots.iterator(), complementaryScope));
    }

    public void dropStack(class_1735 slot) {
        if (this.getSlotState(slot).areInteractionsLocked()) {
            return;
        }
        InteractionManager.push(this.createClickEvent(slot, 1, class_1713.field_7795));
    }

    public void dropStackLocked(class_1735 slot) {
        if (this.getSlotState(slot).areInteractionsLocked()) {
            return;
        }
        this.setSlotState(slot, SlotInteractionState.TEMP_LOCKED);
        InteractionManager.push(this.unlockAfter(this.clickEventFactory.create(slot, 1, class_1713.field_7795), slot));
    }

    public void dropAllOfAKind(class_1735 referenceSlot) {
        class_1799 stack = referenceSlot.method_7677();
        if (stack.method_7960()) {
            return;
        }
        class_1799 referenceStack = stack.method_7972();
        this.runInScope(this.getScope(referenceSlot), slot -> {
            if (ItemStackUtils.areItemsOfSameKind(slot.method_7677(), referenceStack)) {
                this.dropStack((class_1735)slot);
            }
        });
    }

    public void dropAllFrom(class_1735 referenceSlot) {
        this.runInScope(this.getScope(referenceSlot, true), true, this::dropStack);
    }

    private static /* synthetic */ void lambda$restockAll$0(ListMultimap slotsByItemKind, class_1735 slot) {
        class_1799 stack = slot.method_7677();
        int count = stack.method_7947();
        if (count > 0 && count < stack.method_7914()) {
            slotsByItemKind.put((Object)ItemKind.of(stack), (Object)slot);
        }
    }
}

