/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Objects;
import journeymap.api.v2.client.model.ShapeProperties;
import journeymap.client.cartography.color.RGB;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.Pipelines;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.theme.Theme;
import journeymap.common.Journeymap;
import journeymap.common.mixin.client.GuiGraphicsAccessor;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11241;
import net.minecraft.class_11244;
import net.minecraft.class_1921;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5348;
import net.minecraft.class_7833;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class DrawUtil {
    public static double zLevel = 0.0;

    public static void drawCenteredLabel(class_332 graphics, class_2561 text, double x, double y, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale, boolean fontShadow) {
        DrawUtil.drawLabel(graphics, text, x, y, HAlign.Center, VAlign.Middle, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, 0.0);
    }

    public static void drawLabel(class_332 graphics, class_2561 text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, int color, float alpha, double fontScale, boolean fontShadow) {
        DrawUtil.drawLabel(graphics, text, x, y, hAlign, vAlign, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, 0.0);
    }

    public static void drawLabels(class_332 graphics, String[] lines, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        if (lines.length == 0) {
            return;
        }
        if (lines.length == 1) {
            if (bgColor != null && bgAlpha > 0.0f) {
                DrawUtil.drawLabel(graphics, (class_2561)class_2561.method_43470((String)lines[0]), x, y, hAlign, vAlign, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, rotation);
            }
            DrawUtil.drawLabel(graphics, (class_2561)class_2561.method_43470((String)lines[0]), x, y, hAlign, vAlign, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, rotation);
            return;
        }
        class_327 fontRenderer = class_310.method_1551().field_1772;
        double vpad = fontRenderer.method_1726() ? 0.0 : (fontShadow ? 6.0 : 4.0);
        double hpad = 4.0;
        Objects.requireNonNull(fontRenderer);
        double lineHeight = 9.0 * fontScale;
        double bgHeight = lineHeight * (double)lines.length + vpad;
        double bgWidth = 0.0;
        if (bgColor != null && bgAlpha > 0.0f) {
            for (String line : lines) {
                bgWidth = Math.max(bgWidth, (double)fontRenderer.method_1727(line) * fontScale);
            }
            if (bgWidth % 2.0 == 0.0) {
                bgWidth += 1.0;
            }
        }
        bgWidth += 4.0;
        double rectX = x;
        double rectY = y;
        switch (hAlign.ordinal()) {
            case 0: {
                rectX = x - bgWidth + 2.0;
                break;
            }
            case 1: {
                rectX = (float)(x - (Math.max(1.0, bgWidth) / 2.0 + fontScale) + (fontScale > 1.0 ? 0.5 : 0.0));
                break;
            }
            case 2: {
                rectX = x - 2.0 - 0.5;
            }
        }
        switch (vAlign.ordinal()) {
            case 0: {
                rectY = (y -= lineHeight * (double)lines.length) - bgHeight / 2.0 - vpad / 2.0;
                break;
            }
            case 1: {
                rectY = (y -= bgHeight / 2.0) - vpad / 2.0 - 5.0 * fontScale;
                break;
            }
            case 2: {
                rectY = y;
            }
        }
        if (bgColor != null && bgAlpha > 0.0f) {
            DrawUtil.drawRectangle(graphics, rectX, rectY, bgWidth + 4.0, bgHeight + vpad, bgColor, bgAlpha);
        }
        for (String line : lines) {
            DrawUtil.drawLabel(graphics, (class_2561)class_2561.method_43470((String)line), x, y, hAlign, vAlign, null, 0.0f, color, alpha, fontScale, fontShadow, rotation);
            y += lineHeight;
        }
    }

    public static void drawLabel(class_332 graphics, class_2561 text, Theme.LabelSpec labelSpec, double x, double y, HAlign hAlign, VAlign vAlign, double fontScale, double rotation) {
        DrawUtil.drawLabel(graphics, text, x, y, hAlign, vAlign, RGB.toArgb(labelSpec.background.getColor(), labelSpec.background.alpha), labelSpec.background.alpha, RGB.toArgb(labelSpec.foreground.getColor(), labelSpec.foreground.alpha), labelSpec.foreground.alpha, fontScale, labelSpec.shadow, rotation);
    }

    public static void drawLabel(class_332 graphics, class_2561 text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        double bgWidth = 0.0;
        double bgHeight = 0.0;
        if (bgColor != null && bgAlpha > 0.0f) {
            class_327 fontRenderer = class_310.method_1551().field_1772;
            bgWidth = fontRenderer.method_27525((class_5348)text);
            bgHeight = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        }
        DrawUtil.drawLabel(graphics, text, x, y, hAlign, vAlign, bgColor, bgAlpha, bgWidth, bgHeight, color, alpha, fontScale, fontShadow, rotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawLabel(class_332 graphics, class_2561 text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, double bgWidth, double bgHeight, Integer color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        int height;
        if (text == null || text.getString().isEmpty()) {
            return;
        }
        class_327 fontRenderer = class_310.method_1551().field_1772;
        boolean drawRect = bgColor != null && bgAlpha > 0.0f;
        double width = fontRenderer.method_27525((class_5348)text);
        if (drawRect) {
            v0 = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        } else {
            Objects.requireNonNull(fontRenderer);
            v0 = height = 9;
        }
        if (!drawRect && fontRenderer.method_1726()) {
            --height;
        }
        graphics.method_51448().pushMatrix();
        try {
            double d;
            if (fontScale != 1.0) {
                x /= fontScale;
                y /= fontScale;
                graphics.method_51448().scale((float)fontScale, (float)fontScale);
            }
            float textX = (float)x;
            float textY = (float)y;
            double rectX = x;
            double rectY = y;
            switch (hAlign.ordinal()) {
                case 0: {
                    textX = (float)(x - width);
                    rectX = textX;
                    break;
                }
                case 1: {
                    textX = (float)(x - width / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                    rectX = (float)(x - Math.max(1.0, bgWidth) / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                    break;
                }
                case 2: {
                    textX = (float)x;
                    rectX = (float)x;
                }
            }
            if (drawRect) {
                Objects.requireNonNull(fontRenderer);
                d = (double)(height - 9) / 2.0;
            } else {
                d = 0.0;
            }
            double vpad = d;
            switch (vAlign.ordinal()) {
                case 0: {
                    rectY = y - (double)height;
                    textY = (float)(rectY + vpad + (double)(!fontRenderer.method_1726() ? 1 : 0));
                    break;
                }
                case 1: {
                    rectY = y - (double)(height / 2) + (fontScale > 1.0 ? 0.5 : 0.0);
                    textY = (float)(rectY + vpad);
                    break;
                }
                case 2: {
                    rectY = y;
                    textY = (float)(rectY + vpad);
                }
            }
            if (rotation != 0.0) {
                graphics.method_51448().rotateAbout((float)Math.toRadians(-rotation), (float)x, (float)y);
            }
            graphics.method_51448().translate((float)((double)textX - Math.floor(textX)), (float)((double)textY - Math.floor(textY)));
            if (drawRect) {
                int hpad = 2;
                DrawUtil.drawRectangle(graphics, rectX - 2.0, rectY, bgWidth + 4.0, bgHeight, bgColor, bgAlpha);
            }
            color = RGB.toArgb(RGB.rgbaToRgb(color), alpha);
            graphics.method_51439(fontRenderer, text, (int)Math.floor(textX), (int)Math.floor(textY), color.intValue(), fontShadow);
        }
        finally {
            graphics.method_51448().popMatrix();
        }
    }

    public static void drawBatchLabel(class_332 graphics, class_4587 poseStack, class_2561 text, Theme.LabelSpec labelSpec, double x, double y, HAlign hAlign, VAlign vAlign, double fontScale, double rotation) {
        DrawUtil.drawBatchLabel(graphics, poseStack, text, x, y, hAlign, vAlign, labelSpec.background.getColor(), labelSpec.background.alpha, labelSpec.foreground.getColor(), labelSpec.foreground.alpha, fontScale, labelSpec.shadow, rotation);
    }

    public static void drawBatchLabel(class_332 graphics, class_4587 poseStack, class_2561 text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, int color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        double bgWidth = 0.0;
        double bgHeight = 0.0;
        if (bgColor != null && bgAlpha > 0.0f) {
            class_327 fontRenderer = class_310.method_1551().field_1772;
            bgWidth = fontRenderer.method_27525((class_5348)text);
            bgHeight = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        }
        DrawUtil.drawBatchLabel(graphics, poseStack, text, x, y, hAlign, vAlign, bgColor, bgAlpha, bgWidth, bgHeight, color, alpha, fontScale, fontShadow, rotation);
    }

    private static void drawBatchLabel(class_332 graphics, class_4587 poseStack, class_2561 text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, double bgWidth, double bgHeight, int color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        double d;
        int height;
        if (text == null || text.getString().length() == 0) {
            return;
        }
        class_327 fontRenderer = class_310.method_1551().field_1772;
        boolean drawRect = bgColor != null && bgAlpha > 0.0f;
        double width = fontRenderer.method_27525((class_5348)text);
        if (drawRect) {
            v0 = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        } else {
            Objects.requireNonNull(fontRenderer);
            v0 = height = 9;
        }
        if (!drawRect && fontRenderer.method_1726()) {
            --height;
        }
        poseStack.method_22903();
        if (fontScale != 1.0) {
            x /= fontScale;
            y /= fontScale;
            poseStack.method_22905((float)fontScale, (float)fontScale, 0.0f);
        }
        float textX = (float)x;
        float textY = (float)y;
        double rectX = x;
        double rectY = y;
        switch (hAlign.ordinal()) {
            case 0: {
                textX = (float)(x - width);
                rectX = textX;
                break;
            }
            case 1: {
                textX = (float)(x - width / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                rectX = (float)(x - Math.max(1.0, bgWidth) / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                break;
            }
            case 2: {
                textX = (float)x;
                rectX = (float)x;
            }
        }
        if (drawRect) {
            Objects.requireNonNull(fontRenderer);
            d = (double)(height - 9) / 2.0;
        } else {
            d = 0.0;
        }
        double vpad = d;
        switch (vAlign.ordinal()) {
            case 0: {
                rectY = y - (double)height;
                textY = (float)(rectY + vpad + (double)(!fontRenderer.method_1726() ? 1 : 0));
                break;
            }
            case 1: {
                rectY = y - (double)(height / 2) + (fontScale > 1.0 ? 0.5 : 0.0);
                textY = (float)(rectY + vpad);
                break;
            }
            case 2: {
                rectY = y;
                textY = (float)(rectY + vpad);
            }
        }
        if (rotation != 0.0) {
            poseStack.method_22904(x, y, 0.0);
            poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees((float)(-rotation)));
            poseStack.method_22904(-x, -y, 0.0);
        }
        if (drawRect) {
            RenderWrapper.disableDepthTest();
            int hpad = 2;
            DrawUtil.drawRectangle(graphics, rectX - 2.0, rectY, bgWidth + 4.0, bgHeight, bgColor, bgAlpha);
        }
        if (alpha < 0.0f) {
            color = RGB.toArgb(color, alpha);
        }
        graphics.method_51439(fontRenderer, text, (int)textX, (int)textY, color, fontShadow);
        poseStack.method_22909();
    }

    public static void drawBatchLabel(class_4587 poseStack, class_2561 text, DrawStep.Pass pass, class_4597 buffers, double x, double y, HAlign hAlign, VAlign vAlign, int bgColor, float bgAlpha, int color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        if (pass != DrawStep.Pass.TextBG && pass != DrawStep.Pass.Text) {
            return;
        }
        if (text == null || text.getString().length() == 0) {
            return;
        }
        if (pass == DrawStep.Pass.TextBG && bgAlpha == 0.0f || pass == DrawStep.Pass.Text && alpha == 0.0f) {
            return;
        }
        class_327 fontRenderer = class_310.method_1551().field_1772;
        int width = fontRenderer.method_27525((class_5348)text);
        Objects.requireNonNull(fontRenderer);
        int height = 9;
        poseStack.method_22903();
        if (fontScale != 1.0) {
            x /= fontScale;
            y /= fontScale;
            poseStack.method_22905((float)fontScale, (float)fontScale, 0.0f);
        }
        double textX = x;
        double textY = y;
        switch (hAlign.ordinal()) {
            case 0: {
                textX = x - (double)width;
                break;
            }
            case 1: {
                textX = x - (double)(width / 2);
                break;
            }
            case 2: {
                textX = x;
            }
        }
        double padding = 2.0 / fontScale * (double)class_3532.method_15357((double)fontScale);
        switch (vAlign.ordinal()) {
            case 0: {
                textY = y - ((double)height + padding * 2.0) + (double)(!fontRenderer.method_1726() ? 1 : 0);
                break;
            }
            case 1: {
                textY = y - (double)((int)((double)height + padding * 2.0) / 2);
                break;
            }
            case 2: {
                textY = y;
            }
        }
        textY += padding - 1.0;
        if (rotation != 0.0) {
            poseStack.method_22904(x, y, 0.0);
            poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees((float)(-rotation)));
            poseStack.method_22904(-x, -y, 0.0);
        }
        if (pass == DrawStep.Pass.TextBG) {
            float rectX = (float)(textX - padding);
            float rectY = (float)(textY - padding);
            float rectW = (float)((double)width + padding * 2.0);
            float rectH = (float)((double)height + padding * 2.0);
            class_4588 vertexBuilder = buffers.method_73477(JMRenderTypes.RECTANGLE_RENDER_TYPE);
            DrawUtil.drawRectangle(poseStack, vertexBuilder, rectX, rectY, rectW, rectH, bgColor, bgAlpha);
        } else {
            Matrix4f matrixPos = poseStack.method_23760().method_23761();
            color = RGB.toArgb(color, alpha);
            fontRenderer.method_27522(text, (float)textX, (float)textY + 1.0f, color, fontShadow, matrixPos, buffers, class_327.class_6415.field_33993, 0, 0xF000F0);
        }
        poseStack.method_22909();
    }

    public static int getLabelHeight(class_327 fr, boolean fontShadow) {
        int vpad = fr.method_1726() ? 0 : (fontShadow ? 6 : 4);
        Objects.requireNonNull(fr);
        return 9 + vpad;
    }

    public static void drawRectangle(class_332 graphics, double x, double y, double width, double height, int color, float alpha) {
        int rgba = RGB.toArgb(color, alpha);
        graphics.method_48196(Pipelines.RECTANGLE_RENDER_PIPELINE, (int)x, (int)y, (int)(x + width), (int)(y + height), rgba);
    }

    public static void drawGradientRect(class_332 graphics, double x, double y, double width, double height, int startColor, float startAlpha, int endColor, float endAlpha) {
        if (startAlpha > 1.0f) {
            startAlpha /= 255.0f;
        }
        if (endAlpha > 1.0f) {
            endAlpha /= 255.0f;
        }
        int rgbaStart = RGB.toArgb(startColor, startAlpha);
        int rgbaEnd = RGB.toArgb(endColor, endAlpha);
        graphics.method_25296((int)x, (int)y, (int)(x + width), (int)(height + y), rgbaStart, rgbaEnd);
    }

    public static void drawOnMapImageScaleCorrected(class_332 graphics, class_2960 texture, int color, float alpha, double x, double y, double width, double height, float scale, double rotation) {
        DrawUtil.drawOnMapImageScaleCorrected(graphics, texture, color, alpha, x, y, width, height, scale, rotation, false);
    }

    public static void drawOnMapImageScaleCorrected(class_332 graphics, class_2960 texture, int color, float alpha, double x, double y, double width, double height, float scale, double rotation, boolean blur) {
        double scaledWidth = width * (double)scale;
        double scaledHeight = height * (double)scale;
        double drawX = x - scaledWidth / 2.0;
        double drawY = y - scaledHeight / 2.0;
        DrawUtil.drawOnMapImage(graphics, texture, color, alpha, drawX, drawY, scaledWidth, scaledHeight, rotation, blur);
    }

    public static void drawOnMapImage(class_332 graphics, class_2960 texture, int color, float alpha, double x, double y, double width, double height, double rotation, boolean blur) {
        DrawUtil.drawOnMapImage(graphics, texture, color, alpha, x, y, width, height, 0.0f, 1.0f, 0.0f, 1.0f, rotation, blur);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawOnMapImage(class_332 graphics, class_2960 texture, int color, float alpha, double x, double y, double width, double height, float minU, float maxU, float minV, float maxV, double rotation, boolean blur) {
        Matrix3x2fStack pose = graphics.method_51448();
        try {
            pose.pushMatrix();
            class_1044 tex = TextureCache.getTexture(texture);
            if (tex == null) {
                return;
            }
            tex.method_68004().setAddressMode(AddressMode.REPEAT);
            tex.method_68004().setTextureFilter(blur ? FilterMode.LINEAR : FilterMode.NEAREST, false);
            if (alpha > 1.0f) {
                alpha /= 255.0f;
            }
            if (rotation != 0.0) {
                float transX = (float)(x + width / 2.0);
                float transY = (float)(y + height / 2.0);
                pose.rotateAbout((float)Math.toRadians(-rotation), transX, transY);
            }
            int argb = RGB.toArgb(color, alpha);
            ((GuiGraphicsAccessor)graphics).jm$GuiRenderStateAccessor().method_70919((class_11244)new class_11241(class_10799.field_56883, class_11231.method_70900((GpuTextureView)tex.method_71659()), new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), (int)x, (int)y, (int)(x + width), (int)(y + height), minU, maxU, minV, maxV, argb, ((GuiGraphicsAccessor)graphics).jm$ScissorStackAccessor().method_70863()));
        }
        catch (Exception e) {
            Journeymap.getLogger().error((Object)e);
        }
        finally {
            pose.popMatrix();
        }
    }

    public static void drawBlurredTexture(class_332 graphics, class_2960 texture, double x, double y, double width, double height, boolean flip, float scale, double rotation) {
        DrawUtil.drawTexture(graphics, texture, x, y, width, height, flip, scale, rotation, true);
    }

    public static void drawTexture(class_332 graphics, class_2960 texture, double x, double y, double width, double height, boolean flip, float scale, double rotation, boolean blur) {
        DrawUtil.drawTexture(graphics, texture, 0xFFFFFF, 1.0f, x, y, width, height, flip, scale, rotation, blur, false);
    }

    public static void drawColoredTexture(class_332 graphics, class_2960 texture, int color, float alpha, double x, double y, double width, double height, float scale, double rotation) {
        DrawUtil.drawTexture(graphics, texture, color, alpha, x, y, width, height, false, scale, rotation, true, false);
    }

    public static void drawColoredTexture(class_332 graphics, class_2960 texture, int color, float alpha, double x, double y, double width, double height, float scale, double rotation, boolean blur) {
        DrawUtil.drawTexture(graphics, texture, color, alpha, x, y, width, height, false, scale, rotation, blur, false);
    }

    public static void drawTexture(class_332 graphics, class_2960 texture, int color, float alpha, double x, double y, double width, double height, boolean flip, float scale, double rotation, boolean blur, boolean clamp) {
        DrawUtil.drawTexture(graphics, texture, color, alpha, x, y, width * (double)scale, height * (double)scale, rotation, flip, blur, clamp);
    }

    public static void drawTexture(class_332 graphics, class_2960 texture, int color, float alpha, double x, double y, double width, double height, double rotation, boolean flip, boolean blur) {
        DrawUtil.drawTexture(graphics, texture, color, alpha, x, y, width, height, rotation, flip, blur, false);
    }

    public static void drawClampedTexture(class_332 graphics, class_2960 texture, int color, float alpha, double x, double y, double width, double height, float scale, double rotation) {
        DrawUtil.drawTexture(graphics, texture, color, alpha, x, y, width * (double)scale, height * (double)scale, rotation, false, true, true);
    }

    public static void drawTexture(class_332 graphics, class_2960 texture, int color, float alpha, double x, double y, double width, double height, boolean flip, double rotation) {
        DrawUtil.drawTexture(graphics, texture, color, alpha, x, y, width, height, rotation, flip, true, false);
    }

    public static void drawTexture(class_332 graphics, class_2960 texture, double x, double y, double width, double height, boolean flip, double rotation) {
        DrawUtil.drawTexture(graphics, texture, 0xFFFFFF, 1.0f, x, y, width, height, rotation, flip, true, false);
    }

    public static void drawTexture(class_332 graphics, class_2960 texture, int color, float alpha, double x, double y, double width, double height, double rotation, boolean flip, boolean blur, boolean clamp) {
        DrawUtil.drawTexture(graphics, class_10799.field_56883, texture, color, alpha, x, y, width, height, rotation, flip, blur, clamp);
    }

    public static void drawTexture(class_332 graphics, RenderPipeline pipeline, class_2960 texture, int color, float alpha, double x, double y, double width, double height, double rotation, boolean flip, boolean blur, boolean clamp) {
        DrawUtil.drawTexture(graphics, pipeline, texture, color, alpha, x, y, width, height, 0.0f, 1.0f, 0.0f, 1.0f, rotation, flip, blur, clamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawTexture(class_332 graphics, RenderPipeline pipeline, class_2960 texture, int color, float alpha, double x, double y, double width, double height, float minU, float maxU, float minV, float maxV, double rotation, boolean flip, boolean blur, boolean clamp) {
        Matrix3x2fStack pose = graphics.method_51448();
        try {
            class_1044 tex = TextureCache.getTexture(texture);
            if (tex != null) {
                tex.method_68004().setAddressMode(clamp ? AddressMode.CLAMP_TO_EDGE : AddressMode.REPEAT);
                tex.method_68004().setTextureFilter(blur ? FilterMode.LINEAR : FilterMode.NEAREST, false);
            }
            pose.pushMatrix();
            if (alpha > 1.0f) {
                alpha /= 255.0f;
            }
            if (rotation != 0.0) {
                float transX = (float)(x + width / 2.0);
                float transY = (float)(y + height / 2.0);
                pose.rotateAbout((float)Math.toRadians(-rotation), transX, transY);
            }
            int argb = RGB.toArgb(color, alpha);
            float direction = flip ? -maxU : maxU;
            ((GuiGraphicsAccessor)graphics).innerBlitInvoker(pipeline, texture, (int)Math.round(x), (int)Math.round(x + width), (int)Math.round(y), (int)Math.round(y + height), minU, direction, minV, maxV, argb);
        }
        catch (Exception e) {
            Journeymap.getLogger().error((Object)e);
        }
        finally {
            pose.popMatrix();
        }
    }

    public static void blitToCurrentLayer(class_332 graphics, class_2960 texture, int color, float alpha, double x, double y, double width, double height, float scale, boolean blur) {
        class_1044 tex = TextureCache.getTexture(texture);
        tex.method_68004().setTextureFilter(blur ? FilterMode.LINEAR : FilterMode.NEAREST, false);
        DrawUtil.blitToCurrentLayer(graphics, class_10799.field_56883, tex.method_71659(), color, alpha, x, y, width * (double)scale, height * (double)scale);
    }

    public static void blitToCurrentLayer(class_332 graphics, RenderPipeline pipeline, GpuTextureView textureView, int color, float alpha, double x, double y, double width, double height) {
        DrawUtil.blitToCurrentLayer(graphics, pipeline, textureView, color, alpha, x, y, width, height, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void blitToCurrentLayer(class_332 graphics, RenderPipeline pipeline, GpuTextureView textureView, int color, float alpha, double x, double y, double width, double height, float minU, float minV, float maxU, float maxV) {
        try {
            graphics.method_51448().pushMatrix();
            if (alpha > 1.0f) {
                alpha /= 255.0f;
            }
            ((GuiGraphicsAccessor)graphics).jm$GuiRenderStateAccessor().method_70919((class_11244)new class_11241(pipeline, class_11231.method_70900((GpuTextureView)textureView), new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), (int)x, (int)y, (int)(x + width), (int)(y + height), minU, maxU, minV, maxV, RGB.toArgb(color, alpha), ((GuiGraphicsAccessor)graphics).jm$ScissorStackAccessor().method_70863()));
        }
        catch (Exception e) {
            Journeymap.getLogger().error((Object)e);
        }
        finally {
            graphics.method_51448().popMatrix();
        }
    }

    public static void drawQuad(class_4587 poseStack, class_4588 vertexBuilder, int color, float alpha, double x, double y, double width, double height, double rotation, boolean flip) {
        DrawUtil.drawQuad(poseStack, vertexBuilder, color, alpha, x, y, width, height, 0.0, 0.0, 1.0, 1.0, rotation, flip);
    }

    public static void drawQuad(class_4587 poseStack, class_4588 vertexConsumer, class_1043 texture, int color, float alpha, double x, double y, float scale, double rotation, boolean flip) {
        DrawUtil.drawQuad(poseStack, vertexConsumer, color, alpha, x, y, (float)((TextureAccess)texture).journeymap$getWidth() * scale, (float)((TextureAccess)texture).journeymap$getHeight() * scale, 0.0, 0.0, 1.0, 1.0, rotation, flip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawQuad(class_4587 poseStack, class_4588 vertexBuilder, int color, float alpha, double x, double y, double width, double height, double minU, double minV, double maxU, double maxV, double rotation, boolean flip) {
        try {
            poseStack.method_22903();
            if (alpha > 1.0f) {
                alpha /= 255.0f;
            }
            if (rotation != 0.0) {
                double transX = x + width / 2.0;
                double transY = y + height / 2.0;
                poseStack.method_22904(transX, transY, 0.0);
                poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees((float)(-rotation)));
                poseStack.method_22904(-transX, -transY, 0.0);
            }
            float[] rgba = RGB.floats(color, alpha);
            double direction = flip ? -maxU : maxU;
            DrawUtil.addVertexUV(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], x, height + y, zLevel, minU, maxV);
            DrawUtil.addVertexUV(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], x + width, height + y, zLevel, direction, maxV);
            DrawUtil.addVertexUV(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], x + width, y, zLevel, direction, minV);
            DrawUtil.addVertexUV(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], x, y, zLevel, minU, minV);
        }
        catch (Exception e) {
            Journeymap.getLogger().error((Object)e);
        }
        finally {
            poseStack.method_22909();
        }
    }

    public static void drawColoredEntity(class_4587 poseStack, class_4588 vertexBuilder, class_1043 texture, int color, float alpha, double x, double y, float scale, double rotation) {
        if (texture == null || texture.method_4525() == null) {
            return;
        }
        double width = (float)((TextureAccess)texture).journeymap$getWidth() * scale;
        double height = (float)((TextureAccess)texture).journeymap$getHeight() * scale;
        double drawX = x - width / 2.0;
        double drawY = y - height / 2.0;
        drawX = Math.floor(drawX);
        drawY = Math.floor(drawY);
        DrawUtil.drawQuad(poseStack, vertexBuilder, color, alpha, drawX, drawY, width, height, rotation, false);
    }

    public static void drawWaypointIcon(class_4587 poseStack, class_4588 vertexBuilder, class_1043 texture, float scale, int color, float alpha, double x, double y, double rotation) {
        if (scale > 1.0f) {
            texture = ((TextureAccess)texture).journeymap$getScaledImage(scale);
            scale = 1.0f;
        }
        double width = (float)((TextureAccess)texture).journeymap$getWidth() * scale;
        double height = (float)((TextureAccess)texture).journeymap$getHeight() * scale;
        double drawX = x - width / 2.0;
        double drawY = y - height / 2.0;
        DrawUtil.drawQuad(poseStack, vertexBuilder, color, alpha, drawX, drawY, width, height, rotation, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRectangle(class_4587 poseStack, class_4588 vertexBuilder, double x, double y, double width, double height, int color, float alpha) {
        try {
            poseStack.method_22903();
            if (alpha > 1.0f) {
                alpha /= 255.0f;
            }
            float[] rgba = RGB.floats(color, alpha);
            DrawUtil.addVertex(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (double)((float)x), (double)((float)(height + y)), zLevel);
            DrawUtil.addVertex(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (double)((float)(x + width)), (double)((float)(height + y)), zLevel);
            DrawUtil.addVertex(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (double)((float)(x + width)), (double)((float)y), zLevel);
            DrawUtil.addVertex(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (double)((float)x), (double)((float)y), zLevel);
        }
        catch (Exception e) {
            Journeymap.getLogger().error((Object)e);
        }
        finally {
            poseStack.method_22909();
        }
    }

    public static void drawPolygon(class_332 graphics, class_4587 poseStack, class_4597.class_4598 buffers, double xOffset, double yOffset, List<Point2D.Double> fillPoints, List<List<Point2D.Double>> strokePoints, List<Point2D.Double> texturePoints, class_1044 texture, ShapeProperties shapeProperties) {
        int i;
        float[] rgba;
        if (shapeProperties.getFillOpacity() >= 0.01f) {
            rgba = RGB.floats(shapeProperties.getFillColor(), shapeProperties.getFillOpacity());
            int lastIndex = fillPoints.size() - 1;
            if (texture == null || shapeProperties.getTextureScaleX() == 0.0 || shapeProperties.getTextureScaleY() == 0.0) {
                class_1921 renderType = JMRenderTypes.POLYGON_WITHOUT_TEXTURE_RENDER_TYPE;
                class_4588 vertexBuilder = buffers.method_73477(renderType);
                for (int i2 = 0; i2 <= lastIndex; ++i2) {
                    Point2D.Double point = fillPoints.get(i2);
                    DrawUtil.addVertex(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], point.getX() + xOffset, point.getY() + yOffset, zLevel);
                }
            } else {
                double textureWidth = (double)((TextureAccess)texture).journeymap$getWidth() * shapeProperties.getTextureScaleX();
                double textureHeight = (double)((TextureAccess)texture).journeymap$getHeight() * shapeProperties.getTextureScaleY();
                class_1921 renderType = JMRenderTypes.getPolygonWithTexture(texture);
                class_4588 vertexBuilder = buffers.method_73477(renderType);
                for (i = 0; i <= lastIndex; ++i) {
                    Point2D.Double point = fillPoints.get(i);
                    double xTex = (texturePoints.get(i).getX() - shapeProperties.getTexturePositionX()) / textureWidth;
                    double yTex = (texturePoints.get(i).getY() - shapeProperties.getTexturePositionY()) / textureHeight;
                    DrawUtil.addVertexUV(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], point.getX() + xOffset, point.getY() + yOffset, zLevel, xTex, yTex);
                }
            }
        }
        if (shapeProperties.getStrokeOpacity() >= 0.01f && shapeProperties.getStrokeWidth() > 0.0f) {
            rgba = RGB.floats(shapeProperties.getStrokeColor(), shapeProperties.getStrokeOpacity());
            float insideStroke = 0.0f;
            float outsideStroke = 0.0f;
            switch (shapeProperties.getStrokePosition()) {
                case INSIDE: {
                    insideStroke = shapeProperties.getStrokeWidth();
                    break;
                }
                case CENTER: {
                    outsideStroke = insideStroke = shapeProperties.getStrokeWidth() / 2.0f;
                    break;
                }
                default: {
                    outsideStroke = shapeProperties.getStrokeWidth();
                }
            }
            class_1921 renderType = JMRenderTypes.POLYGON_STROKE_RENDER_TYPE;
            for (List<Point2D.Double> screenPoints : strokePoints) {
                if (screenPoints.size() < 3) continue;
                class_4588 vertexBuilder = buffers.method_73477(renderType);
                int lastIndex = screenPoints.size() - 1;
                for (i = 0; i <= lastIndex + 1; ++i) {
                    int iPoint = i <= lastIndex ? i : 0;
                    int iPrev = iPoint > 0 ? iPoint - 1 : lastIndex;
                    int iNext = iPoint < lastIndex ? iPoint + 1 : 0;
                    Point2D.Double point = screenPoints.get(iPoint);
                    Point2D.Double prev = screenPoints.get(iPrev);
                    Point2D.Double next = screenPoints.get(iNext);
                    Point2D.Double normal = DrawUtil.calculateNormal(prev, point, next);
                    DrawUtil.addVertex(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], point.getX() + normal.getX() * (double)insideStroke + xOffset, point.getY() + normal.getY() * (double)insideStroke + yOffset, zLevel);
                    DrawUtil.addVertex(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], point.getX() - normal.getX() * (double)outsideStroke + xOffset, point.getY() - normal.getY() * (double)outsideStroke + yOffset, zLevel);
                }
            }
        }
    }

    private static Point2D.Double calculateNormal(Point2D.Double prev, Point2D.Double point, Point2D.Double next) {
        class_241 edgeNormal2;
        class_241 edge1 = new class_241((float)(point.x - prev.x), (float)(point.y - prev.y));
        class_241 edge2 = new class_241((float)(next.x - point.x), (float)(next.y - point.y));
        class_241 edgeNormal1 = new class_241(-edge1.field_1342, edge1.field_1343).method_35581();
        class_241 vertexNormal = edgeNormal1.method_35586(edgeNormal2 = new class_241(-edge2.field_1342, edge2.field_1343).method_35581()).method_35581();
        double angle = Math.acos(vertexNormal.method_35583(edgeNormal1));
        double factor = Math.cos(angle);
        if (factor < 0.1) {
            factor = 0.1;
        }
        factor = 1.0 / factor;
        return new Point2D.Double((double)vertexNormal.field_1343 * factor, (double)vertexNormal.field_1342 * factor);
    }

    public static void addVertexUV(class_4587 poseStack, class_4588 bufferIn, float red, float green, float blue, float alpha, int y, float x, float z, float texU, float texV) {
        bufferIn.method_22918(poseStack.method_23760().method_23761(), x, (float)y, z).method_22915(red, green, blue, alpha).method_22913(texU, texV).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(poseStack.method_23760(), 0.0f, 1.0f, 0.0f);
    }

    public static void addVertexUV(class_4587 poseStack, class_4588 bufferIn, float red, float green, float blue, float alpha, double x, double y, double z, double texU, double texV) {
        bufferIn.method_22918(poseStack.method_23760().method_23761(), (float)x, (float)y, (float)z).method_22915(red, green, blue, alpha).method_22913((float)texU, (float)texV).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(poseStack.method_23760(), 0.0f, 1.0f, 0.0f);
    }

    public static void addVertex(class_4587 poseStack, class_4588 bufferIn, float red, float green, float blue, float alpha, double x, double y, double z) {
        bufferIn.method_22918(poseStack.method_23760().method_23761(), (float)x, (float)y, (float)z).method_22915(red, green, blue, alpha).method_60831(poseStack.method_23760(), 0.0f, 1.0f, 0.0f);
    }

    public static void addVertex(Matrix3x2fStack pos, class_4588 bufferIn, float red, float green, float blue, float alpha, double x, double y, double z) {
        bufferIn.method_70815((Matrix3x2f)pos, (float)x, (float)y).method_22915(red, green, blue, alpha);
    }

    public static void addVertexUV(Matrix3x2fStack pos, class_4588 bufferIn, float red, float green, float blue, float alpha, double x, double y, double z, double texU, double texV) {
        bufferIn.method_70815((Matrix3x2f)pos, (float)x, (float)y).method_22915(red, green, blue, alpha).method_22913((float)texU, (float)texV).method_22922(class_4608.field_21444).method_60803(0xF000F0);
    }

    public static void addVertexWithUV(class_4587 poseStack, class_287 buff, float x, float y, float z, float u, float v) {
        class_4587.class_4665 entry = poseStack.method_23760();
        Matrix4f matrix4f = entry.method_23761();
        buff.method_22918(matrix4f, x, y, z).method_22913(u, v);
    }

    public static void addVertexWithUV(class_4587 poseStack, class_287 buff, double x, double y, double z, double u, double v) {
        DrawUtil.addVertexWithUV(poseStack, buff, (float)x, (float)y, (float)z, (float)u, (float)v);
    }

    public static void addVertexUV(class_332 graphics, class_4587 poseStack, class_287 buff, double x, double y, double z, double u, double v, int[] rgba) {
        class_4587.class_4665 entry = poseStack.method_23760();
        Matrix4f matrix4f = entry.method_23761();
        buff.method_22918(matrix4f, (float)x, (float)y, (float)z).method_1336(rgba[0], rgba[1], rgba[2], rgba[3]).method_22913((float)u, (float)v);
    }

    private static void addVertex(Matrix4f mat, class_287 buff, double x, double y, double z, int[] rgba) {
        buff.method_22918(mat, (float)x, (float)y, (float)z).method_1336(rgba[0], rgba[1], rgba[2], rgba[3]);
    }

    public static enum HAlign {
        Left,
        Center,
        Right;

    }

    public static enum VAlign {
        Above,
        Middle,
        Below;

    }
}

