/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.v2.client.display;

import java.util.HashMap;
import journeymap.api.v2.client.display.Displayable;
import journeymap.api.v2.client.display.ImageOverlay;
import journeymap.api.v2.client.display.MarkerOverlay;
import journeymap.api.v2.client.display.PolygonOverlay;

public enum DisplayType {
    Image(ImageOverlay.class),
    Marker(MarkerOverlay.class),
    Polygon(PolygonOverlay.class);

    private static HashMap<Class<? extends Displayable>, DisplayType> reverseLookup;
    private final Class<? extends Displayable> implClass;

    private DisplayType(Class<? extends Displayable> implClass) {
        this.implClass = implClass;
    }

    public static DisplayType of(Class<? extends Displayable> implClass) {
        DisplayType displayType;
        if (reverseLookup == null) {
            reverseLookup = new HashMap();
            for (DisplayType type : DisplayType.values()) {
                reverseLookup.put(type.getImplClass(), type);
            }
        }
        if ((displayType = reverseLookup.get(implClass)) == null) {
            throw new IllegalArgumentException("Not a valid Displayable implementation: " + String.valueOf(implClass));
        }
        return displayType;
    }

    public Class<? extends Displayable> getImplClass() {
        return this.implClass;
    }
}

