/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.coat.list.complex;

import de.siphalor.coat.handler.ConfigEntryHandler;
import de.siphalor.coat.handler.Message;
import de.siphalor.coat.list.DynamicEntryListWidget;
import de.siphalor.coat.list.category.ConfigTreeEntry;
import de.siphalor.coat.list.complex.ConfigListEntryFactory;
import de.siphalor.coat.list.entry.ConfigListEntry;
import de.siphalor.coat.screen.ConfigContentWidget;
import de.siphalor.coat.util.CoatUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class ConfigListWidget<V>
extends DynamicEntryListWidget<ConfigListEntry<V>>
implements ConfigContentWidget {
    private static final String APPEND_BUTTON_TEXT_KEY = "coat.list.append";
    private static final class_2561 APPEND_BUTTON_TEXT = class_2561.method_43471((String)"coat.list.append");
    private final class_5250 name;
    private final ConfigEntryHandler<List<V>> entryHandler;
    private final ConfigListEntryFactory<V> entryFactory;
    private final class_4185 appendButton = class_4185.method_46430((class_2561)APPEND_BUTTON_TEXT, button -> this.createEntry(this.getEntryCount())).method_46437(100, 20).method_46431();
    private ConfigListEntry<V> dragEntry;

    public ConfigListWidget(class_310 client, int width, int height, int top, int rowWidth, ConfigContentWidget parent, class_5250 name, ConfigEntryHandler<List<V>> entryHandler, ConfigListEntryFactory<V> entryFactory) {
        super(client, width, height, top, rowWidth);
        this.name = name;
        this.entryHandler = entryHandler;
        this.entryFactory = entryFactory;
    }

    public ConfigListWidget(class_310 client, Collection<ConfigListEntry<V>> entries, class_2960 background, ConfigContentWidget parent, class_5250 name, ConfigEntryHandler<List<V>> entryHandler, ConfigListEntryFactory<V> entryFactory) {
        super(client, entries, background);
        this.name = name;
        this.entryHandler = entryHandler;
        this.entryFactory = entryFactory;
    }

    @Override
    public boolean method_25402(class_11909 event, boolean doubleClick) {
        double mouseX = event.comp_4798();
        double mouseY = event.comp_4799();
        boolean result = super.method_25402(event, doubleClick);
        if (mouseX < (double)(this.left + 20)) {
            this.dragEntry = (ConfigListEntry)this.getEntryAtPosition(mouseX, mouseY);
            if (this.dragEntry != null) {
                this.method_25398(true);
                this.dragEntry.setDragFollow(true);
                return true;
            }
        }
        if (!result) {
            return this.appendButton.method_25402(event, doubleClick);
        }
        return true;
    }

    public void method_16014(double mouseX, double mouseY) {
        super.method_16014(mouseX, mouseY);
    }

    @Override
    public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
        boolean result = super.method_25403(event, deltaX, deltaY);
        double mouseY = event.comp_4799();
        if (this.dragEntry != null && this.dragEntry.isDragFollow()) {
            int oldPos = this.entries().indexOf(this.dragEntry);
            if (oldPos < 0) {
                return result;
            }
            int newPos = this.getEntryAtY((int)mouseY);
            if (oldPos != newPos) {
                this.removeEntry(oldPos);
                this.addEntry(Math.min(newPos, this.getEntryCount()), this.dragEntry);
                return true;
            }
        }
        return result;
    }

    @Override
    public boolean method_25406(class_11909 event) {
        this.method_25398(false);
        if (this.dragEntry != null) {
            this.dragEntry.setDragFollow(false);
        }
        this.dragEntry = null;
        return super.method_25406(event);
    }

    @Override
    public ConfigTreeEntry getTreeEntry() {
        return new ConfigTreeEntry((class_2561)this.name.method_27694(style -> style.method_30938(Boolean.valueOf(true))), this, true);
    }

    @Override
    public List<ConfigContentWidget> getSubTrees() {
        return Collections.emptyList();
    }

    @Override
    public class_2561 getName() {
        return this.name;
    }

    public List<V> getValue() {
        return this.entries().stream().map(ConfigListEntry::getValue).collect(Collectors.toList());
    }

    @Override
    public Collection<Message> getMessages() {
        List<Message> messages = this.entries().stream().flatMap(entry -> entry.getMessages().stream()).collect(Collectors.toList());
        messages.addAll(this.entryHandler.getMessages(this.getValue()));
        return messages;
    }

    @Override
    public void save() {
        this.entryHandler.save(this.getValue());
    }

    public void createEntry(int pos) {
        this.addEntry(pos, this.entryFactory.create());
    }

    @Override
    public ConfigListEntry<V> removeEntry(ConfigListEntry<V> entry) {
        return super.removeEntry(entry);
    }

    @Override
    protected int getMaxPosition() {
        return super.getMaxPosition() + 4 + this.appendButton.method_25364();
    }

    @Override
    public void renderWidget(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.renderWidget(graphics, mouseX, mouseY, delta);
        CoatUtil.setButtonPosition(this.appendButton, this.left + (this.width - this.appendButton.method_25368()) / 2, super.getEntryAreaTop() + super.getMaxPosition());
        this.appendButton.method_25394(graphics, mouseX, mouseY, delta);
    }

    @Override
    public void method_25395(@Nullable class_364 focused) {
        super.method_25395(focused);
        if (focused == this.appendButton) {
            this.setScrollYOffset(this.getMaxPosition());
        }
    }

    @Override
    public List<? extends class_364> method_25396() {
        ArrayList<class_4185> children = new ArrayList<class_4185>(this.entries());
        children.add(this.appendButton);
        return children;
    }
}

