/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.lib.sentry;

import dev.tr7zw.lib.sentry.EventProcessor;
import dev.tr7zw.lib.sentry.Hint;
import dev.tr7zw.lib.sentry.SentryBaseEvent;
import dev.tr7zw.lib.sentry.SentryEvent;
import dev.tr7zw.lib.sentry.protocol.SentryRuntime;
import dev.tr7zw.lib.sentry.protocol.SentryTransaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SentryRuntimeEventProcessor
implements EventProcessor {
    @Nullable
    private final String javaVersion;
    @Nullable
    private final String javaVendor;

    public SentryRuntimeEventProcessor(@Nullable String javaVersion, @Nullable String javaVendor) {
        this.javaVersion = javaVersion;
        this.javaVendor = javaVendor;
    }

    public SentryRuntimeEventProcessor() {
        this(System.getProperty("java.version"), System.getProperty("java.vendor"));
    }

    @Override
    @NotNull
    public SentryEvent process(@NotNull SentryEvent event, @Nullable Hint hint) {
        return this.process(event);
    }

    @Override
    @NotNull
    public SentryTransaction process(@NotNull SentryTransaction transaction, @Nullable Hint hint) {
        return this.process(transaction);
    }

    @NotNull
    private <T extends SentryBaseEvent> T process(@NotNull T event) {
        SentryRuntime runtime;
        if (event.getContexts().getRuntime() == null) {
            event.getContexts().setRuntime(new SentryRuntime());
        }
        if ((runtime = event.getContexts().getRuntime()) != null && runtime.getName() == null && runtime.getVersion() == null) {
            runtime.setName(this.javaVendor);
            runtime.setVersion(this.javaVersion);
        }
        return event;
    }

    @Override
    @Nullable
    public Long getOrder() {
        return 2000L;
    }
}

