/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.core.impl.entry;

import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.core.api.entry.BaseConfigEntry;
import de.siphalor.tweed5.core.api.entry.CompoundConfigEntry;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.core.api.entry.ConfigEntryValueVisitor;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.IntFunction;

public class StaticMapCompoundConfigEntryImpl<T extends Map<String, Object>>
extends BaseConfigEntry<T>
implements CompoundConfigEntry<T> {
    private final IntFunction<T> mapConstructor;
    private final Map<String, ConfigEntry<?>> compoundEntries;

    public StaticMapCompoundConfigEntryImpl(ConfigContainer<?> container, Class<T> valueClass, IntFunction<T> mapConstructor, Map<String, ConfigEntry<?>> compoundEntries) {
        super(container, valueClass);
        this.mapConstructor = mapConstructor;
        this.compoundEntries = new LinkedHashMap(compoundEntries);
    }

    @Override
    public Map<String, ConfigEntry<?>> subEntries() {
        return this.compoundEntries;
    }

    @Override
    public <V> void set(T compoundValue, String key, V value) {
        this.requireKey(key);
        compoundValue.put((String)key, value);
    }

    @Override
    public <V> V get(T compoundValue, String key) {
        this.requireKey(key);
        return compoundValue.get(key);
    }

    private void requireKey(String key) {
        if (!this.compoundEntries.containsKey(key)) {
            throw new IllegalArgumentException("Key " + key + " does not exist on this compound entry!");
        }
    }

    @Override
    public T instantiateCompoundValue() {
        return (T)((Map)this.mapConstructor.apply(this.compoundEntries.size()));
    }

    @Override
    public void visitInOrder(ConfigEntryValueVisitor visitor, T value) {
        if (visitor.enterStructuredEntry(this, value)) {
            if (value != null) {
                this.compoundEntries.forEach((key, entry) -> {
                    if (visitor.enterStructuredSubEntry((String)key, (String)key)) {
                        entry.visitInOrder(visitor, value.get(key));
                        visitor.leaveStructuredSubEntry((String)key, (String)key);
                    }
                });
            }
            visitor.leaveStructuredEntry(this, value);
        }
    }

    @Override
    public T deepCopy(T value) {
        Object copy = this.instantiateCompoundValue();
        value.forEach((arg_0, arg_1) -> this.lambda$deepCopy$0((Map)copy, arg_0, arg_1));
        return (T)copy;
    }

    private /* synthetic */ void lambda$deepCopy$0(Map copy, String key, Object element) {
        ConfigEntry<?> elementEntry = this.compoundEntries.get(key);
        if (elementEntry != null) {
            copy.put(key, elementEntry.deepCopy(element));
        }
    }
}

