/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.core.impl.entry;

import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.core.api.entry.BaseConfigEntry;
import de.siphalor.tweed5.core.api.entry.CollectionConfigEntry;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import java.util.Collection;
import java.util.function.IntFunction;

public class CollectionConfigEntryImpl<E, T extends Collection<E>>
extends BaseConfigEntry<T>
implements CollectionConfigEntry<E, T> {
    private final IntFunction<T> collectionConstructor;
    private final ConfigEntry<E> elementEntry;

    public CollectionConfigEntryImpl(ConfigContainer<?> container, Class<T> valueClass, IntFunction<T> collectionConstructor, ConfigEntry<E> elementEntry) {
        super(container, valueClass);
        this.collectionConstructor = collectionConstructor;
        this.elementEntry = elementEntry;
    }

    @Override
    public ConfigEntry<E> elementEntry() {
        return this.elementEntry;
    }

    @Override
    public T instantiateCollection(int size) {
        return (T)((Collection)this.collectionConstructor.apply(size));
    }

    @Override
    public T deepCopy(T value) {
        Collection copy = (Collection)this.collectionConstructor.apply(value.size());
        for (Object element : value) {
            copy.add(this.elementEntry().deepCopy(element));
        }
        return (T)copy;
    }
}

