/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.core.api.sort;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import lombok.Generated;

public class AcyclicGraphSorter {
    private final int nodeCount;
    private final int wordCount;
    private final BitSet[] outgoingEdges;
    private final BitSet[] incomingEdges;

    public AcyclicGraphSorter(int nodeCount) {
        this.nodeCount = nodeCount;
        BigDecimal[] div = BigDecimal.valueOf(nodeCount).divideAndRemainder(BigDecimal.valueOf(64L));
        this.wordCount = div[0].intValue() + (BigDecimal.ZERO.equals(div[1]) ? 0 : 1);
        this.outgoingEdges = new BitSet[nodeCount];
        this.incomingEdges = new BitSet[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            this.outgoingEdges[i] = BitSet.empty(nodeCount, this.wordCount);
            this.incomingEdges[i] = BitSet.empty(nodeCount, this.wordCount);
        }
    }

    public void addEdge(int from, int to) {
        this.checkBounds(from);
        this.checkBounds(to);
        if (from == to) {
            throw new IllegalArgumentException("Edge from and to cannot be the same");
        }
        this.outgoingEdges[from].set(to);
        this.incomingEdges[to].set(from);
    }

    private void checkBounds(int index) {
        if (index < 0 || index >= this.nodeCount) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.nodeCount);
        }
    }

    public int[] sort() throws GraphCycleException {
        BitSet visited = BitSet.ready(this.nodeCount, this.wordCount);
        BitSet.Iterator visitedIter = visited.iterator();
        int lastVisited = -1;
        int[] sortedIndeces = new int[this.nodeCount];
        int nextSortedIndex = 0;
        while (nextSortedIndex < sortedIndeces.length) {
            if (!visitedIter.next()) {
                BitSet incomingEdge = this.incomingEdges[visitedIter.index()];
                if (incomingEdge.isEmptyAfterAndNot(visited)) {
                    sortedIndeces[nextSortedIndex] = visitedIter.index();
                    visitedIter.set();
                    lastVisited = visitedIter.index();
                    ++nextSortedIndex;
                }
            } else if (visitedIter.index() == lastVisited) break;
            if (visitedIter.hasNext()) continue;
            if (lastVisited == -1) break;
            visitedIter.restart();
        }
        if (nextSortedIndex < sortedIndeces.length) {
            this.findCycleAndThrow(visited);
        }
        return sortedIndeces;
    }

    private void findCycleAndThrow(BitSet visited) throws GraphCycleException {
        LinkedList<Integer> stack = new LinkedList<Integer>();
        BitSet.Iterator visitedIter = visited.iterator();
        while (visitedIter.next()) {
            if (visitedIter.hasNext()) continue;
            throw new IllegalStateException("Unable to find unvisited node in cycle detection");
        }
        stack.push(visitedIter.index());
        block1: while (true) {
            BitSet leftoverOutgoing = this.outgoingEdges[(Integer)stack.getFirst()].andNot(visited);
            BitSet.Iterator outgoingIter = leftoverOutgoing.iterator();
            while (outgoingIter.hasNext()) {
                if (!outgoingIter.next()) continue;
                if (stack.contains(outgoingIter.index())) {
                    ArrayList<Integer> reversed = new ArrayList<Integer>(stack.size());
                    stack.descendingIterator().forEachRemaining(reversed::add);
                    throw new GraphCycleException(reversed);
                }
                stack.push(outgoingIter.index());
                continue block1;
            }
            visited.set((Integer)stack.pop());
        }
    }

    private static class BitSet {
        private static final int WORD_SIZE = 64;
        private final int bitCount;
        private final int wordCount;
        private long[] words;

        static BitSet ready(int bitCount, int wordCount) {
            return new BitSet(bitCount, wordCount, new long[wordCount]);
        }

        static BitSet empty(int bitCount, int wordCount) {
            return new BitSet(bitCount, wordCount, null);
        }

        private void set(int index) {
            this.cloneOnWrite();
            int wordIndex = index / 64;
            int innerIndex = index % 64;
            int n = wordIndex;
            this.words[n] = this.words[n] | 1L << innerIndex;
        }

        private void cloneOnWrite() {
            if (this.words == null) {
                this.words = new long[this.wordCount];
            }
        }

        public boolean isEmpty() {
            if (this.words == null) {
                return true;
            }
            for (long word : this.words) {
                if (word == 0L) continue;
                return false;
            }
            return true;
        }

        public BitSet andNot(BitSet mask) {
            if (this.words == null) {
                return BitSet.empty(this.bitCount, this.wordCount);
            }
            BitSet result = BitSet.ready(this.bitCount, this.wordCount);
            for (int i = 0; i < this.words.length; ++i) {
                result.words[i] = this.words[i] & (mask.words[i] ^ 0xFFFFFFFFFFFFFFFFL);
            }
            return result;
        }

        public boolean isEmptyAfterAndNot(BitSet mask) {
            if (this.words == null) {
                return true;
            }
            for (int i = 0; i < this.words.length; ++i) {
                long word = this.words[i];
                long maskWord = mask.words[i];
                if ((word & (maskWord ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BitSet)) {
                return false;
            }
            BitSet bitSet = (BitSet)o;
            if (this.words == null || bitSet.words == null) {
                return this.isEmpty() && bitSet.isEmpty();
            }
            return Objects.deepEquals(this.words, bitSet.words);
        }

        public int hashCode() {
            if (this.isEmpty()) {
                return 0;
            }
            return Arrays.hashCode(this.words);
        }

        public String toString() {
            if (this.wordCount == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder(this.wordCount * 9);
            int leftBitCount = this.bitCount;
            if (this.words == null) {
                for (int i = 0; i < this.wordCount; ++i) {
                    for (int j = 0; j < Math.min(64, leftBitCount); ++j) {
                        sb.append("0");
                    }
                    sb.append(" ");
                    leftBitCount -= 64;
                }
            } else {
                for (long word : this.words) {
                    int wordEnd = Math.min(64, leftBitCount);
                    for (int j = 0; j < wordEnd; ++j) {
                        sb.append((word & 1L) == 1L ? "1" : "0");
                        word >>>= 1;
                    }
                    sb.append(" ");
                    leftBitCount -= 64;
                }
            }
            return sb.substring(0, sb.length() - 1);
        }

        public Iterator iterator() {
            return new Iterator();
        }

        @Generated
        private BitSet(int bitCount, int wordCount, long[] words) {
            this.bitCount = bitCount;
            this.wordCount = wordCount;
            this.words = words;
        }

        public class Iterator {
            private int wordIndex = 0;
            private int innerIndex = -1;
            private int index = -1;

            public void restart() {
                this.wordIndex = 0;
                this.innerIndex = -1;
                this.index = -1;
            }

            public boolean hasNext() {
                return this.index < BitSet.this.bitCount - 1;
            }

            public boolean next() {
                ++this.innerIndex;
                if (this.innerIndex == 64) {
                    this.innerIndex = 0;
                    ++this.wordIndex;
                }
                ++this.index;
                if (BitSet.this.words == null) {
                    return false;
                }
                return (BitSet.this.words[this.wordIndex] & 1L << this.innerIndex) != 0L;
            }

            public void set() {
                BitSet.this.cloneOnWrite();
                long[] lArray = BitSet.this.words;
                int n = this.wordIndex;
                lArray[n] = lArray[n] | 1L << this.innerIndex;
            }

            @Generated
            public int index() {
                return this.index;
            }
        }
    }

    public static class GraphCycleException
    extends Exception {
        private final Collection<Integer> cycleIndeces;

        public GraphCycleException(Collection<Integer> cycleIndeces) {
            super("Detected illegal cycle in directed graph");
            this.cycleIndeces = cycleIndeces;
        }

        @Generated
        public Collection<Integer> cycleIndeces() {
            return this.cycleIndeces;
        }

        @Override
        @Generated
        public String toString() {
            return "AcyclicGraphSorter.GraphCycleException(cycleIndeces=" + this.cycleIndeces() + ")";
        }
    }
}

