/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.typeutils.api.type;

import de.siphalor.tweed5.typeutils.api.annotations.LayeredTypeAnnotations;
import de.siphalor.tweed5.typeutils.api.type.TypeAnnotationLayer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class ActualType<T>
implements AnnotatedElement {
    private final Class<T> declaredType;
    private final @Nullable AnnotatedType usedType;
    private final @Nullable AnnotatedParameterizedType usedParameterizedType;
    private final LayeredTypeAnnotations layeredTypeAnnotations;
    private @Nullable List<ActualType<?>> resolvedParameters;

    public static <T> ActualType<T> ofClass(Class<T> clazz) {
        return new ActualType<T>(clazz, null, null, LayeredTypeAnnotations.of(TypeAnnotationLayer.TYPE_DECLARATION, clazz));
    }

    public static ActualType<?> ofUsedType(AnnotatedType annotatedType) throws UnsupportedOperationException {
        Class<?> clazz = ActualType.getDeclaredClassForUsedType(annotatedType);
        LayeredTypeAnnotations layeredTypeAnnotations = new LayeredTypeAnnotations();
        layeredTypeAnnotations.appendLayerFrom(TypeAnnotationLayer.TYPE_DECLARATION, clazz);
        layeredTypeAnnotations.appendLayerFrom(TypeAnnotationLayer.TYPE_USE, annotatedType);
        if (annotatedType instanceof AnnotatedParameterizedType) {
            return new ActualType(clazz, annotatedType, (AnnotatedParameterizedType)annotatedType, layeredTypeAnnotations);
        }
        return new ActualType(clazz, annotatedType, null, layeredTypeAnnotations);
    }

    private static Class<?> getDeclaredClassForUsedType(AnnotatedType annotatedType) throws UnsupportedOperationException {
        if (annotatedType.getType() instanceof Class) {
            return (Class)annotatedType.getType();
        }
        if (annotatedType.getType() instanceof ParameterizedType) {
            return (Class)((ParameterizedType)annotatedType.getType()).getRawType();
        }
        if (annotatedType instanceof AnnotatedWildcardType) {
            AnnotatedType[] upperBounds = ((AnnotatedWildcardType)annotatedType).getAnnotatedUpperBounds();
            if (upperBounds.length == 1) {
                return ActualType.getDeclaredClassForUsedType(upperBounds[0]);
            }
            return Object.class;
        }
        throw new UnsupportedOperationException("Failed to resolve raw class of annotated type: " + annotatedType + " (" + annotatedType.getClass() + ")");
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return this.layeredTypeAnnotations.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.layeredTypeAnnotations.getAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.layeredTypeAnnotations.getDeclaredAnnotations();
    }

    public List<ActualType<?>> parameters() {
        if (this.resolvedParameters != null) {
            return this.resolvedParameters;
        }
        if (this.usedParameterizedType == null) {
            int paramCount = this.declaredType.getTypeParameters().length;
            if (paramCount == 0) {
                this.resolvedParameters = Collections.emptyList();
            } else {
                this.resolvedParameters = new ArrayList(paramCount);
                for (int i = 0; i < paramCount; ++i) {
                    this.resolvedParameters.add(ActualType.ofClass(Object.class));
                }
            }
        } else {
            this.resolvedParameters = Arrays.stream(this.usedParameterizedType.getAnnotatedActualTypeArguments()).map(ActualType::ofUsedType).collect(Collectors.toList());
        }
        return this.resolvedParameters;
    }

    public @Nullable List<ActualType<?>> getTypesOfSuperArguments(Class<?> targetClass) {
        if (targetClass.getTypeParameters().length == 0) {
            if (targetClass.isAssignableFrom(this.declaredType)) {
                return Collections.emptyList();
            }
            return null;
        }
        ActualType<?> superType = ActualType.getViewOnSuperType(targetClass, this);
        if (superType == null) {
            return null;
        }
        return superType.parameters();
    }

    private static @Nullable ActualType<?> getViewOnSuperType(Class<?> targetClass, ActualType<?> currentType) {
        ActualType<?> superType;
        ActualType<?> resultType;
        Map<String, AnnotatedType> paramMap;
        Class<?> currentClass = currentType.declaredType();
        if (currentClass == targetClass) {
            return currentType;
        }
        if (currentClass.isPrimitive()) {
            return null;
        }
        List<ActualType<?>> currentParameters = currentType.parameters();
        if (currentParameters.isEmpty()) {
            paramMap = Collections.emptyMap();
        } else {
            paramMap = new HashMap();
            for (int i = 0; i < currentParameters.size(); ++i) {
                paramMap.put(currentClass.getTypeParameters()[i].getName(), currentParameters.get(i).usedType());
            }
        }
        if (targetClass.isInterface()) {
            for (AnnotatedType annotatedInterface : currentClass.getAnnotatedInterfaces()) {
                ActualType<?> interfaceType = ActualType.resolveTypeWithParameters(annotatedInterface, paramMap);
                ActualType<?> resultType2 = ActualType.getViewOnSuperType(targetClass, interfaceType);
                if (resultType2 == null) continue;
                return resultType2;
            }
        }
        if (currentClass != Object.class && !currentClass.isInterface() && (resultType = ActualType.getViewOnSuperType(targetClass, superType = ActualType.resolveTypeWithParameters(currentClass.getAnnotatedSuperclass(), paramMap))) != null) {
            return resultType;
        }
        return null;
    }

    private static ActualType<?> resolveTypeWithParameters(AnnotatedType annotatedType, Map<String, AnnotatedType> parameters) {
        if (annotatedType instanceof AnnotatedTypeVariable) {
            ActualType<?> actualType = ActualType.ofUsedType(parameters.get(annotatedType.getType().getTypeName()));
            actualType.layeredTypeAnnotations.appendLayerFrom(TypeAnnotationLayer.TYPE_USE, annotatedType);
            return actualType;
        }
        if (annotatedType instanceof AnnotatedParameterizedType) {
            List resolvedParameters = Arrays.stream(((AnnotatedParameterizedType)annotatedType).getAnnotatedActualTypeArguments()).map(p -> ActualType.resolveTypeWithParameters(p, parameters)).collect(Collectors.toList());
            ActualType<?> actualType = ActualType.ofUsedType(annotatedType);
            actualType.resolvedParameters = resolvedParameters;
            return actualType;
        }
        return ActualType.ofUsedType(annotatedType);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ActualType)) {
            return false;
        }
        if (this.usedParameterizedType != null) {
            return this.usedParameterizedType.equals(((ActualType)obj).usedParameterizedType);
        }
        if (this.usedType != null) {
            return this.usedType.equals(((ActualType)obj).usedType);
        }
        return this.declaredType.equals(((ActualType)obj).declaredType);
    }

    public int hashCode() {
        return this.getMostSpecificTypeObject().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.usedType != null) {
            this.appendAnnotationsToString(sb, this.usedType.getAnnotations());
        }
        sb.append(this.declaredType.getName());
        List<ActualType<?>> parameters = this.parameters();
        if (!parameters.isEmpty()) {
            sb.append("<");
            for (ActualType<?> parameter : parameters) {
                sb.append(parameter);
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(">");
        }
        return sb.toString();
    }

    private void appendAnnotationsToString(StringBuilder sb, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            sb.append(annotation);
            sb.append(' ');
        }
    }

    protected Object getMostSpecificTypeObject() {
        if (this.usedParameterizedType != null) {
            return this.usedParameterizedType;
        }
        if (this.usedType != null) {
            return this.usedType;
        }
        return this.declaredType;
    }

    @Generated
    protected ActualType(Class<T> declaredType, @Nullable AnnotatedType usedType, @Nullable AnnotatedParameterizedType usedParameterizedType, LayeredTypeAnnotations layeredTypeAnnotations) {
        this.declaredType = declaredType;
        this.usedType = usedType;
        this.usedParameterizedType = usedParameterizedType;
        this.layeredTypeAnnotations = layeredTypeAnnotations;
    }

    @Generated
    public Class<T> declaredType() {
        return this.declaredType;
    }

    @Generated
    protected @Nullable AnnotatedType usedType() {
        return this.usedType;
    }
}

