/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.utils.api.collection;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NonNull;

public class ImmutableArrayBackedSet<T>
implements SortedSet<T> {
    private final T[] values;

    public static <T extends Comparable<T>> SortedSet<T> of(Collection<T> collection) {
        if (collection.isEmpty()) {
            return Collections.emptySortedSet();
        }
        Comparable first = (Comparable)collection.iterator().next();
        return new ImmutableArrayBackedSet<Comparable>((Comparable[])collection.stream().sorted().toArray((int length) -> (Comparable[])Array.newInstance(first.getClass(), length)));
    }

    @SafeVarargs
    public static <T extends Comparable<T>> SortedSet<T> of(T ... values) {
        if (values.length == 0) {
            return Collections.emptySortedSet();
        }
        Arrays.sort(values);
        return new ImmutableArrayBackedSet<T>(values);
    }

    @Override
    @Nullable
    public Comparator<? super T> comparator() {
        return null;
    }

    @Override
    public @NonNull SortedSet<T> subSet(T fromElement, T toElement) {
        int from = Arrays.binarySearch(this.values, fromElement);
        if (from < 0) {
            from = -from - 1;
        }
        if (from == 0) {
            return this.headSet(toElement);
        }
        int to = Arrays.binarySearch(this.values, toElement);
        if (to < 0) {
            to = -to - 1;
        }
        if (to == this.values.length) {
            return this;
        }
        return new ImmutableArrayBackedSet<T>(Arrays.copyOfRange(this.values, from, to));
    }

    @Override
    public @NonNull SortedSet<T> headSet(T toElement) {
        int to = Arrays.binarySearch(this.values, toElement);
        if (to < 0) {
            to = -to - 1;
        }
        if (to == this.values.length) {
            return this;
        }
        return new ImmutableArrayBackedSet<T>(Arrays.copyOfRange(this.values, 0, to));
    }

    @Override
    public @NonNull SortedSet<T> tailSet(T fromElement) {
        int from = Arrays.binarySearch(this.values, fromElement);
        if (from < 0) {
            from = -from - 1;
        }
        if (from == 0) {
            return this;
        }
        return new ImmutableArrayBackedSet<T>(Arrays.copyOfRange(this.values, from, this.values.length));
    }

    @Override
    public T first() {
        return this.values[0];
    }

    @Override
    public T last() {
        return this.values[this.values.length - 1];
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return Arrays.binarySearch(this.values, o) >= 0;
    }

    @Override
    public @NonNull Iterator<T> iterator() {
        return Arrays.stream(this.values).iterator();
    }

    @Override
    public @NonNull Object[] toArray() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    @Override
    public <T1> @NonNull T1[] toArray(@NonNull T1[] a) {
        if (a.length < this.values.length) {
            return this.toArray();
        }
        System.arraycopy(this.values, 0, a, 0, this.values.length);
        if (a.length > this.values.length) {
            a[this.values.length] = null;
        }
        return a;
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(@NonNull Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@NonNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@NonNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Generated
    ImmutableArrayBackedSet(T[] values) {
        this.values = values;
    }
}

