/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.utils.api.collection;

import de.siphalor.tweed5.utils.api.collection.ImmutableArrayBackedSet;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.IntStream;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ImmutableArrayBackedMap<K, V>
implements SortedMap<K, V> {
    private final K[] keys;
    private final V[] values;

    public static <K extends Comparable<K>, V> SortedMap<K, V> ofEntries(Collection<Map.Entry<K, V>> entries) {
        if (entries.isEmpty()) {
            return Collections.emptySortedMap();
        }
        Map.Entry<K, V> any = entries.iterator().next();
        int size = entries.size();
        Comparable[] keys = (Comparable[])Array.newInstance(((Comparable)any.getKey()).getClass(), size);
        Object[] values = (Object[])Array.newInstance(any.getValue().getClass(), size);
        int i = 0;
        Iterator iterator = entries.stream().sorted(Map.Entry.comparingByKey()).iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            keys[i] = (Comparable)entry.getKey();
            values[i] = entry.getValue();
            ++i;
        }
        return new ImmutableArrayBackedMap<Comparable, Object>(keys, values);
    }

    @Override
    public @Nullable Comparator<? super K> comparator() {
        return null;
    }

    @Override
    public @NonNull SortedMap<K, V> subMap(K fromKey, K toKey) {
        int from = this.findKey(fromKey);
        if (from < 0) {
            from = -from - 1;
        }
        if (from == 0) {
            return this.headMap(toKey);
        }
        if (from >= this.keys.length) {
            return Collections.emptySortedMap();
        }
        int to = this.findKey(toKey, from + 1);
        if (to < 0) {
            to = -to - 1;
        }
        if (to == this.keys.length) {
            return this;
        }
        if (to == from) {
            return Collections.emptySortedMap();
        }
        return new ImmutableArrayBackedMap<K, V>(Arrays.copyOfRange(this.keys, from, to), Arrays.copyOfRange(this.values, from, to));
    }

    @Override
    public @NonNull SortedMap<K, V> headMap(K toKey) {
        int to = this.findKey(toKey);
        if (to < 0) {
            to = -to - 1;
        }
        if (to == this.keys.length) {
            return this;
        }
        if (to == 0) {
            return Collections.emptySortedMap();
        }
        return new ImmutableArrayBackedMap<K, V>(Arrays.copyOf(this.keys, to), Arrays.copyOf(this.values, to));
    }

    @Override
    public @NonNull SortedMap<K, V> tailMap(K fromKey) {
        int from = this.findKey(fromKey);
        if (from < 0) {
            from = -from - 1;
        }
        if (from == 0) {
            return this;
        }
        if (from >= this.keys.length) {
            return Collections.emptySortedMap();
        }
        return new ImmutableArrayBackedMap<K, V>(Arrays.copyOfRange(this.keys, from, this.keys.length), Arrays.copyOfRange(this.values, from, this.keys.length));
    }

    @Override
    public K firstKey() {
        return this.keys[0];
    }

    @Override
    public K lastKey() {
        return this.keys[this.keys.length - 1];
    }

    @Override
    public int size() {
        return this.keys.length;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.findKey(key) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        return Arrays.binarySearch(this.values, value) >= 0;
    }

    @Override
    public @Nullable V get(Object key) {
        int index = this.findKey(key);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    @Override
    public @Nullable V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@NonNull Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        return new ImmutableArrayBackedSet<K>(this.keys);
    }

    @Override
    public Collection<V> values() {
        return new AbstractList<V>(){

            @Override
            public V get(int index) {
                return ImmutableArrayBackedMap.this.values[index];
            }

            @Override
            public int size() {
                return ImmutableArrayBackedMap.this.values.length;
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new ImmutableArrayBackedSet<Map.Entry<K, V>>((Map.Entry[])IntStream.range(0, this.keys.length).mapToObj(index -> new AbstractMap.SimpleEntry<K, V>(this.keys[index], this.values[index])).toArray(Map.Entry[]::new));
    }

    private int findKey(Object key) {
        return Arrays.binarySearch(this.keys, key);
    }

    private int findKey(Object key, int from) {
        return Arrays.binarySearch(this.keys, from, this.keys.length, key);
    }

    @Generated
    ImmutableArrayBackedMap(K[] keys, V[] values) {
        this.keys = keys;
        this.values = values;
    }
}

