/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.utils.api.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class ClassToInstancesMultimap<T>
implements Collection<T> {
    private static final ClassToInstancesMultimap<Object> EMPTY = ClassToInstancesMultimap.unmodifiable(new ClassToInstancesMultimap(Collections.emptyMap(), ArrayList::new));
    protected final Map<Class<? extends T>, Collection<T>> delegate;
    protected final Supplier<Collection<T>> collectionSupplier;

    public static <T> ClassToInstancesMultimap<T> unmodifiable(ClassToInstancesMultimap<T> map) {
        return new Unmodifiable<T>(map.delegate, map.collectionSupplier);
    }

    public static <T> ClassToInstancesMultimap<T> empty() {
        return EMPTY;
    }

    @Override
    public int size() {
        return (int)this.delegate.values().stream().mapToLong(Collection::size).sum();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return ((Collection)this.delegate.getOrDefault(o.getClass(), Collections.emptyList())).contains(o);
    }

    public Set<Class<? extends T>> classes() {
        return this.delegate.keySet();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final Iterator<Map.Entry<Class<? extends T>, Collection<T>>> classIterator;
            private @Nullable Iterator<? extends T> listIterator;
            private boolean keptElement;
            private boolean keptAnyElementInList;
            {
                this.classIterator = ClassToInstancesMultimap.this.delegate.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.classIterator.hasNext() || this.listIterator != null && this.listIterator.hasNext();
            }

            @Override
            public T next() {
                if (this.keptElement) {
                    this.keptAnyElementInList = true;
                }
                if (this.listIterator == null || !this.listIterator.hasNext()) {
                    if (this.listIterator != null && !this.keptAnyElementInList) {
                        this.classIterator.remove();
                    }
                    this.listIterator = this.classIterator.next().getValue().iterator();
                    this.keptAnyElementInList = false;
                }
                this.keptElement = true;
                return this.listIterator.next();
            }

            @Override
            public void remove() {
                if (this.listIterator == null) {
                    throw new IllegalStateException("Iterator has not been called");
                }
                this.keptElement = false;
                this.listIterator.remove();
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.delegate.values().stream().flatMap(Collection::stream).toArray();
    }

    @Override
    public <S> S[] toArray(S[] array) {
        Class<?> clazz = array.getClass().getComponentType();
        return this.delegate.values().stream().flatMap(Collection::stream).toArray((int size) -> (Object[])Array.newInstance(clazz, size));
    }

    @Override
    public boolean add(T value) {
        return this.delegate.computeIfAbsent(value.getClass(), clazz -> this.collectionSupplier.get()).add(value);
    }

    @Override
    public boolean remove(Object value) {
        Collection<T> values = this.delegate.get(value.getClass());
        if (values == null) {
            return false;
        }
        if (values.remove(value)) {
            if (values.isEmpty()) {
                this.delegate.remove(value.getClass());
            }
            return true;
        }
        return false;
    }

    public <U extends T> Collection<U> getAll(Class<U> clazz) {
        return Collections.unmodifiableCollection(this.delegate.getOrDefault(clazz, Collections.emptyList()));
    }

    public Collection<T> removeAll(Class<? extends T> clazz) {
        Collection<T> removed = this.delegate.remove(clazz);
        return removed == null ? Collections.emptyList() : Collections.unmodifiableCollection(removed);
    }

    @Override
    public boolean containsAll(Collection<?> values) {
        for (Object value : values) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> values) {
        boolean changed = false;
        for (T value : values) {
            changed = this.add(value) || changed;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> values) {
        boolean changed = false;
        for (Object value : values) {
            changed = this.remove(value) || changed;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> values) {
        Map<Class, List<Object>> valuesByClass = values.stream().collect(Collectors.groupingBy(Object::getClass));
        this.delegate.putAll(valuesByClass);
        this.delegate.keySet().removeIf(key -> !valuesByClass.containsKey(key));
        return true;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Generated
    public ClassToInstancesMultimap(Map<Class<? extends T>, Collection<T>> delegate, Supplier<Collection<T>> collectionSupplier) {
        this.delegate = delegate;
        this.collectionSupplier = collectionSupplier;
    }

    protected static class Unmodifiable<T>
    extends ClassToInstancesMultimap<T> {
        public Unmodifiable(Map<Class<? extends T>, Collection<T>> delegate, Supplier<Collection<T>> collectionSupplier) {
            super(delegate, collectionSupplier);
        }

        @Override
        public Iterator<T> iterator() {
            return this.delegate.values().stream().flatMap(Collection::stream).iterator();
        }

        @Override
        public boolean add(T value) {
            throw this.createUnsupportedOperationException();
        }

        @Override
        public boolean remove(Object value) {
            throw this.createUnsupportedOperationException();
        }

        @Override
        public Collection<T> removeAll(Class<? extends T> clazz) {
            throw this.createUnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends T> values) {
            throw this.createUnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> values) {
            throw this.createUnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> values) {
            throw this.createUnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw this.createUnsupportedOperationException();
        }

        protected UnsupportedOperationException createUnsupportedOperationException() {
            return new UnsupportedOperationException("Map is unmodifiable");
        }
    }
}

