/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui.widget.data;

public interface Color {
    public static final Color WHITE = Color.rgb(-1);
    public static final Color BLACK = Color.rgb(-16777216);
    public static final Color RED = Color.rgb(-65536);
    public static final Color GREEN = Color.rgb(-16711936);
    public static final Color BLUE = Color.rgb(-16776961);
    public static final Color WHITE_DYE = Color.rgb(-393218);
    public static final Color ORANGE_DYE = Color.rgb(-425955);
    public static final Color MAGENTA_DYE = Color.rgb(-3715395);
    public static final Color LIGHT_BLUE_DYE = Color.rgb(-12930086);
    public static final Color YELLOW_DYE = Color.rgb(-75715);
    public static final Color LIME_DYE = Color.rgb(-8337633);
    public static final Color PINK_DYE = Color.rgb(-816214);
    public static final Color GRAY_DYE = Color.rgb(-12103854);
    public static final Color LIGHT_GRAY_DYE = Color.rgb(-6447721);
    public static final Color CYAN_DYE = Color.rgb(-15295332);
    public static final Color PURPLE_DYE = Color.rgb(-7785800);
    public static final Color BLUE_DYE = Color.rgb(-12827478);
    public static final Color BROWN_DYE = Color.rgb(-8170446);
    public static final Color GREEN_DYE = Color.rgb(-10585066);
    public static final Color RED_DYE = Color.rgb(-5231066);
    public static final Color BLACK_DYE = Color.rgb(-14869215);
    public static final Color[] DYE_COLORS = new Color[]{WHITE_DYE, ORANGE_DYE, MAGENTA_DYE, LIGHT_BLUE_DYE, YELLOW_DYE, LIME_DYE, PINK_DYE, GRAY_DYE, LIGHT_GRAY_DYE, CYAN_DYE, PURPLE_DYE, BLUE_DYE, BROWN_DYE, GREEN_DYE, RED_DYE, BLACK_DYE};

    public int toRgb();

    public static Color rgb(int value) {
        return new RGB(value);
    }

    public static Color rgb(int a, int r, int g, int b) {
        return new RGB(a, r, g, b);
    }

    public static Color opaqueRgb(int value) {
        return new RGB(value | 0xFF000000);
    }

    public static class RGB
    implements Color {
        private final int value;

        public RGB(int value) {
            this.value = value;
        }

        public RGB(int a, int r, int g, int b) {
            this.value = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }

        public RGB(int r, int g, int b) {
            this.value = 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }

        @Override
        public int toRgb() {
            return this.value;
        }

        public int getA() {
            return this.value >> 24 & 0xFF;
        }

        public int getR() {
            return this.value >> 16 & 0xFF;
        }

        public int getG() {
            return this.value >> 8 & 0xFF;
        }

        public int getB() {
            return this.value & 0xFF;
        }

        public int getChroma() {
            int r = this.getR();
            int g = this.getG();
            int b = this.getB();
            int max = Math.max(Math.max(r, g), b);
            int min = Math.min(Math.min(r, g), b);
            return max - min;
        }

        public int getHue() {
            float min;
            float r = (float)this.getR() / 255.0f;
            float g = (float)this.getG() / 255.0f;
            float b = (float)this.getB() / 255.0f;
            float max = Math.max(Math.max(r, g), b);
            float chroma = max - (min = Math.min(Math.min(r, g), b));
            if (chroma == 0.0f) {
                return 0;
            }
            if (max >= r) {
                return (int)((g - b) / chroma % 6.0f * 60.0f);
            }
            if (max >= g) {
                return (int)(((b - r) / chroma + 2.0f) * 60.0f);
            }
            if (max >= b) {
                return (int)(((r - g) / chroma + 4.0f) * 60.0f);
            }
            return 0;
        }

        public int getLightness() {
            int r = this.getR();
            int g = this.getG();
            int b = this.getB();
            int max = Math.max(Math.max(r, g), b);
            int min = Math.min(Math.min(r, g), b);
            return (max + min) / 2;
        }

        public int getLuma() {
            float r = (float)this.getR() / 255.0f;
            float g = (float)this.getG() / 255.0f;
            float b = (float)this.getB() / 255.0f;
            return (int)((0.2126f * r + 0.7152f * g + 0.0722f * b) * 255.0f);
        }

        public int getValue() {
            int r = this.getR();
            int g = this.getG();
            int b = this.getB();
            return Math.max(Math.max(r, g), b);
        }

        public float getHSVSaturation() {
            float v = this.getValue();
            if (v == 0.0f) {
                return 0.0f;
            }
            float c = this.getChroma();
            return c / v;
        }

        public float getHSLSaturation() {
            float l = (float)this.getLuma() / 255.0f;
            if (l == 0.0f || l == 1.0f) {
                return 0.0f;
            }
            float c = (float)this.getChroma() / 255.0f;
            return c / (1.0f - Math.abs(2.0f * l - 1.0f));
        }

        public RGB interpolate(RGB endColor, double t) {
            double a = (double)(endColor.getA() - this.getA()) * t + (double)this.getA();
            double r = (double)(endColor.getR() - this.getR()) * t + (double)this.getR();
            double g = (double)(endColor.getG() - this.getG()) * t + (double)this.getG();
            double b = (double)(endColor.getB() - this.getB()) * t + (double)this.getB();
            return new RGB((int)a, (int)r, (int)g, (int)b);
        }
    }

    public static class LCH
    implements Color {
        private float luma;
        private float chroma;
        private float hue;

        public LCH(float luma, float chroma, float hue) {
            this.luma = luma;
            this.chroma = chroma;
            this.hue = hue;
        }

        @Override
        public int toRgb() {
            return 0;
        }

        public float getHue() {
            return this.hue;
        }

        public float getChroma() {
            return this.chroma;
        }

        public float getLuma() {
            return this.luma;
        }
    }

    public static class HSL
    implements Color {
        private float hue;
        private float sat;
        private float luma;

        public HSL(float hue, float sat, float luma) {
            this.hue = hue;
            this.sat = sat;
            this.luma = luma;
        }

        public HSL(int rgb) {
            float r = HSL.i_f(rgb >> 16);
            float g = HSL.i_f(rgb >> 8);
            float b = HSL.i_f(rgb);
            float max = Math.max(r, Math.max(g, b));
            float min = Math.min(r, Math.min(g, b));
            this.hue = 0.0f;
            if (max == min) {
                this.hue = 0.0f;
            } else if (max == r) {
                this.hue = (g - b) / (max - min);
                this.hue *= 0.16666667f;
            } else if (max == g) {
                this.hue = 2.0f + (b - r) / (max - min);
                this.hue *= 0.16666667f;
            } else {
                this.hue = 4.0f + (r - g) / (max - min);
                this.hue *= 0.16666667f;
            }
            if (this.hue < 0.0f) {
                this.hue += 1.0f;
            }
            this.luma = (max + min) / 2.0f;
            this.sat = 0.0f;
            if (max != 0.0f && min != 1.0f) {
                this.sat = (max - this.luma) / Math.min(this.luma, 1.0f - this.luma);
            }
        }

        @Override
        public int toRgb() {
            float chroma = (1.0f - Math.abs(2.0f * this.luma - 1.0f)) * this.sat;
            int h = (int)(this.hue * 6.0f);
            h %= 6;
            float x = 1.0f - Math.abs(this.hue * 6.0f % 2.0f - 1.0f);
            x *= chroma;
            float m = this.luma - chroma / 2.0f;
            while (h < 0) {
                h += 6;
            }
            if (h >= 6) {
                h %= 6;
            }
            float rf = 0.0f;
            float gf = 0.0f;
            float bf = 0.0f;
            switch (h) {
                case 0: {
                    rf = chroma + m;
                    gf = x + m;
                    bf = 0.0f + m;
                    break;
                }
                case 1: {
                    rf = x + m;
                    gf = chroma + m;
                    bf = 0.0f + m;
                    break;
                }
                case 2: {
                    rf = 0.0f + m;
                    gf = chroma + m;
                    bf = x + m;
                    break;
                }
                case 3: {
                    rf = 0.0f + m;
                    gf = x + m;
                    bf = chroma + m;
                    break;
                }
                case 4: {
                    rf = x + m;
                    gf = 0.0f + m;
                    bf = chroma + m;
                    break;
                }
                case 5: {
                    rf = chroma + m;
                    gf = 0.0f + m;
                    bf = x + m;
                }
            }
            int r = HSL.f_255(rf);
            int g = HSL.f_255(gf);
            int b = HSL.f_255(bf);
            return 0xFF000000 | r << 16 | g << 8 | b;
        }

        public float getHue() {
            return this.hue;
        }

        public float getSaturation() {
            return this.sat;
        }

        public float getLuma() {
            return this.luma;
        }

        private static int f_255(float f) {
            int result = (int)(f * 255.0f);
            return Math.min(255, Math.max(0, result));
        }

        private static float i_f(int i) {
            return (float)(i & 0xFF) / 255.0f;
        }
    }
}

