/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui.widget;

import dev.tr7zw.transition.mc.ComponentProvider;
import dev.tr7zw.transition.mc.MathUtil;
import dev.tr7zw.trender.gui.client.RenderContext;
import dev.tr7zw.trender.gui.client.ScreenDrawing;
import dev.tr7zw.trender.gui.impl.client.NarrationMessages;
import dev.tr7zw.trender.gui.impl.client.WidgetSprites;
import dev.tr7zw.trender.gui.impl.client.style.WidgetTextures;
import dev.tr7zw.trender.gui.widget.WAbstractIntSlider;
import dev.tr7zw.trender.gui.widget.data.Axis;
import dev.tr7zw.trender.gui.widget.data.HorizontalAlignment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class WLabeledIntSlider
extends WAbstractIntSlider {
    @Nullable
    private class_2561 label = null;
    @Nullable
    private LabelUpdater labelUpdater = null;
    private HorizontalAlignment labelAlignment = HorizontalAlignment.CENTER;

    public WLabeledIntSlider(int min, int max) {
        this(min, max, Axis.HORIZONTAL);
    }

    public WLabeledIntSlider(int min, int max, Axis axis) {
        super(min, max, axis);
    }

    public WLabeledIntSlider(int min, int max, Axis axis, @Nullable class_2561 label) {
        this(min, max, axis);
        this.label = label;
    }

    public WLabeledIntSlider(int min, int max, @Nullable class_2561 label) {
        this(min, max);
        this.label = label;
    }

    @Nullable
    public class_2561 getLabel() {
        return this.label;
    }

    public void setLabel(@Nullable class_2561 label) {
        this.label = label;
    }

    @Override
    protected void onValueChanged(int value) {
        super.onValueChanged(value);
        if (this.labelUpdater != null) {
            this.label = this.labelUpdater.updateLabel(value);
        }
    }

    public HorizontalAlignment getLabelAlignment() {
        return this.labelAlignment;
    }

    public void setLabelAlignment(HorizontalAlignment labelAlignment) {
        this.labelAlignment = labelAlignment;
    }

    @Nullable
    public LabelUpdater getLabelUpdater() {
        return this.labelUpdater;
    }

    public void setLabelUpdater(@Nullable LabelUpdater labelUpdater) {
        this.labelUpdater = labelUpdater;
        if (labelUpdater != null) {
            this.label = labelUpdater.updateLabel(this.value);
        }
    }

    @Override
    protected int getThumbWidth() {
        return 8;
    }

    @Override
    protected boolean isMouseInsideBounds(int x, int y) {
        return x >= 0 && x <= this.getWidth() && y >= 0 && y <= this.getHeight();
    }

    @Override
    public void paint(RenderContext context, int x, int y, int mouseX, int mouseY) {
        int aHeight;
        int aWidth = this.axis == Axis.HORIZONTAL ? this.getWidth() : this.getHeight();
        int n = aHeight = this.axis == Axis.HORIZONTAL ? this.getHeight() : this.getWidth();
        int rotMouseX = this.axis == Axis.HORIZONTAL ? (this.direction == WAbstractIntSlider.Direction.LEFT ? this.getWidth() - mouseX : mouseX) : (this.direction == WAbstractIntSlider.Direction.UP ? this.getHeight() - mouseY : mouseY);
        int rotMouseY = this.axis == Axis.HORIZONTAL ? mouseY : mouseX;
        context.pushPose();
        context.translate(x, y);
        if (this.axis == Axis.VERTICAL) {
            context.translate(0.0f, this.getHeight());
            context.rotate(MathUtil.ZP.rotationDegrees(270.0f));
        }
        WidgetSprites background = WidgetTextures.getValueSliderTexture().get();
        context.blitSprite(this.isFocused() ? background.enabledFocused() : background.enabled(), 0, 0, aWidth, aHeight, 4, 4, 16, 16);
        int thumbX = Math.round(this.coordToValueRatio * (float)(this.value - this.min));
        int thumbY = 0;
        int thumbWidth = this.getThumbWidth();
        int thumbHeight = aHeight;
        boolean hovering = rotMouseX >= thumbX && rotMouseX <= thumbX + thumbWidth && rotMouseY >= thumbY && rotMouseY <= thumbY + thumbHeight;
        WidgetSprites thumbTextures = WidgetTextures.getLabeledSliderHandleTextures().get();
        class_2960 thumbTexture = thumbTextures.get(true, this.dragging || hovering);
        context.blitSprite(thumbTexture, thumbX, thumbY, thumbWidth, thumbHeight, 2, 2, 8, 20);
        if (this.label != null) {
            int color = this.isMouseInsideBounds(mouseX, mouseY) ? -96 : -2039584;
            ScreenDrawing.drawStringWithShadow(context, this.label.method_30937(), this.labelAlignment, 2, aHeight / 2 - 4, aWidth - 4, color);
        }
        context.popPose();
    }

    @Override
    public void addNarrations(class_6382 builder) {
        if (this.getLabel() != null) {
            builder.method_37034(class_6381.field_33788, (class_2561)ComponentProvider.translatable((String)"widget.libgui.labeled_slider.narration.title", (Object[])new Object[]{this.getLabel(), this.value, this.min, this.max}));
            builder.method_37034(class_6381.field_33791, NarrationMessages.SLIDER_USAGE);
        } else {
            super.addNarrations(builder);
        }
    }

    @FunctionalInterface
    public static interface LabelUpdater {
        public class_2561 updateLabel(int var1);
    }
}

