/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui.widget;

import com.google.common.collect.ImmutableList;
import dev.tr7zw.trender.gui.client.RenderContext;
import dev.tr7zw.trender.gui.widget.WWidget;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class WItem
extends WWidget {
    private List<class_1799> items;
    private int duration = 25;
    private int ticks = 0;
    private int current = 0;

    public WItem(List<class_1799> items) {
        this.setItems(items);
    }

    public WItem(class_6862<? extends class_1935> tag) {
        this(WItem.getRenderStacks(tag));
    }

    public WItem(class_1799 stack) {
        this(Collections.singletonList(stack));
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public void tick() {
        if (this.ticks++ >= this.duration) {
            this.ticks = 0;
            this.current = (this.current + 1) % this.items.size();
        }
    }

    @Override
    public void paint(RenderContext context, int x, int y, int mouseX, int mouseY) {
        context.renderFakeItem(this.items.get(this.current), x + this.getWidth() / 2 - 8, y + this.getHeight() / 2 - 8);
    }

    public int getDuration() {
        return this.duration;
    }

    public WItem setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public List<class_1799> getItems() {
        return this.items;
    }

    public WItem setItems(List<class_1799> items) {
        Objects.requireNonNull(items, "stacks == null!");
        if (items.isEmpty()) {
            throw new IllegalArgumentException("The stack list is empty!");
        }
        this.items = items;
        this.current = 0;
        this.ticks = 0;
        return this;
    }

    private static List<class_1799> getRenderStacks(class_6862<? extends class_1935> tag) {
        class_2378 registry = (class_2378)class_7923.field_41167.method_63535(tag.comp_326().method_29177());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (class_6880 item : registry.method_40286(tag)) {
            builder.add((Object)((class_1935)item.comp_349()).method_8389().method_7854());
        }
        return builder.build();
    }
}

