/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui.widget;

import dev.tr7zw.trender.gui.client.RenderContext;
import dev.tr7zw.trender.gui.client.ScreenDrawing;
import dev.tr7zw.trender.gui.impl.client.TextAlignment;
import dev.tr7zw.trender.gui.widget.WWidget;
import dev.tr7zw.trender.gui.widget.data.HorizontalAlignment;
import dev.tr7zw.trender.gui.widget.data.VerticalAlignment;
import java.util.function.Supplier;

public class WDynamicLabel
extends WWidget {
    protected Supplier<String> text;
    protected HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    protected VerticalAlignment verticalAlignment = VerticalAlignment.TOP;
    protected int color;
    protected boolean drawShadows;

    public WDynamicLabel(Supplier<String> text, int color) {
        this.text = text;
        this.color = color;
    }

    public WDynamicLabel(Supplier<String> text) {
        this(text, -12566464);
    }

    @Override
    public void paint(RenderContext context, int x, int y, int mouseX, int mouseY) {
        int yOffset = TextAlignment.getTextOffsetY(this.verticalAlignment, this.getHeight(), 1);
        String tr = this.text.get();
        if (this.getDrawShadows()) {
            ScreenDrawing.drawStringWithShadow(context, tr, this.horizontalAlignment, x, y + yOffset, this.getWidth(), this.color);
        } else {
            ScreenDrawing.drawString(context, tr, this.horizontalAlignment, x, y + yOffset, this.getWidth(), this.color);
        }
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public void setSize(int x, int y) {
        super.setSize(x, 20);
    }

    public boolean getDrawShadows() {
        return this.drawShadows;
    }

    public WDynamicLabel setDrawShadows(boolean drawShadows) {
        this.drawShadows = drawShadows;
        return this;
    }

    public WDynamicLabel setText(Supplier<String> text) {
        this.text = text;
        return this;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public WDynamicLabel setHorizontalAlignment(HorizontalAlignment align) {
        this.horizontalAlignment = align;
        return this;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public WDynamicLabel setVerticalAlignment(VerticalAlignment align) {
        this.verticalAlignment = align;
        return this;
    }
}

