/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui.impl.client;

import dev.tr7zw.trender.gui.widget.WPanel;
import dev.tr7zw.trender.gui.widget.WWidget;
import dev.tr7zw.trender.gui.widget.data.Rect2i;
import dev.tr7zw.trender.gui.widget.focus.Focus;
import dev.tr7zw.trender.gui.widget.focus.FocusModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;

public final class FocusElements {
    public static PanelFocusElement ofPanel(WPanel panel) {
        PanelFocusElement result = new PanelFocusElement(panel);
        result.refreshChildren();
        return result;
    }

    public static Stream<FocusElement<?>> toElements(WWidget widget) {
        if (widget instanceof WPanel) {
            WPanel panel = (WPanel)widget;
            return Stream.of(FocusElements.ofPanel(panel));
        }
        return FocusElements.fromFoci(widget);
    }

    private static Stream<FocusElement<?>> fromFoci(WWidget widget) {
        @Nullable FocusModel<?> focusModel = widget.getFocusModel();
        if (focusModel == null) {
            return Stream.empty();
        }
        return focusModel.foci().map(focus -> new LeafFocusElement(widget, (Focus<?>)focus));
    }

    private static final class PanelFocusElement
    extends class_362
    implements FocusElement<WPanel> {
        private final List<FocusElement<?>> children = new ArrayList();
        private final WPanel widget;
        private List<WWidget> childWidgets;

        private PanelFocusElement(WPanel widget) {
            this.widget = widget;
        }

        private void refreshChildren() {
            boolean shouldRefresh = false;
            if (this.childWidgets == null) {
                this.childWidgets = this.widget.streamChildren().toList();
                shouldRefresh = true;
            } else {
                List<WWidget> currentChildren = this.widget.streamChildren().toList();
                if (!this.childWidgets.equals(currentChildren)) {
                    this.childWidgets = currentChildren;
                    shouldRefresh = true;
                }
            }
            if (shouldRefresh) {
                this.children.clear();
                FocusElements.fromFoci(this.widget).forEach(this.children::add);
                this.childWidgets.stream().flatMap(FocusElements::toElements).forEach(this.children::add);
                this.refreshFocus();
            }
        }

        public List<FocusElement<?>> method_25396() {
            this.refreshChildren();
            return this.children;
        }

        @Override
        public WPanel widget() {
            return this.widget;
        }

        @Nullable
        public class_364 method_25399() {
            this.refreshFocus();
            return super.method_25399();
        }

        public void refreshFocus() {
            if (this.children.isEmpty()) {
                return;
            }
            boolean foundFocus = false;
            for (FocusElement<?> child : this.children) {
                if (child instanceof PanelFocusElement) {
                    PanelFocusElement panel = (PanelFocusElement)child;
                    panel.refreshFocus();
                }
                if (foundFocus || !child.method_25370()) continue;
                this.method_25395(child);
                foundFocus = true;
            }
        }
    }

    private record LeafFocusElement(WWidget widget, Focus<?> focus) implements FocusElement<WWidget>
    {
        public void method_25365(boolean focused) {
            if (focused) {
                Focus<?> focus = this.focus();
                if (focus != null) {
                    this.widget.requestFocus();
                    this.widget.getFocusModel().setFocused(focus);
                }
            } else {
                this.widget.releaseFocus();
            }
        }

        public boolean method_25370() {
            FocusModel<?> focusModel;
            if (this.widget.isFocused() && (focusModel = this.widget.getFocusModel()) != null) {
                return focusModel.isFocused(this.focus);
            }
            return false;
        }

        public class_8030 method_48202() {
            Rect2i area = this.focus.area();
            return new class_8030(this.widget.getAbsoluteX() + area.x(), this.widget.getAbsoluteY() + area.y(), area.width(), area.height());
        }

        @Nullable
        public class_8016 method_48205(class_8023 navigation) {
            return this.widget.canFocus() && !this.method_25370() ? class_8016.method_48193((class_364)this) : null;
        }
    }

    public static sealed interface FocusElement<W extends WWidget>
    extends class_364
    permits LeafFocusElement, PanelFocusElement {
        public W widget();
    }
}

