/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui.client;

import dev.tr7zw.transition.mc.ComponentProvider;
import dev.tr7zw.trender.gui.client.CottonClientScreen;
import dev.tr7zw.trender.gui.client.LightweightGuiDescription;
import dev.tr7zw.trender.gui.widget.WButton;
import dev.tr7zw.trender.gui.widget.WGridPanel;
import dev.tr7zw.trender.gui.widget.WLabel;
import dev.tr7zw.trender.gui.widget.WLabeledDoubleSlider;
import dev.tr7zw.trender.gui.widget.WLabeledIntSlider;
import dev.tr7zw.trender.gui.widget.WListPanel;
import dev.tr7zw.trender.gui.widget.WToggleButton;
import dev.tr7zw.trender.gui.widget.data.Insets;
import java.lang.runtime.SwitchBootstraps;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public abstract class AbstractConfigScreen
extends LightweightGuiDescription {
    protected static final DecimalFormat DECIMAL_FORMATTER = new DecimalFormat("###.##");
    private final class_437 previous;
    private final class_2561 title;

    public AbstractConfigScreen(class_2561 title, class_437 previous) {
        this.previous = previous;
        this.title = title;
    }

    public class_437 createScreen() {
        return new CottonClientScreen(this.title, this){

            public void method_25419() {
                AbstractConfigScreen.this.save();
                this.field_22787.method_1507(AbstractConfigScreen.this.previous);
            }
        };
    }

    public abstract void save();

    public abstract void reset();

    public WListPanel<OptionInstance, WGridPanel> createOptionList(List<OptionInstance> options) {
        return new WListPanel<OptionInstance, WGridPanel>(options, () -> new WGridPanel(), (option, panel) -> {
            panel.setInsets(new Insets(0, 2, 0, 0));
            OptionInstance optionInstance = option;
            Objects.requireNonNull(optionInstance);
            OptionInstance selector0$temp = optionInstance;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OptionInstance.Toggle.class, OptionInstance.DoubleOption.class, OptionInstance.IntOption.class, OptionInstance.EnumOption.class, OptionInstance.SplitLine.class}, (Object)selector0$temp, index$1)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    OptionInstance.Toggle toggle = (OptionInstance.Toggle)selector0$temp;
                    WToggleButton tb = new WToggleButton((class_2561)ComponentProvider.translatable((String)toggle.translationKey()));
                    tb.setToggle(toggle.current.get());
                    tb.setOnRefresh(() -> tb.setToggle(toggle.current.get()));
                    tb.setOnToggle(toggle.update);
                    tb.setToolip(AbstractConfigScreen.getOptionalTooltip(toggle.translationKey()));
                    panel.add(tb, 0, 0, 10, 1);
                    break;
                }
                case 1: {
                    OptionInstance.DoubleOption dblo = (OptionInstance.DoubleOption)selector0$temp;
                    WLabeledDoubleSlider slider = new WLabeledDoubleSlider(dblo.min(), dblo.max(), dblo.steps());
                    slider.setValue(dblo.current().getAsDouble());
                    slider.setOnRefresh(() -> {
                        slider.setValue(dblo.current().getAsDouble());
                        slider.setLabel(slider.getLabelUpdater().updateLabel(slider.getValue()));
                    });
                    slider.setValueChangeListener(dblo.update());
                    slider.setLabelUpdater(d -> ComponentProvider.translatable((String)dblo.translationKey()).method_27693(": " + DECIMAL_FORMATTER.format(d)));
                    slider.setToolip(AbstractConfigScreen.getOptionalTooltip(dblo.translationKey()));
                    slider.setIgnoreScrolling(true);
                    panel.add(slider, 0, 0, 10, 1);
                    break;
                }
                case 2: {
                    OptionInstance.IntOption dblo = (OptionInstance.IntOption)selector0$temp;
                    WLabeledIntSlider slider = new WLabeledIntSlider(dblo.min(), dblo.max());
                    slider.setValue(dblo.current().getAsInt());
                    slider.setOnRefresh(() -> {
                        slider.setValue(dblo.current().getAsInt());
                        slider.setLabel(slider.getLabelUpdater().updateLabel(slider.getValue()));
                    });
                    slider.setValueChangeListener(dblo.update());
                    slider.setLabelUpdater(d -> ComponentProvider.translatable((String)dblo.translationKey()).method_27693(": " + d));
                    slider.setToolip(AbstractConfigScreen.getOptionalTooltip(dblo.translationKey()));
                    slider.setIgnoreScrolling(true);
                    panel.add(slider, 0, 0, 10, 1);
                    break;
                }
                case 3: {
                    OptionInstance.EnumOption enm = (OptionInstance.EnumOption)selector0$temp;
                    WButton tb = new WButton((class_2561)ComponentProvider.translatable((String)(enm.translationKey() + "." + ((Enum)enm.current().get()).name())));
                    tb.setOnClick(() -> {
                        Enum cur = (Enum)enm.current().get();
                        List<Enum> values = Arrays.asList((Enum[])enm.targetEnum().getEnumConstants());
                        int id = (values.indexOf(cur) + 1) % values.size();
                        enm.update().accept(values.get(id));
                        tb.setLabel((class_2561)ComponentProvider.translatable((String)(enm.translationKey() + "." + ((Enum)enm.current().get()).name())));
                    });
                    tb.setOnRefresh(() -> tb.setLabel((class_2561)ComponentProvider.translatable((String)(enm.translationKey() + "." + ((Enum)enm.current().get()).name()))));
                    tb.setToolip(AbstractConfigScreen.getOptionalTooltip(enm.translationKey()));
                    WLabel label = new WLabel((class_2561)ComponentProvider.translatable((String)enm.translationKey()));
                    panel.setGaps(-13, -13);
                    panel.add(label, 0, 1);
                    panel.add(tb, (int)((double)class_310.method_1551().field_1772.method_27525((class_5348)label.getText()) / 4.7), 0, 18, 1);
                    break;
                }
                case 4: {
                    OptionInstance.SplitLine line = (OptionInstance.SplitLine)selector0$temp;
                    WLabel label = new WLabel((class_2561)ComponentProvider.translatable((String)line.translationKey()));
                    panel.setInsets(new Insets(6, 3, 0, 0));
                    panel.add(label, 0, 0, 10, 1);
                }
            }
        });
    }

    public OptionInstance getBooleanOption(String translationKey, Supplier<Boolean> current, Consumer<Boolean> update) {
        return new OptionInstance.Toggle(translationKey, current, update);
    }

    public OptionInstance getOnOffOption(String translationKey, Supplier<Boolean> current, Consumer<Boolean> update) {
        return this.getBooleanOption(translationKey, current, update);
    }

    public OptionInstance getDoubleOption(String translationKey, double min, double max, double steps, DoubleSupplier current, DoubleConsumer update) {
        return new OptionInstance.DoubleOption(translationKey, min, max, steps, current, update);
    }

    public OptionInstance getIntOption(String translationKey, int min, int max, IntSupplier current, IntConsumer update) {
        return new OptionInstance.IntOption(translationKey, min, max, current, update);
    }

    public <T extends Enum> OptionInstance getEnumOption(String translationKey, Class<T> targetEnum, Supplier<T> current, Consumer<T> update) {
        return new OptionInstance.EnumOption<T>(translationKey, targetEnum, current, update);
    }

    public OptionInstance.SplitLine getSplitLine(String translationKey) {
        return new OptionInstance.SplitLine(translationKey);
    }

    private static class_2561 getOptionalTooltip(String translationKey) {
        class_5250 comp;
        String key = translationKey + ".tooltip";
        if (key.equals((comp = ComponentProvider.translatable((String)key)).getString())) {
            return null;
        }
        return comp;
    }

    public static sealed interface OptionInstance {

        public record SplitLine(String translationKey) implements OptionInstance
        {
        }

        public record EnumOption<T extends Enum>(String translationKey, Class<T> targetEnum, Supplier<T> current, Consumer<Object> update) implements OptionInstance
        {
        }

        public record IntOption(String translationKey, int min, int max, IntSupplier current, IntConsumer update) implements OptionInstance
        {
        }

        public record DoubleOption(String translationKey, double min, double max, double steps, DoubleSupplier current, DoubleConsumer update) implements OptionInstance
        {
        }

        public record Toggle(String translationKey, Supplier<Boolean> current, Consumer<Boolean> update) implements OptionInstance
        {
        }
    }
}

