/*
 * Decompiled with CFR 0.152.
 */
package net.tschipcraft.dynamiclights.forge;

import eu.midnightdust.lib.config.MidnightConfig;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.tschipcraft.dynamiclights.forge.Config;
import net.tschipcraft.dynamiclights.forge.sendConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="dynamiclights")
@Mod.EventBusSubscriber(modid="dynamiclights")
public class Init {
    public static final String MODID = "dynamiclights";
    private static Logger LOGGER;

    public Init() {
        block3: {
            IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
            modEventBus.addListener(this::setup);
            try {
                if (LOGGER != null) {
                    LOGGER.info("[Dynamic Lights] Registering server started event ...");
                }
                Class.forName("net.minecraftforge.event.server.ServerStartedEvent");
                MinecraftForge.EVENT_BUS.register(new Object(){

                    @SubscribeEvent
                    public void onServerStarted(ServerStartedEvent event) {
                        if (ModList.get().isLoaded("midnightlib")) {
                            LOGGER.info("[Dynamic Lights] Sending global config to world ...");
                            sendConfig.sendConfig(event.getServer());
                        }
                    }
                });
            }
            catch (ClassNotFoundException e) {
                if (LOGGER == null) break block3;
                LOGGER.info("[Dynamic Lights] ServerStartedEvent not found, not registering event handler.");
            }
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        if (ModList.get().isLoaded("midnightlib")) {
            LOGGER.info("[Dynamic Lights] MidnightLib detected!");
            Config.init((String)MODID, Config.class);
            ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, parent) -> MidnightConfig.getScreen((Screen)parent, (String)MODID)));
        }
        if (LOGGER != null) {
            LOGGER.info("[Dynamic Lights] Loaded Dynamic Lights by Tschipcraft successfully!");
        }
    }

    static {
        try {
            LOGGER = LoggerFactory.getLogger((String)MODID);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

