/*
 * Decompiled with CFR 0.152.
 */
package io.github.fablabsmc.fablabs.impl.fiber.tree;

import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.SerializableType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.TypeCheckResult;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigLeaf;
import io.github.fablabsmc.fablabs.impl.fiber.tree.ConfigNodeImpl;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ConfigLeafImpl<T>
extends ConfigNodeImpl
implements ConfigLeaf<T> {
    private T value;
    @Nonnull
    private final T defaultValue;
    @Nonnull
    private BiConsumer<T, T> listener;
    @Nonnull
    private final SerializableType<T> type;

    public ConfigLeafImpl(@Nonnull String name, @Nonnull SerializableType<T> type, @Nullable String comment, @Nonnull T defaultValue, @Nonnull BiConsumer<T, T> listener) {
        super(name, comment);
        this.defaultValue = Objects.requireNonNull(defaultValue);
        this.listener = listener;
        this.type = type;
        this.setValue(defaultValue);
    }

    @Override
    @Nonnull
    public T getValue() {
        return this.value;
    }

    @Override
    public SerializableType<T> getConfigType() {
        return this.type;
    }

    @Override
    public boolean accepts(@Nonnull T value) {
        return this.type.accepts(value);
    }

    @Override
    public boolean setValue(@Nonnull T value) {
        T correctedValue;
        TypeCheckResult<T> result = this.type.test(value);
        if (result.hasPassed()) {
            correctedValue = value;
        } else {
            if (!result.getCorrectedValue().isPresent()) {
                return false;
            }
            correctedValue = result.getCorrectedValue().get();
        }
        T oldValue = this.value;
        this.value = Objects.requireNonNull(correctedValue);
        this.listener.accept(oldValue, this.value);
        return true;
    }

    @Override
    @Nonnull
    public BiConsumer<T, T> getListener() {
        return this.listener;
    }

    @Override
    public void addChangeListener(BiConsumer<T, T> listener) {
        this.listener = this.listener.andThen(listener);
    }

    @Override
    @Nonnull
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + '<' + this.type.getGenericPlatformType().getTypeName() + ">[name=" + this.getName() + ", comment=" + this.getComment() + ", value=" + this.getValue() + "]";
    }
}

