/*
 * Decompiled with CFR 0.152.
 */
package io.github.fablabsmc.fablabs.impl.fiber.constraint;

import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.StringSerializableType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.TypeCheckResult;
import io.github.fablabsmc.fablabs.impl.fiber.constraint.ConstraintChecker;
import java.util.regex.Pattern;

public final class StringConstraintChecker
extends ConstraintChecker<String, StringSerializableType> {
    private static final StringConstraintChecker INSTANCE = new StringConstraintChecker();

    public static StringConstraintChecker instance() {
        return INSTANCE;
    }

    private StringConstraintChecker() {
    }

    @Override
    public TypeCheckResult<String> test(StringSerializableType cfg, String value) {
        if (value.length() < cfg.getMinLength()) {
            return TypeCheckResult.unrecoverable();
        }
        if (value.length() > cfg.getMaxLength()) {
            return TypeCheckResult.unrecoverable();
        }
        Pattern pattern = cfg.getPattern();
        if (pattern != null && !pattern.matcher(value).matches()) {
            return TypeCheckResult.unrecoverable();
        }
        return TypeCheckResult.successful(value);
    }

    @Override
    public boolean comprehends(StringSerializableType cfg, StringSerializableType cfg2) {
        if (cfg.getMinLength() > cfg2.getMinLength()) {
            return false;
        }
        if (cfg.getMaxLength() < cfg2.getMaxLength()) {
            return false;
        }
        return cfg.getPattern() == null || cfg.getPattern().equals(cfg2.getPattern());
    }
}

