/*
 * Decompiled with CFR 0.152.
 */
package io.github.fablabsmc.fablabs.api.fiber.v1;

import io.github.fablabsmc.fablabs.api.fiber.v1.exception.DuplicateChildException;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.RuntimeFiberException;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigNode;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.Property;
import java.util.Iterator;

public class NodeOperations {
    public static void moveChildren(ConfigTree from, ConfigTree to) {
        try {
            Iterator it = from.getItems().iterator();
            while (it.hasNext()) {
                ConfigNode item = (ConfigNode)it.next();
                it.remove();
                to.getItems().add(item, true);
            }
        }
        catch (DuplicateChildException e) {
            throw new RuntimeFiberException("Failed to merge nodes", e);
        }
    }

    public static void moveNode(ConfigNode value, ConfigTree to) {
        try {
            value.detach();
            to.getItems().add(value, true);
        }
        catch (DuplicateChildException e) {
            throw new RuntimeFiberException("Failed to merge value", e);
        }
    }

    public static <T> void copyValue(Property<T> from, Property<T> to) {
        to.setValue(from.getValue());
    }
}

