/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec.format.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SelfDescribedSerializer;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationAttributes;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.util.RecursiveSerializer;
import java.util.Optional;

public class GsonSerializer
extends RecursiveSerializer<JsonElement>
implements SelfDescribedSerializer<JsonElement> {
    private JsonElement prefix;

    protected GsonSerializer(JsonElement prefix) {
        super(null);
        this.prefix = prefix;
    }

    public static GsonSerializer of(JsonElement prefix) {
        return new GsonSerializer(prefix);
    }

    public static GsonSerializer of() {
        return GsonSerializer.of(null);
    }

    public SerializationContext setupContext(SerializationContext ctx) {
        return super.setupContext(ctx).withAttributes(new SerializationAttribute.Instance[]{SerializationAttributes.HUMAN_READABLE});
    }

    public void writeByte(SerializationContext ctx, byte value) {
        this.consume(new JsonPrimitive((Number)value));
    }

    public void writeShort(SerializationContext ctx, short value) {
        this.consume(new JsonPrimitive((Number)value));
    }

    public void writeInt(SerializationContext ctx, int value) {
        this.consume(new JsonPrimitive((Number)value));
    }

    public void writeLong(SerializationContext ctx, long value) {
        this.consume(new JsonPrimitive((Number)value));
    }

    public void writeFloat(SerializationContext ctx, float value) {
        this.consume(new JsonPrimitive((Number)Float.valueOf(value)));
    }

    public void writeDouble(SerializationContext ctx, double value) {
        this.consume(new JsonPrimitive((Number)value));
    }

    public void writeVarInt(SerializationContext ctx, int value) {
        this.writeInt(ctx, value);
    }

    public void writeVarLong(SerializationContext ctx, long value) {
        this.writeLong(ctx, value);
    }

    public void writeBoolean(SerializationContext ctx, boolean value) {
        this.consume(new JsonPrimitive(Boolean.valueOf(value)));
    }

    public void writeString(SerializationContext ctx, String value) {
        this.consume(new JsonPrimitive(value));
    }

    public void writeBytes(SerializationContext ctx, byte[] bytes) {
        JsonArray result = new JsonArray(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            result.add((Number)bytes[i]);
        }
        this.consume(result);
    }

    public <V> void writeOptional(SerializationContext ctx, Endec<V> endec, Optional<V> optional) {
        optional.ifPresentOrElse(value -> endec.encode(ctx, (Serializer)this, value), () -> this.consume(JsonNull.INSTANCE));
    }

    public <E> Serializer.Sequence<E> sequence(SerializationContext ctx, Endec<E> elementEndec, int size) {
        return new Sequence<E>(ctx, elementEndec, size);
    }

    public <V> Serializer.Map<V> map(SerializationContext ctx, Endec<V> valueEndec, int size) {
        return new Map<V>(ctx, valueEndec);
    }

    public Serializer.Struct struct() {
        return new Map(null, null);
    }

    private class Sequence<V>
    implements Serializer.Sequence<V> {
        private final SerializationContext ctx;
        private final Endec<V> valueEndec;
        private final JsonArray result;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Sequence(SerializationContext ctx, Endec<V> valueEndec, int size) {
            this.ctx = ctx;
            this.valueEndec = valueEndec;
            if (GsonSerializer.this.prefix != null) {
                JsonArray prefixArray;
                JsonElement jsonElement = GsonSerializer.this.prefix;
                if (!(jsonElement instanceof JsonArray)) throw new IllegalStateException("Incompatible prefix of type " + GsonSerializer.this.prefix.getClass().getSimpleName() + " used for JSON sequence");
                this.result = prefixArray = (JsonArray)jsonElement;
                GsonSerializer.this.prefix = null;
                return;
            } else {
                this.result = new JsonArray(size);
            }
        }

        public void element(V element) {
            GsonSerializer.this.frame(encoded -> {
                this.valueEndec.encode(this.ctx, (Serializer)GsonSerializer.this, element);
                this.result.add((JsonElement)encoded.require("sequence element"));
            });
        }

        public void end() {
            GsonSerializer.this.consume(this.result);
        }
    }

    private class Map<V>
    implements Serializer.Map<V>,
    Serializer.Struct {
        private final SerializationContext ctx;
        private final Endec<V> valueEndec;
        private final JsonObject result;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Map(SerializationContext ctx, Endec<V> valueEndec) {
            this.ctx = ctx;
            this.valueEndec = valueEndec;
            if (GsonSerializer.this.prefix != null) {
                JsonObject prefixObject;
                JsonElement jsonElement = GsonSerializer.this.prefix;
                if (!(jsonElement instanceof JsonObject)) throw new IllegalStateException("Incompatible prefix of type " + GsonSerializer.this.prefix.getClass().getSimpleName() + " used for JSON map/struct");
                this.result = prefixObject = (JsonObject)jsonElement;
                GsonSerializer.this.prefix = null;
                return;
            } else {
                this.result = new JsonObject();
            }
        }

        public void entry(String key, V value) {
            GsonSerializer.this.frame(encoded -> {
                this.valueEndec.encode(this.ctx, (Serializer)GsonSerializer.this, value);
                this.result.add(key, (JsonElement)encoded.require("map value"));
            });
        }

        public <F> Serializer.Struct field(String name, SerializationContext ctx, Endec<F> endec, F value, boolean mayOmit) {
            GsonSerializer.this.frame(encoded -> {
                endec.encode(ctx, (Serializer)GsonSerializer.this, value);
                JsonElement element = (JsonElement)encoded.require("struct field");
                if (mayOmit && element.equals(JsonNull.INSTANCE)) {
                    return;
                }
                this.result.add(name, element);
            });
            return this;
        }

        public void end() {
            GsonSerializer.this.consume(this.result);
        }
    }
}

