/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec.format.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonStreamParser;
import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SelfDescribedDeserializer;
import io.wispforest.endec.SelfDescribedSerializer;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.format.gson.GsonDeserializer;
import io.wispforest.endec.format.gson.GsonSerializer;

public final class GsonEndec
implements Endec<JsonElement> {
    public static final GsonEndec INSTANCE = new GsonEndec();

    private GsonEndec() {
    }

    public void encode(SerializationContext ctx, Serializer<?> serializer, JsonElement value) {
        if (serializer instanceof SelfDescribedSerializer) {
            GsonDeserializer.of(value).readAny(ctx, serializer);
            return;
        }
        serializer.writeString(ctx, value.toString());
    }

    public JsonElement decode(SerializationContext ctx, Deserializer<?> deserializer) {
        if (deserializer instanceof SelfDescribedDeserializer) {
            SelfDescribedDeserializer selfDescribedDeserializer = (SelfDescribedDeserializer)deserializer;
            GsonSerializer json = GsonSerializer.of();
            selfDescribedDeserializer.readAny(ctx, (Serializer)json);
            return (JsonElement)json.result();
        }
        return new JsonStreamParser(deserializer.readString(ctx)).next();
    }
}

